/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Locale;
import org.jboss.seam.core.Pages;
import org.jboss.seam.pages.Action;
import org.jboss.seam.pages.ConversationControl;
import org.jboss.seam.pages.Input;
import org.jboss.seam.pages.Navigation;
import org.jboss.seam.pages.Param;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Page {
    private final String viewId;
    private String description;
    private Integer timeout;
    private String noConversationViewId;
    private String resourceBundleName;
    private boolean switchEnabled = true;
    private List<Param> parameters = new ArrayList<Param>();
    private List<Input> inputs = new ArrayList<Input>();
    private List<Action> actions = new ArrayList<Action>();
    private Map<String, Navigation> navigations = new HashMap<String, Navigation>();
    private Navigation defaultNavigation;
    private boolean conversationRequired;
    private ConversationControl conversationControl = new ConversationControl();
    private boolean restricted;
    private String restriction;

    public Page(String viewId) {
        int loc;
        this.viewId = viewId;
        if (viewId != null && (loc = viewId.lastIndexOf(46)) > 0 && viewId.startsWith("/")) {
            this.setResourceBundleName(viewId.substring(1, loc));
        }
    }

    public ResourceBundle getResourceBundle() {
        String resourceBundleName = this.getResourceBundleName();
        if (resourceBundleName == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle(resourceBundleName, Locale.instance(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public String toString() {
        return "Page(" + this.getViewId() + ")";
    }

    public String getViewId() {
        return this.viewId;
    }

    public String renderDescription() {
        return Interpolator.instance().interpolate(this.getDescription(), new Object[0]);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setNoConversationViewId(String noConversationViewId) {
        this.noConversationViewId = noConversationViewId;
    }

    public String getNoConversationViewId() {
        return this.noConversationViewId;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setSwitchEnabled(boolean switchEnabled) {
        this.switchEnabled = switchEnabled;
    }

    public boolean isSwitchEnabled() {
        return this.switchEnabled;
    }

    public List<Param> getParameters() {
        return this.parameters;
    }

    public Map<String, Navigation> getNavigations() {
        return this.navigations;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean isConversationRequired() {
        return this.conversationRequired;
    }

    public void setConversationRequired(boolean conversationRequired) {
        this.conversationRequired = conversationRequired;
    }

    public Navigation getDefaultNavigation() {
        return this.defaultNavigation;
    }

    public void setDefaultNavigation(Navigation defaultActionOutcomeMapping) {
        this.defaultNavigation = defaultActionOutcomeMapping;
    }

    public ConversationControl getConversationControl() {
        return this.conversationControl;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public boolean enter(FacesContext facesContext) {
        if (this.isRestricted()) {
            String expr = this.restriction;
            if (expr == null) {
                expr = String.format("#{s:hasPermission('%s', 'render', null)}", this.getViewId());
            }
            Identity.instance().checkRestriction(expr);
        }
        boolean result = false;
        this.getConversationControl().beginOrEndConversation();
        for (Input in : this.getInputs()) {
            in.in();
        }
        for (Action action : this.getActions()) {
            String outcome;
            if (!action.isExecutable()) continue;
            String fromAction = outcome = action.getOutcome();
            if (outcome == null) {
                fromAction = action.getMethodBinding().getExpressionString();
                result = true;
                outcome = Pages.toString(action.getMethodBinding().invoke(new Object[0]));
                Pages.handleOutcome(facesContext, outcome, fromAction);
                continue;
            }
            Pages.handleOutcome(facesContext, outcome, fromAction);
        }
        return result;
    }

    public List<Input> getInputs() {
        return this.inputs;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public String getRestriction() {
        return this.restriction;
    }

    public void setRestriction(String restriction) {
        this.restriction = restriction;
    }
}

