/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Selector;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Configuration;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.security.PermissionCheck;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.SimpleGroup;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.util.UnifiedELValueBinding;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0, classDependencies={"org.drools.WorkingMemory"})
@Intercept(value=InterceptionType.NEVER)
@Startup
public class Identity
extends Selector {
    private static final long serialVersionUID = 3751659008033189259L;
    private static final LogProvider log = Logging.getLogProvider(Identity.class);
    public static final String RULES_COMPONENT_NAME = "securityRules";
    private String username;
    private String password;
    private Expressions.MethodBinding authenticateMethod;
    private Principal principal;
    private Subject subject;
    private WorkingMemory securityContext;
    private RuleBase securityRules;
    private String jaasConfigName = null;
    private List<String> preAuthenticationRoles = new ArrayList<String>();

    protected String getCookieName() {
        return "org.jboss.seam.security.username";
    }

    @Create
    public void create() {
        this.subject = new Subject();
        this.initSecurityContext();
        this.initCredentialsFromCookie();
    }

    private void initCredentialsFromCookie() {
        this.setCookieEnabled(true);
        this.username = this.getCookieValue();
        this.setDirty();
        this.setCookieEnabled(false);
        if (this.username != null) {
            this.postRememberMe();
        }
    }

    protected void postRememberMe() {
        Events.instance().raiseEvent("org.jboss.seam.rememberMe", new Object[0]);
    }

    protected void initSecurityContext() {
        if (this.securityRules == null) {
            this.securityRules = (RuleBase)Component.getInstance(RULES_COMPONENT_NAME, true);
        }
        if (this.securityRules != null) {
            this.securityContext = this.securityRules.newWorkingMemory(false);
        }
    }

    public static Identity instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Identity instance = (Identity)Component.getInstance(Identity.class, ScopeType.SESSION, true);
        if (instance == null) {
            throw new IllegalStateException("No Identity could be created");
        }
        return instance;
    }

    public boolean isLoggedIn() {
        return this.getPrincipal() != null;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void checkRestriction(String expr) {
        if (!this.evaluateExpression(expr)) {
            if (!this.isLoggedIn()) {
                Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                throw new NotLoggedInException(String.format("Error evaluating expression [%s] - User not logged in", expr));
            }
            throw new AuthorizationException(String.format("Authorization check failed for expression [%s]", expr));
        }
    }

    public String login() {
        try {
            this.authenticate();
            log.debug("Login successful for: #0" + this.getUsername());
            FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_INFO, "org.jboss.seam.loginSuccessful", "Welcome, #0", this.getUsername());
            return "success";
        }
        catch (LoginException ex) {
            log.debug("Login failed for:" + this.getUsername(), ex);
            FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_INFO, "org.jboss.seam.loginFailed", "Login failed", ex);
            return null;
        }
    }

    public void authenticate() throws LoginException {
        this.authenticate(this.getLoginContext());
    }

    public void authenticate(LoginContext loginContext) throws LoginException {
        this.preAuthenticate();
        loginContext.login();
        this.postAuthenticate();
    }

    protected void preAuthenticate() {
        this.preAuthenticationRoles.clear();
        Events.instance().raiseEvent("org.jboss.seam.preAuthenticate", new Object[0]);
    }

    protected void postAuthenticate() {
        this.populateSecurityContext();
        if (!this.preAuthenticationRoles.isEmpty() && this.isLoggedIn()) {
            for (String role : this.preAuthenticationRoles) {
                this.addRole(role);
            }
            this.preAuthenticationRoles.clear();
        }
        this.setCookieValue(this.getUsername());
        this.password = null;
        this.setDirty();
        Events.instance().raiseEvent("org.jboss.seam.postAuthenticate", new Object[0]);
    }

    protected void populateSecurityContext() {
        WorkingMemory securityContext = this.getSecurityContext();
        this.assertSecurityContextExists();
        for (Principal p : this.getSubject().getPrincipals()) {
            if (p instanceof Group && "roles".equals(((Group)p).getName())) {
                Enumeration e = ((Group)p).members();
                while (e.hasMoreElements()) {
                    Principal role = (Principal)e.nextElement();
                    securityContext.assertObject((Object)new Role(role.getName()));
                }
                continue;
            }
            if (this.principal == null) {
                this.principal = p;
                this.setDirty();
            }
            securityContext.assertObject((Object)p);
        }
    }

    private void assertSecurityContextExists() {
        if (this.securityContext == null) {
            throw new IllegalStateException("no security rule base available - please install a RuleBase with the name 'securityRules'");
        }
    }

    protected void unAuthenticate() {
        for (Role role : this.getSecurityContext().getObjects(Role.class)) {
            this.getSecurityContext().retractObject(this.getSecurityContext().getFactHandle((Object)role));
        }
        for (Group sg : this.subject.getPrincipals(Group.class)) {
            if (!"roles".equals(sg.getName())) continue;
            this.subject.getPrincipals().remove(sg);
            break;
        }
    }

    protected LoginContext getLoginContext() throws LoginException {
        if (this.getJaasConfigName() != null) {
            return new LoginContext(this.getJaasConfigName(), this.subject, this.getDefaultCallbackHandler());
        }
        return new LoginContext("default", this.subject, this.getDefaultCallbackHandler(), Configuration.instance());
    }

    public void logout() {
        this.principal = null;
        Seam.invalidateSession();
    }

    public boolean hasRole(String role) {
        for (Group sg : this.subject.getPrincipals(Group.class)) {
            if (!"roles".equals(sg.getName())) continue;
            return sg.isMember((Principal)new SimplePrincipal(role));
        }
        return false;
    }

    public void addRole(String role) {
        if (!this.isLoggedIn()) {
            this.preAuthenticationRoles.add(role);
        } else {
            for (Group sg : this.subject.getPrincipals(Group.class)) {
                if (!"roles".equals(sg.getName())) continue;
                this.getSecurityContext().assertObject((Object)new Role(role));
                sg.addMember((Principal)new SimplePrincipal(role));
                return;
            }
            this.getSecurityContext().assertObject((Object)new Role(role));
            SimpleGroup roleGroup = new SimpleGroup("roles");
            roleGroup.addMember(new SimplePrincipal(role));
            this.subject.getPrincipals().add((Principal)((Object)roleGroup));
        }
    }

    public void removeRole(String role) {
        for (Role r : this.getSecurityContext().getObjects(Role.class)) {
            if (!r.getName().equals(role)) continue;
            FactHandle fh = this.getSecurityContext().getFactHandle((Object)r);
            this.getSecurityContext().retractObject(fh);
            break;
        }
        block1: for (Group sg : this.subject.getPrincipals(Group.class)) {
            if (!"roles".equals(sg.getName())) continue;
            Enumeration e = sg.members();
            while (e.hasMoreElements()) {
                Principal member = (Principal)e.nextElement();
                if (!member.getName().equals(role)) continue;
                sg.removeMember(member);
                continue block1;
            }
        }
    }

    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            if (!this.isLoggedIn()) {
                Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                throw new NotLoggedInException();
            }
            throw new AuthorizationException(String.format("Authorization check failed for role [%s]", role));
        }
    }

    public void checkPermission(String name, String action, Object ... arg) {
        if (!this.hasPermission(name, action, arg)) {
            if (!this.isLoggedIn()) {
                Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
                throw new NotLoggedInException();
            }
            throw new AuthorizationException(String.format("Authorization check failed for permission [%s,%s]", name, action));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(String name, String action, Object ... arg) {
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        PermissionCheck check = new PermissionCheck(name, action);
        WorkingMemory securityContext = this.getSecurityContext();
        this.assertSecurityContextExists();
        WorkingMemory workingMemory = securityContext;
        synchronized (workingMemory) {
            handles.add(securityContext.assertObject((Object)check));
            for (int i = 0; i < arg.length; ++i) {
                if (i == 0 && arg[0] instanceof Collection) {
                    for (Object value : (Collection)arg[i]) {
                        if (securityContext.getFactHandle(value) != null) continue;
                        handles.add(securityContext.assertObject(value));
                    }
                    continue;
                }
                handles.add(securityContext.assertObject(arg[i]));
            }
            securityContext.fireAllRules();
            for (FactHandle handle : handles) {
                securityContext.retractObject(handle);
            }
        }
        return check.isGranted();
    }

    protected CallbackHandler getDefaultCallbackHandler() {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(Identity.this.getUsername());
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(Identity.this.getPassword() != null ? Identity.this.getPassword().toCharArray() : null);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i], "Unsupported callback");
                }
            }
        };
    }

    protected boolean evaluateExpression(String expr) {
        return (Boolean)new UnifiedELValueBinding(expr).getValue(FacesContext.getCurrentInstance());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.setDirty(this.username, username);
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.setDirty(this.password, password);
        this.password = password;
    }

    public WorkingMemory getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(WorkingMemory securityContext) {
        this.securityContext = securityContext;
    }

    public Expressions.MethodBinding getAuthenticateMethod() {
        return this.authenticateMethod;
    }

    public void setAuthenticateMethod(Expressions.MethodBinding authMethod) {
        this.authenticateMethod = authMethod;
    }

    public boolean isRememberMe() {
        return this.isCookieEnabled();
    }

    public void setRememberMe(boolean remember) {
        this.setCookieEnabled(remember);
    }

    public String getJaasConfigName() {
        return this.jaasConfigName;
    }

    public void setJaasConfigName(String jaasConfigName) {
        this.jaasConfigName = jaasConfigName;
    }

    public RuleBase getSecurityRules() {
        return this.securityRules;
    }

    public void setSecurityRules(RuleBase securityRules) {
        this.securityRules = securityRules;
    }
}

