/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import com.octo.captcha.service.CaptchaServiceException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.captcha.CaptchaService;
import org.jboss.seam.contexts.Lifecycle;

public class CaptchaServlet
extends HttpServlet {
    private ServletContext context;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Lifecycle.beginRequest(this.context, request.getSession(), (ServletRequest)request);
            String captchaId = request.getQueryString();
            BufferedImage challenge = CaptchaService.instance().getService().getImageChallengeForID(captchaId, request.getLocale());
            ImageIO.write((RenderedImage)challenge, "jpeg", out);
        }
        catch (IllegalArgumentException e) {
            response.sendError(404);
            return;
        }
        catch (CaptchaServiceException e) {
            response.sendError(500);
            return;
        }
        finally {
            Lifecycle.endRequest();
        }
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        response.getOutputStream().write(out.toByteArray());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }
}

