/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.contexts.WebApplicationContext;
import org.jboss.seam.servlet.MultipartConfig;
import org.jboss.seam.servlet.MultipartRequest;
import org.jboss.seam.servlet.SeamFilter;

public class SeamMultipartFilter
extends SeamFilter {
    public static final String MULTIPART = "multipart/";
    private MultipartConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        WebApplicationContext appContext = new WebApplicationContext(this.getServletContext());
        this.config = (MultipartConfig)appContext.get(MultipartConfig.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isMultipartRequest(httpRequest)) {
            chain.doFilter((ServletRequest)new MultipartRequest(httpRequest, this.config), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }
}

