/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import javax.transaction.UserTransaction;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Transactions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Work<T> {
    private static final LogProvider log = Logging.getLogProvider(Work.class);

    protected abstract T work() throws Exception;

    protected boolean isNewTransactionRequired(boolean transactionActive) {
        return !transactionActive;
    }

    public final T workInTransaction() throws Exception {
        UserTransaction userTransaction;
        boolean transactionActive = Transactions.isTransactionActiveOrMarkedRollback();
        boolean begin = this.isNewTransactionRequired(transactionActive);
        Object object = userTransaction = begin ? Transactions.getUserTransaction() : null;
        if (begin) {
            log.debug("beginning transaction");
            userTransaction.begin();
        }
        try {
            T result = this.work();
            if (begin) {
                log.debug("committing transaction");
                userTransaction.commit();
            }
            return result;
        }
        catch (Exception e) {
            if (begin) {
                log.debug("rolling back transaction");
                userTransaction.rollback();
            }
            throw e;
        }
    }
}

