/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Pages;
import org.jboss.seam.exceptions.AnnotationErrorHandler;
import org.jboss.seam.exceptions.AnnotationRedirectHandler;
import org.jboss.seam.exceptions.ConfigErrorHandler;
import org.jboss.seam.exceptions.ConfigRedirectHandler;
import org.jboss.seam.exceptions.DebugPageHandler;
import org.jboss.seam.exceptions.ExceptionHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Install(precedence=0)
@Name(value="org.jboss.seam.core.exceptions")
public class Exceptions {
    private static final LogProvider log = Logging.getLogProvider(Exceptions.class);
    private List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();

    public void handle(Exception e) throws Exception {
        if (Contexts.isConversationContextActive()) {
            Contexts.getConversationContext().set("org.jboss.seam.exception", e);
        }
        ArrayList<Exception> causes = new ArrayList<Exception>();
        Exception cause = e;
        while (cause != null) {
            causes.add(cause);
            cause = EJB.getCause(cause);
        }
        for (ExceptionHandler eh : this.exceptionHandlers) {
            for (int i = causes.size() - 1; i >= 0; --i) {
                Exception cause2 = (Exception)causes.get(i);
                if (!eh.isHandler(cause2)) continue;
                if (Contexts.isConversationContextActive()) {
                    Contexts.getConversationContext().set("org.jboss.seam.handledException", cause2);
                }
                eh.handle(cause2);
                return;
            }
        }
        throw e;
    }

    @Create
    public void initialize() throws Exception {
        ExceptionHandler anyhandler1 = this.parse("/WEB-INF/exceptions.xml");
        ExceptionHandler anyhandler2 = this.parse("/WEB-INF/pages.xml");
        this.exceptionHandlers.add(new AnnotationRedirectHandler());
        this.exceptionHandlers.add(new AnnotationErrorHandler());
        if (Init.instance().isDebug()) {
            this.exceptionHandlers.add(new DebugPageHandler());
        }
        if (anyhandler1 != null) {
            this.exceptionHandlers.add(anyhandler1);
        }
        if (anyhandler2 != null) {
            this.exceptionHandlers.add(anyhandler2);
        }
    }

    private ExceptionHandler parse(String fileName) throws DocumentException, ClassNotFoundException {
        ExceptionHandler anyhandler = null;
        InputStream stream = Resources.getResourceAsStream(fileName);
        if (stream != null) {
            log.debug("reading exception mappings from " + fileName);
            List elements = XML.getRootElement(stream).elements("exception");
            for (Element exception : elements) {
                String className = exception.attributeValue("class");
                if (className == null) {
                    anyhandler = this.createHandler(exception, Exception.class);
                    continue;
                }
                ExceptionHandler handler = this.createHandler(exception, Reflections.classForName(className));
                if (handler == null) continue;
                this.exceptionHandlers.add(handler);
            }
        }
        return anyhandler;
    }

    private ExceptionHandler createHandler(Element exception, Class clazz) {
        boolean endConversation = exception.elementIterator("end-conversation").hasNext();
        Element redirect = exception.element("redirect");
        if (redirect != null) {
            String viewId = redirect.attributeValue("view-id");
            Element messageElement = redirect.element("message");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            String severityName = messageElement == null ? null : messageElement.attributeValue("severity");
            FacesMessage.Severity severity = severityName == null ? FacesMessage.SEVERITY_INFO : Pages.getFacesMessageValuesMap().get(severityName.toUpperCase());
            return new ConfigRedirectHandler(viewId, clazz, endConversation, message, severity);
        }
        Element error = exception.element("http-error");
        if (error != null) {
            String errorCode = error.attributeValue("error-code");
            int code = Strings.isEmpty(errorCode) ? 500 : Integer.parseInt(errorCode);
            Element messageElement = error.element("message");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            return new ConfigErrorHandler(message, endConversation, clazz, code);
        }
        return null;
    }

    public static Exceptions instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Exceptions)Component.getInstance(Exceptions.class, ScopeType.APPLICATION);
    }
}

