/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.core.facesMessages")
@Install(precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class FacesMessages
implements Serializable {
    private static final long serialVersionUID = -5395975397632138270L;
    private transient List<Runnable> tasks;
    private List<Message> facesMessages = new ArrayList<Message>();
    private Map<String, List<Message>> keyedFacesMessages = new HashMap<String, List<Message>>();

    public void beforeRenderResponse() {
        for (Message message : this.facesMessages) {
            FacesContext.getCurrentInstance().addMessage(null, message.toFacesMessage());
        }
        for (Map.Entry entry : this.keyedFacesMessages.entrySet()) {
            for (Message msg : (List)entry.getValue()) {
                FacesContext.getCurrentInstance().addMessage((String)entry.getKey(), msg.toFacesMessage());
            }
        }
        this.clear();
    }

    public List<FacesMessage> getCurrentMessages() {
        ArrayList<FacesMessage> result = new ArrayList<FacesMessage>();
        Iterator iter = FacesContext.getCurrentInstance().getMessages();
        while (iter.hasNext()) {
            result.add((FacesMessage)iter.next());
        }
        return result;
    }

    public List<FacesMessage> getCurrentGlobalMessages() {
        ArrayList<FacesMessage> result = new ArrayList<FacesMessage>();
        Iterator iter = FacesContext.getCurrentInstance().getMessages(null);
        while (iter.hasNext()) {
            result.add((FacesMessage)iter.next());
        }
        return result;
    }

    private void runTasks() {
        if (this.tasks != null) {
            for (Runnable task : this.tasks) {
                task.run();
            }
            this.tasks.clear();
        }
    }

    public static void afterPhase() {
        FacesMessages instance;
        if (Contexts.isConversationContextActive() && (instance = (FacesMessages)Component.getInstance(FacesMessages.class, ScopeType.CONVERSATION, false)) != null) {
            instance.runTasks();
        }
    }

    public void clear() {
        this.facesMessages.clear();
        this.keyedFacesMessages.clear();
    }

    public void add(FacesMessage facesMessage) {
        if (facesMessage != null) {
            this.facesMessages.add(new Message(facesMessage));
        }
    }

    public void addToControl(String id, FacesMessage facesMessage) {
        if (facesMessage != null) {
            String clientId = this.getClientId(id);
            List<Message> list = this.keyedFacesMessages.get(clientId);
            if (list == null) {
                list = new ArrayList<Message>();
                this.keyedFacesMessages.put(clientId, list);
            }
            list.add(new Message(facesMessage));
        }
    }

    public void add(String messageTemplate, Object ... params) {
        this.addToTasks(FacesMessage.SEVERITY_INFO, null, messageTemplate, params);
    }

    public void add(FacesMessage.Severity severity, String messageTemplate, Object ... params) {
        this.addToTasks(severity, null, messageTemplate, params);
    }

    public void addToControl(String id, String messageTemplate, Object ... params) {
        this.addToControl(id, FacesMessage.SEVERITY_INFO, messageTemplate, params);
    }

    public void addToControl(String id, FacesMessage.Severity severity, String messageTemplate, Object ... params) {
        this.addToTasks(id, severity, null, messageTemplate, params);
    }

    public void addFromResourceBundle(String key, Object ... params) {
        this.addFromResourceBundle(FacesMessage.SEVERITY_INFO, key, params);
    }

    public void addFromResourceBundle(FacesMessage.Severity severity, String key, Object ... params) {
        this.addFromResourceBundleOrDefault(severity, key, key, params);
    }

    public void addFromResourceBundleOrDefault(String key, String defaultMessageTemplate, Object ... params) {
        this.addFromResourceBundleOrDefault(FacesMessage.SEVERITY_INFO, key, defaultMessageTemplate, params);
    }

    public void addFromResourceBundleOrDefault(FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.addToTasks(severity, key, defaultMessageTemplate, params);
    }

    public void addToControlFromResourceBundle(String id, String key, Object ... params) {
        this.addToControlFromResourceBundle(id, FacesMessage.SEVERITY_INFO, key, params);
    }

    public void addToControlFromResourceBundle(String id, FacesMessage.Severity severity, String key, Object ... params) {
        this.addToControlFromResourceBundleOrDefault(id, severity, key, key, params);
    }

    public void addToControlFromResourceBundleOrDefault(String id, String key, String defaultMessageTemplate, Object ... params) {
        this.addToControlFromResourceBundleOrDefault(id, FacesMessage.SEVERITY_INFO, key, defaultMessageTemplate, params);
    }

    public void addToControlFromResourceBundleOrDefault(String id, FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.addToTasks(id, severity, key, defaultMessageTemplate, params);
    }

    private static String interpolateBundleMessage(String key, String defaultMessageTemplate) {
        java.util.ResourceBundle resourceBundle;
        String messageTemplate = defaultMessageTemplate;
        if (key != null && (resourceBundle = ResourceBundle.instance()) != null) {
            try {
                String bundleMessage = resourceBundle.getString(key);
                if (bundleMessage != null) {
                    messageTemplate = bundleMessage;
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        return messageTemplate;
    }

    public void add(InvalidValue[] ivs) {
        for (InvalidValue iv : ivs) {
            this.add(iv);
        }
    }

    public void addToControls(InvalidValue[] ivs) {
        for (InvalidValue iv : ivs) {
            this.addToControl(iv);
        }
    }

    public void add(InvalidValue iv) {
        this.add(FacesMessage.SEVERITY_WARN, iv.getMessage(), new Object[0]);
    }

    public void addToControl(InvalidValue iv) {
        this.addToControl(iv.getPropertyName(), iv);
    }

    public void addToControl(String id, InvalidValue iv) {
        this.addToControl(id, FacesMessage.SEVERITY_WARN, iv.getMessage(), new Object[0]);
    }

    public static FacesMessage createFacesMessage(FacesMessage.Severity severity, String messageTemplate, Object ... params) {
        return new FacesMessage(severity, Interpolator.instance().interpolate(messageTemplate, params), null);
    }

    public static FacesMessage createFacesMessage(FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        String message = FacesMessages.interpolateBundleMessage(key, defaultMessageTemplate);
        if (!Strings.isEmpty(message)) {
            return FacesMessages.createFacesMessage(severity, message, params);
        }
        return null;
    }

    private String getClientId(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return FacesMessages.getClientId((UIComponent)facesContext.getViewRoot(), id, facesContext);
    }

    private static String getClientId(UIComponent component, String id, FacesContext facesContext) {
        String componentId = component.getId();
        if (componentId != null && componentId.equals(id)) {
            return component.getClientId(facesContext);
        }
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            String clientId = FacesMessages.getClientId(child, id, facesContext);
            if (clientId == null) continue;
            return clientId;
        }
        return null;
    }

    private List<Runnable> getTasks() {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Runnable>();
        }
        return this.tasks;
    }

    private void addToTasks(final FacesMessage.Severity severity, final String key, final String messageTemplate, final Object ... params) {
        this.getTasks().add(new Runnable(){

            public void run() {
                FacesMessages.this.add(FacesMessages.createFacesMessage(severity, key, messageTemplate, params));
            }
        });
    }

    private void addToTasks(final String id, final FacesMessage.Severity severity, final String key, final String messageTemplate, final Object ... params) {
        this.getTasks().add(new Runnable(){

            public void run() {
                FacesMessages.this.addToControl(id, FacesMessages.createFacesMessage(severity, key, messageTemplate, params));
            }
        });
    }

    public static FacesMessages instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (FacesMessages)Component.getInstance(FacesMessages.class, ScopeType.CONVERSATION);
    }

    class Message
    implements Serializable {
        private String summary;
        private String detail;
        private int severityOrdinal;

        Message(FacesMessage fm) {
            this.summary = fm.getSummary();
            this.detail = fm.getDetail();
            this.severityOrdinal = fm.getSeverity().getOrdinal();
        }

        FacesMessage toFacesMessage() {
            Object o;
            FacesMessage.Severity severity = null;
            Iterator i$ = FacesMessage.VALUES.iterator();
            while (i$.hasNext() && (severity = (FacesMessage.Severity)(o = i$.next())).getOrdinal() != this.severityOrdinal) {
            }
            return new FacesMessage(severity, this.summary, this.detail);
        }
    }
}

