/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.FacesPage;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.SafeActions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.pages.Action;
import org.jboss.seam.pages.ConversationControl;
import org.jboss.seam.pages.ConversationIdParameter;
import org.jboss.seam.pages.ELConversationIdParameter;
import org.jboss.seam.pages.Input;
import org.jboss.seam.pages.Navigation;
import org.jboss.seam.pages.Output;
import org.jboss.seam.pages.Page;
import org.jboss.seam.pages.Param;
import org.jboss.seam.pages.ProcessControl;
import org.jboss.seam.pages.RedirectNavigationHandler;
import org.jboss.seam.pages.RenderNavigationHandler;
import org.jboss.seam.pages.Rule;
import org.jboss.seam.pages.TaskControl;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.util.Parameters;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.pages")
@Install(precedence=0)
public class Pages {
    private static final LogProvider log = Logging.getLogProvider(Pages.class);
    private Map<String, Page> pagesByViewId = Collections.synchronizedMap(new HashMap());
    private Map<String, List<Page>> pageStacksByViewId = Collections.synchronizedMap(new HashMap());
    private String noConversationViewId;
    private String loginViewId;
    private Map<String, ConversationIdParameter> conversations = Collections.synchronizedMap(new HashMap());
    private Integer httpPort = null;
    private Integer httpsPort = null;
    private SortedSet<String> wildcardViewIds = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String x, String y) {
            if (x.length() < y.length()) {
                return -1;
            }
            if (x.length() > y.length()) {
                return 1;
            }
            return x.compareTo(y);
        }
    });

    @Create
    public void initialize() {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/pages.xml");
        if (stream == null) {
            log.debug("no pages.xml file found");
        } else {
            log.debug("reading pages.xml");
            this.parse(stream);
        }
    }

    public boolean navigate(FacesContext context, String actionExpression, String actionOutcomeValue) {
        String viewId = Pages.getViewId(context);
        if (viewId != null) {
            List<Page> stack = this.getPageStack(viewId);
            for (int i = stack.size() - 1; i >= 0; --i) {
                Page page = stack.get(i);
                Navigation navigation = page.getNavigations().get(actionExpression);
                if (navigation == null) {
                    navigation = page.getDefaultNavigation();
                }
                if (navigation == null || !navigation.navigate(context, actionOutcomeValue)) continue;
                return true;
            }
        }
        return false;
    }

    public Page getPage(String viewId) {
        if (viewId == null) {
            return new Page(viewId);
        }
        Page result = this.getCachedPage(viewId);
        if (result == null) {
            return this.createPage(viewId);
        }
        return result;
    }

    private Page createPage(String viewId) {
        InputStream stream;
        String resourceName = Pages.replaceExtension(viewId, ".page.xml");
        InputStream inputStream = stream = resourceName == null ? null : Resources.getResourceAsStream(resourceName.substring(1));
        if (stream == null) {
            Page result = new Page(viewId);
            this.pagesByViewId.put(viewId, result);
            return result;
        }
        this.parse(stream, viewId);
        return this.getCachedPage(viewId);
    }

    private Page getCachedPage(String viewId) {
        Page result = this.pagesByViewId.get(viewId);
        if (result == null && (viewId = Pages.replaceExtension(viewId, Pages.getSuffix())) != null) {
            result = this.pagesByViewId.get(viewId);
        }
        return result;
    }

    private static String replaceExtension(String viewId, String suffix) {
        int loc = viewId.lastIndexOf(46);
        return loc < 0 ? null : viewId.substring(0, loc) + suffix;
    }

    protected List<Page> getPageStack(String viewId) {
        List<Page> stack = this.pageStacksByViewId.get(viewId);
        if (stack == null) {
            stack = this.createPageStack(viewId);
            this.pageStacksByViewId.put(viewId, stack);
        }
        return stack;
    }

    private List<Page> createPageStack(String viewId) {
        Page page;
        ArrayList<Page> stack = new ArrayList<Page>(1);
        if (viewId != null) {
            for (String wildcard : this.wildcardViewIds) {
                if (!viewId.startsWith(wildcard.substring(0, wildcard.length() - 1))) continue;
                stack.add(this.getPage(wildcard));
            }
        }
        if ((page = this.getPage(viewId)) != null) {
            stack.add(page);
        }
        return stack;
    }

    public boolean enterPage(FacesContext facesContext) {
        String scheme;
        boolean result = false;
        String viewId = Pages.getViewId(facesContext);
        String requestScheme = Pages.getRequestScheme(facesContext);
        if (requestScheme != null && (scheme = this.getScheme(viewId)) != null && !requestScheme.equals(scheme)) {
            Manager.instance().redirect(viewId);
            return result;
        }
        for (Page page : this.getPageStack(viewId)) {
            if (this.isNoConversationRedirectRequired(page)) {
                this.redirectToNoConversationView();
                return result;
            }
            if (this.isLoginRedirectRequired(viewId, page)) {
                this.redirectToLoginView();
                return result;
            }
            result = page.enter(facesContext) || result;
        }
        result = Pages.callAction(facesContext) || result;
        return result;
    }

    private boolean isNoConversationRedirectRequired(Page page) {
        return page.isConversationRequired() && !Manager.instance().isLongRunningConversation();
    }

    private boolean isLoginRedirectRequired(String viewId, Page page) {
        return page.isLoginRequired() && !viewId.equals(this.getLoginViewId()) && !Identity.instance().isLoggedIn();
    }

    private static String getRequestScheme(FacesContext facesContext) {
        String requestUrl = Pages.getRequestUrl(facesContext);
        if (requestUrl == null) {
            return null;
        }
        int idx = requestUrl.indexOf(58);
        return idx < 0 ? null : requestUrl.substring(0, idx);
    }

    public String encodeScheme(String viewId, FacesContext context, String url) {
        String requestUrl;
        String scheme = this.getScheme(viewId);
        if (scheme != null && (requestUrl = Pages.getRequestUrl(context)) != null) {
            try {
                URL serverUrl = new URL(requestUrl);
                StringBuilder sb = new StringBuilder();
                sb.append(scheme);
                sb.append("://");
                sb.append(serverUrl.getHost());
                if ("http".equals(scheme) && this.httpPort != null) {
                    sb.append(":");
                    sb.append(this.httpPort);
                } else if ("https".equals(scheme) && this.httpsPort != null) {
                    sb.append(":");
                    sb.append(this.httpsPort);
                } else if (serverUrl.getPort() != -1) {
                    sb.append(":");
                    sb.append(serverUrl.getPort());
                }
                if (!url.startsWith("/")) {
                    sb.append("/");
                }
                sb.append(url);
                url = sb.toString();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return url;
    }

    private static String getRequestUrl(FacesContext facesContext) {
        Object request = facesContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getRequestURL().toString();
        }
        return null;
    }

    public void redirectToLoginView() {
        this.notLoggedIn();
        String loginViewId = this.getLoginViewId();
        if (loginViewId == null) {
            throw new NotLoggedInException();
        }
        Manager.instance().redirect(loginViewId);
    }

    public void redirectToNoConversationView() {
        this.noConversation();
        FacesPage facesPage = FacesPage.instance();
        String pageflowName = facesPage.getPageflowName();
        String pageflowNodeName = facesPage.getPageflowNodeName();
        String noConversationViewId = null;
        if (pageflowName == null || pageflowNodeName == null) {
            String viewId = Pages.getCurrentViewId();
            noConversationViewId = this.getNoConversationViewId(viewId);
        } else {
            noConversationViewId = Pageflow.instance().getNoConversationViewId(pageflowName, pageflowNodeName);
        }
        if (noConversationViewId != null) {
            Manager.instance().redirect(noConversationViewId);
        }
    }

    public String getScheme(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        for (int i = stack.size() - 1; i >= 0; --i) {
            Page page = stack.get(i);
            if (page.getScheme() == null) continue;
            return page.getScheme();
        }
        return null;
    }

    protected void noConversation() {
        Events.instance().raiseEvent("org.jboss.seam.noConversation", new Object[0]);
        FacesMessages.instance().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_WARN, "org.jboss.seam.NoConversation", "The conversation ended, timed out or was processing another request", new Object[0]);
    }

    protected void notLoggedIn() {
        Events.instance().raiseEvent("org.jboss.seam.notLoggedIn", new Object[0]);
        FacesMessages.instance().addFromResourceBundleOrDefault(FacesMessage.SEVERITY_WARN, "org.jboss.seam.NotLoggedIn", "Please log in first", new Object[0]);
    }

    public static String toString(Object returnValue) {
        return returnValue == null ? null : returnValue.toString();
    }

    public static void handleOutcome(FacesContext facesContext, String outcome, String fromAction) {
        facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, fromAction, outcome);
        Contexts.getPageContext().flush();
    }

    public static Pages instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Pages)Component.getInstance(Pages.class, ScopeType.APPLICATION);
    }

    private static boolean callAction(FacesContext facesContext) {
        String outcome;
        boolean result = false;
        String fromAction = outcome = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionOutcome");
        if (outcome == null) {
            String actionId = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionMethod");
            if (actionId != null) {
                if (!SafeActions.instance().isActionSafe(actionId)) {
                    return result;
                }
                String expression = SafeActions.toAction(actionId);
                result = true;
                Expressions.MethodBinding actionBinding = Expressions.instance().createMethodBinding(expression);
                outcome = Pages.toString(actionBinding.invoke(new Object[0]));
                fromAction = expression;
                Pages.handleOutcome(facesContext, outcome, fromAction);
            }
        } else {
            Pages.handleOutcome(facesContext, outcome, fromAction);
        }
        return result;
    }

    public List<ResourceBundle> getResourceBundles(String viewId) {
        ArrayList<ResourceBundle> result = new ArrayList<ResourceBundle>(1);
        List<Page> stack = this.getPageStack(viewId);
        for (int i = stack.size() - 1; i >= 0; --i) {
            Page page = stack.get(i);
            ResourceBundle bundle = page.getResourceBundle();
            if (bundle == null) continue;
            result.add(bundle);
        }
        return result;
    }

    public Map<String, Object> getConvertedParameters(FacesContext facesContext, String viewId) {
        return this.getConvertedParameters(facesContext, viewId, Collections.EMPTY_SET);
    }

    protected Map<String, Object> getParameters(String viewId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                Expressions.ValueBinding valueBinding = pageParameter.getValueBinding();
                Object value = valueBinding == null ? Contexts.getPageContext().get(pageParameter.getName()) : valueBinding.getValue();
                if (value == null) continue;
                parameters.put(pageParameter.getName(), value);
            }
        }
        return parameters;
    }

    public Map<String, Object> getConvertedParameters(FacesContext facesContext, String viewId, Set<String> overridden) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                Object value;
                if (overridden.contains(pageParameter.getName()) || (value = this.getPageParameterValue(facesContext, pageParameter)) == null) continue;
                parameters.put(pageParameter.getName(), value);
            }
        }
        return parameters;
    }

    private Object getPageParameterValue(FacesContext facesContext, Param pageParameter) {
        Expressions.ValueBinding valueBinding = pageParameter.getValueBinding();
        if (valueBinding == null) {
            return Contexts.getPageContext().get(pageParameter.getName());
        }
        return pageParameter.getValueFromModel(facesContext);
    }

    public void applyRequestParameterValues(FacesContext facesContext) {
        String viewId = Pages.getViewId(facesContext);
        Map<String, String[]> requestParameters = Parameters.getRequestParameters();
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                Object value = pageParameter.getValueFromRequest(facesContext, requestParameters);
                if (value == null) {
                    Contexts.getPageContext().remove(pageParameter.getName());
                    continue;
                }
                Contexts.getPageContext().set(pageParameter.getName(), value);
            }
        }
        this.applyViewRootValues(facesContext);
    }

    public void applyViewRootValues(FacesContext facesContext) {
        String viewId = Pages.getViewId(facesContext);
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                Object object;
                Expressions.ValueBinding valueBinding = pageParameter.getValueBinding();
                if (valueBinding == null || (object = Contexts.getPageContext().get(pageParameter.getName())) == null) continue;
                valueBinding.setValue(object);
            }
        }
    }

    public Map<String, Object> getViewRootValues(FacesContext facesContext) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String viewId = Pages.getViewId(facesContext);
        for (Page page : this.getPageStack(viewId)) {
            for (Param pageParameter : page.getParameters()) {
                Object object = Contexts.getPageContext().get(pageParameter.getName());
                if (object == null) continue;
                parameters.put(pageParameter.getName(), object);
            }
        }
        return parameters;
    }

    public String getNoConversationViewId() {
        return this.noConversationViewId;
    }

    public void setNoConversationViewId(String noConversationViewId) {
        this.noConversationViewId = noConversationViewId;
    }

    public String encodePageParameters(FacesContext facesContext, String url, String viewId) {
        return this.encodePageParameters(facesContext, url, viewId, Collections.EMPTY_SET);
    }

    public String encodePageParameters(FacesContext facesContext, String url, String viewId, Set<String> overridden) {
        Map<String, Object> parameters = this.getConvertedParameters(facesContext, viewId, overridden);
        return Manager.instance().encodeParameters(url, parameters);
    }

    public void storePageParameters(FacesContext facesContext) {
        String viewId = Pages.getViewId(facesContext);
        for (Map.Entry<String, Object> param : this.getParameters(viewId).entrySet()) {
            Contexts.getPageContext().set(param.getKey(), param.getValue());
        }
    }

    public String getNoConversationViewId(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        for (int i = stack.size() - 1; i >= 0; --i) {
            Page page = stack.get(i);
            String noConversationViewId = page.getNoConversationViewId();
            if (noConversationViewId == null) continue;
            return noConversationViewId;
        }
        return this.noConversationViewId;
    }

    public Integer getTimeout(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        for (int i = stack.size() - 1; i >= 0; --i) {
            Page page = stack.get(i);
            Integer timeout = page.getTimeout();
            if (timeout == null) continue;
            return timeout;
        }
        return Manager.instance().getConversationTimeout();
    }

    public static String getSuffix() {
        String defaultSuffix = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        return defaultSuffix == null ? ".jsp" : defaultSuffix;
    }

    private void parse(InputStream stream) {
        Element root = Pages.getDocumentRoot(stream);
        if (this.noConversationViewId == null) {
            this.noConversationViewId = root.attributeValue("no-conversation-view-id");
        }
        if (this.loginViewId == null) {
            this.loginViewId = root.attributeValue("login-view-id");
        }
        List elements = root.elements("conversation");
        for (Element conversation : elements) {
            this.parseConversation(conversation, conversation.attributeValue("name"));
        }
        elements = root.elements("page");
        for (Element page : elements) {
            this.parse(page, page.attributeValue("view-id"));
        }
    }

    private void parse(InputStream stream, String viewId) {
        this.parse(Pages.getDocumentRoot(stream), viewId);
    }

    private static Element getDocumentRoot(InputStream stream) {
        try {
            return XML.getRootElement(stream);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }

    private void parseConversation(Element element, String name) {
        if (name == null) {
            throw new IllegalStateException("Must specify name for <conversation/> declaration");
        }
        if (this.conversations.containsKey(name)) {
            throw new IllegalStateException("<conversation/> declaration already exists for [" + name + "]");
        }
        ELConversationIdParameter param = new ELConversationIdParameter(name, element.attributeValue("parameter-name"), element.attributeValue("parameter-value"));
        this.conversations.put(name, param);
    }

    private void parse(Element element, String viewId) {
        if (viewId == null) {
            throw new IllegalStateException("Must specify view-id for <page/> declaration");
        }
        if (viewId.endsWith("*")) {
            this.wildcardViewIds.add(viewId);
        }
        Page page = new Page(viewId);
        this.pagesByViewId.put(viewId, page);
        this.parsePage(page, element, viewId);
        Pages.parseConversationControl(element, page.getConversationControl());
        Pages.parseTaskControl(element, page.getTaskControl());
        Pages.parseProcessControl(element, page.getProcessControl());
        List children = element.elements("param");
        for (Element param : children) {
            page.getParameters().add(Pages.parseParam(param));
        }
        List moreChildren = element.elements("navigation");
        for (Element fromAction : moreChildren) {
            Pages.parseActionNavigation(page, fromAction);
        }
        Element restrict = element.element("restrict");
        if (restrict != null) {
            page.setRestricted(true);
            String expr = restrict.getTextTrim();
            if (!Strings.isEmpty(expr)) {
                page.setRestriction(expr);
            }
        }
    }

    private Page parsePage(Page page, Element element, String viewId) {
        Action action;
        String timeoutString;
        String description;
        page.setSwitchEnabled(!"disabled".equals(element.attributeValue("switch")));
        Element optionalElement = element.element("description");
        String string = description = optionalElement == null ? element.getTextTrim() : optionalElement.getTextTrim();
        if (description != null && description.length() > 0) {
            page.setDescription(description);
        }
        if ((timeoutString = element.attributeValue("timeout")) != null) {
            page.setTimeout(Integer.parseInt(timeoutString));
        }
        page.setNoConversationViewId(element.attributeValue("no-conversation-view-id"));
        page.setConversationRequired("true".equals(element.attributeValue("conversation-required")));
        page.setLoginRequired("true".equals(element.attributeValue("login-required")));
        page.setScheme(element.attributeValue("scheme"));
        ConversationIdParameter param = this.conversations.get(element.attributeValue("conversation"));
        if (param != null) {
            page.setConversationIdParameter(param);
        }
        if ((action = Pages.parseAction(element, "action")) != null) {
            page.getActions().add(action);
        }
        List childElements = element.elements("action");
        for (Element childElement : childElements) {
            page.getActions().add(Pages.parseAction(childElement, "execute"));
        }
        String bundle = element.attributeValue("bundle");
        if (bundle != null) {
            page.setResourceBundleName(bundle);
        }
        List moreChildElements = element.elements("in");
        for (Element child : moreChildElements) {
            Input input = new Input();
            input.setName(child.attributeValue("name"));
            input.setValue(Expressions.instance().createValueBinding(child.attributeValue("value")));
            String scopeName = child.attributeValue("scope");
            if (scopeName != null) {
                input.setScope(ScopeType.valueOf(scopeName.toUpperCase()));
            }
            page.getInputs().add(input);
        }
        return page;
    }

    private static Action parseAction(Element element, String actionAtt) {
        Action action = new Action();
        String methodExpression = element.attributeValue(actionAtt);
        if (methodExpression == null) {
            return null;
        }
        if (methodExpression.startsWith("#{")) {
            Expressions.MethodBinding methodBinding = Expressions.instance().createMethodBinding(methodExpression);
            action.setMethodBinding(methodBinding);
        } else {
            action.setOutcome(methodExpression);
        }
        String expression = element.attributeValue("if");
        if (expression != null) {
            action.setValueBinding(Expressions.instance().createValueBinding(expression));
        }
        return action;
    }

    private static void parseConversationControl(Element element, ConversationControl control) {
        Element beginConversation;
        Element endConversation = element.element("end-conversation");
        Element element2 = endConversation = endConversation == null ? element.element("end-task") : endConversation;
        if (endConversation != null) {
            control.setEndConversation(true);
            control.setEndConversationBeforeRedirect("true".equals(endConversation.attributeValue("before-redirect")));
            String expression = endConversation.attributeValue("if");
            if (expression != null) {
                control.setEndConversationCondition(Expressions.instance().createValueBinding(expression));
            }
        }
        beginConversation = (beginConversation = element.element("begin-conversation")) == null ? element.element("begin-task") : beginConversation;
        Element element3 = beginConversation = beginConversation == null ? element.element("start-task") : beginConversation;
        if (beginConversation != null) {
            String expression;
            control.setBeginConversation(true);
            control.setJoin("true".equals(beginConversation.attributeValue("join")));
            control.setNested("true".equals(beginConversation.attributeValue("nested")));
            control.setPageflow(beginConversation.attributeValue("pageflow"));
            String flushMode = beginConversation.attributeValue("flush-mode");
            if (flushMode != null) {
                control.setFlushMode(FlushModeType.valueOf(flushMode.toUpperCase()));
            }
            if ((expression = beginConversation.attributeValue("if")) != null) {
                control.setBeginConversationCondition(Expressions.instance().createValueBinding(expression));
            }
        }
        if (control.isBeginConversation() && control.isEndConversation()) {
            throw new IllegalStateException("cannot use both <begin-conversation/> and <end-conversation/>");
        }
    }

    private static void parseTaskControl(Element element, TaskControl control) {
        Element startTask;
        Element beginTask;
        Element endTask = element.element("end-task");
        if (endTask != null) {
            control.setEndTask(true);
            control.setTransition(endTask.attributeValue("transition"));
        }
        if ((beginTask = element.element("begin-task")) != null) {
            control.setBeginTask(true);
            String taskId = beginTask.attributeValue("task-id");
            if (taskId == null) {
                taskId = "#{param.taskId}";
            }
            control.setTaskId(Expressions.instance().createValueBinding(taskId));
        }
        if ((startTask = element.element("start-task")) != null) {
            control.setStartTask(true);
            String taskId = startTask.attributeValue("task-id");
            if (taskId == null) {
                taskId = "#{param.taskId}";
            }
            control.setTaskId(Expressions.instance().createValueBinding(taskId));
        }
        if (control.isBeginTask() && control.isEndTask()) {
            throw new IllegalStateException("cannot use both <begin-task/> and <end-task/>");
        }
        if (control.isBeginTask() && control.isStartTask()) {
            throw new IllegalStateException("cannot use both <start-task/> and <begin-task/>");
        }
        if (control.isStartTask() && control.isEndTask()) {
            throw new IllegalStateException("cannot use both <start-task/> and <end-task/>");
        }
    }

    private static void parseProcessControl(Element element, ProcessControl control) {
        Element resumeProcess;
        Element createProcess = element.element("create-process");
        if (createProcess != null) {
            control.setCreateProcess(true);
            control.setDefinition(createProcess.attributeValue("definition"));
        }
        if ((resumeProcess = element.element("resume-process")) != null) {
            control.setResumeProcess(true);
            String processId = resumeProcess.attributeValue("process-id");
            if (processId == null) {
                processId = "#{param.processId}";
            }
            control.setProcessId(Expressions.instance().createValueBinding(processId));
        }
        if (control.isCreateProcess() && control.isResumeProcess()) {
            throw new IllegalStateException("cannot use both <create-process/> and <resume-process/>");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseActionNavigation(Page entry, Element element) {
        Navigation navigation = new Navigation();
        String outcomeExpression = element.attributeValue("evaluate");
        if (outcomeExpression != null) {
            navigation.setOutcome(Expressions.instance().createValueBinding(outcomeExpression));
        }
        List cases = element.elements("rule");
        for (Element childElement : cases) {
            navigation.getRules().add(Pages.parseRule(childElement));
        }
        Rule rule = new Rule();
        Pages.parseNavigationHandler(element, rule);
        Pages.parseConversationControl(element, rule.getConversationControl());
        Pages.parseTaskControl(element, rule.getTaskControl());
        Pages.parseProcessControl(element, rule.getProcessControl());
        navigation.setRule(rule);
        String expression = element.attributeValue("from-action");
        if (expression == null) {
            if (entry.getDefaultNavigation() != null) throw new IllegalStateException("multiple catchall <navigation> elements");
            entry.setDefaultNavigation(navigation);
            return;
        } else {
            Navigation old = entry.getNavigations().put(expression, navigation);
            if (old == null) return;
            throw new IllegalStateException("multiple <navigation> elements for action: " + expression);
        }
    }

    private static Param parseParam(Element element) {
        String valueExpression = element.attributeValue("value");
        String name = element.attributeValue("name");
        if (name == null) {
            if (valueExpression == null) {
                throw new IllegalArgumentException("must specify name or value for page <param/> declaration");
            }
            name = valueExpression.substring(2, valueExpression.length() - 1);
        }
        Param param = new Param(name);
        if (valueExpression != null) {
            param.setValueBinding(Expressions.instance().createValueBinding(valueExpression));
        }
        param.setConverterId(element.attributeValue("converterId"));
        String converterExpression = element.attributeValue("converter");
        if (converterExpression != null) {
            param.setConverterValueBinding(Expressions.instance().createValueBinding(converterExpression));
        }
        return param;
    }

    private static Rule parseRule(Element element) {
        Rule rule = new Rule();
        rule.setOutcomeValue(element.attributeValue("if-outcome"));
        String expression = element.attributeValue("if");
        if (expression != null) {
            rule.setCondition(Expressions.instance().createValueBinding(expression));
        }
        Pages.parseConversationControl(element, rule.getConversationControl());
        Pages.parseTaskControl(element, rule.getTaskControl());
        Pages.parseProcessControl(element, rule.getProcessControl());
        Pages.parseNavigationHandler(element, rule);
        return rule;
    }

    private static void parseNavigationHandler(Element element, Rule rule) {
        Element redirect;
        Element render = element.element("render");
        if (render != null) {
            String viewId = render.attributeValue("view-id");
            Element messageElement = render.element("message");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            String severityName = messageElement == null ? null : messageElement.attributeValue("severity");
            FacesMessage.Severity severity = severityName == null ? FacesMessage.SEVERITY_INFO : Pages.getFacesMessageValuesMap().get(severityName.toUpperCase());
            rule.addNavigationHandler(new RenderNavigationHandler(viewId, message, severity));
        }
        if ((redirect = element.element("redirect")) != null) {
            List children = redirect.elements("param");
            ArrayList<Param> params = new ArrayList<Param>();
            for (Element child : children) {
                params.add(Pages.parseParam(child));
            }
            String viewId = redirect.attributeValue("view-id");
            Element messageElement = redirect.element("message");
            String message = messageElement == null ? null : messageElement.getTextTrim();
            String severityName = messageElement == null ? null : messageElement.attributeValue("severity");
            FacesMessage.Severity severity = severityName == null ? FacesMessage.SEVERITY_INFO : Pages.getFacesMessageValuesMap().get(severityName.toUpperCase());
            rule.addNavigationHandler(new RedirectNavigationHandler(viewId, params, message, severity));
        }
        List childElements = element.elements("out");
        for (Element child : childElements) {
            Output output = new Output();
            output.setName(child.attributeValue("name"));
            output.setValue(Expressions.instance().createValueBinding(child.attributeValue("value")));
            String scopeName = child.attributeValue("scope");
            if (scopeName == null) {
                output.setScope(ScopeType.CONVERSATION);
            } else {
                output.setScope(ScopeType.valueOf(scopeName.toUpperCase()));
            }
            rule.getOutputs().add(output);
        }
    }

    public static Map<String, FacesMessage.Severity> getFacesMessageValuesMap() {
        HashMap<String, FacesMessage.Severity> result = new HashMap<String, FacesMessage.Severity>();
        for (Map.Entry me : FacesMessage.VALUES_MAP.entrySet()) {
            result.put(((String)me.getKey()).toUpperCase(), (FacesMessage.Severity)me.getValue());
        }
        return result;
    }

    public String getLoginViewId() {
        return this.loginViewId;
    }

    public void setLoginViewId(String loginViewId) {
        this.loginViewId = loginViewId;
    }

    public static String getCurrentViewId() {
        return Pages.getViewId(FacesContext.getCurrentInstance());
    }

    public static String getViewId(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (facesContext != null && (viewRoot = facesContext.getViewRoot()) != null) {
            return viewRoot.getViewId();
        }
        return null;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
    }
}

