/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.core.Locale;
import org.jboss.seam.core.Pages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.EnumerationEnumeration;
import org.jboss.seam.util.Strings;

@Scope(value=ScopeType.SESSION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.resourceBundle")
@Install(precedence=0)
public class ResourceBundle
implements Serializable {
    private static final long serialVersionUID = -3236251335438092538L;
    private static final LogProvider log = Logging.getLogProvider(ResourceBundle.class);
    private String[] bundleNames = new String[]{"messages"};
    private transient java.util.ResourceBundle bundle;

    public String[] getBundleNames() {
        return this.bundleNames;
    }

    public void setBundleNames(String[] bundleNames) {
        this.bundleNames = bundleNames;
    }

    @Deprecated
    public void setBundleName(String bundleName) {
        String[] stringArray;
        if (bundleName == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = bundleName;
        }
        this.bundleNames = stringArray;
    }

    @Deprecated
    public String getBundleName() {
        return this.bundleNames == null || this.bundleNames.length == 0 ? null : this.bundleNames[0];
    }

    protected java.util.ResourceBundle loadBundle(String bundleName) {
        try {
            java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle(bundleName, Locale.instance(), Thread.currentThread().getContextClassLoader());
            log.debug("loaded resource bundle: " + bundleName);
            return bundle;
        }
        catch (MissingResourceException mre) {
            log.debug("resource bundle missing: " + bundleName);
            return null;
        }
    }

    private void createUberBundle() {
        java.util.ResourceBundle validatorDefaultBundle;
        java.util.ResourceBundle validatorBundle;
        final ArrayList<java.util.ResourceBundle> littleBundles = new ArrayList<java.util.ResourceBundle>();
        if (this.bundleNames != null) {
            for (String bundleName : this.bundleNames) {
                java.util.ResourceBundle littleBundle = this.loadBundle(bundleName);
                if (littleBundle == null) continue;
                littleBundles.add(littleBundle);
            }
        }
        if ((validatorBundle = this.loadBundle("ValidatorMessages")) != null) {
            littleBundles.add(validatorBundle);
        }
        if ((validatorDefaultBundle = this.loadBundle("org/hibernate/validator/resources/DefaultValidatorMessages")) != null) {
            littleBundles.add(validatorDefaultBundle);
        }
        this.bundle = new java.util.ResourceBundle(){

            @Override
            public java.util.Locale getLocale() {
                return Locale.instance();
            }

            @Override
            public Enumeration<String> getKeys() {
                int i;
                List<java.util.ResourceBundle> pageBundles = this.getPageResourceBundles();
                Enumeration[] enumerations = new Enumeration[littleBundles.size() + pageBundles.size()];
                for (i = 0; i < pageBundles.size(); ++i) {
                    enumerations[i++] = pageBundles.get(i).getKeys();
                }
                while (i < littleBundles.size()) {
                    enumerations[i] = ((java.util.ResourceBundle)littleBundles.get(i)).getKeys();
                    ++i;
                }
                return new EnumerationEnumeration<String>(enumerations);
            }

            @Override
            protected Object handleGetObject(String key) {
                List<java.util.ResourceBundle> pageBundles = this.getPageResourceBundles();
                for (java.util.ResourceBundle pageBundle : pageBundles) {
                    try {
                        return pageBundle.getObject(key);
                    }
                    catch (MissingResourceException mre) {
                    }
                }
                for (java.util.ResourceBundle littleBundle : littleBundles) {
                    if (littleBundle == null) continue;
                    try {
                        return littleBundle.getObject(key);
                    }
                    catch (MissingResourceException mre) {
                    }
                }
                throw new MissingResourceException("Can't find resource in bundles: " + key, this.getClass().getName(), key);
            }

            private List<java.util.ResourceBundle> getPageResourceBundles() {
                String viewId = Pages.getCurrentViewId();
                if (viewId != null) {
                    return Pages.instance().getResourceBundles(viewId);
                }
                return Collections.EMPTY_LIST;
            }
        };
    }

    @Unwrap
    public java.util.ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.createUberBundle();
        }
        return this.bundle;
    }

    public String toString() {
        String concat = this.bundleNames == null ? "" : Strings.toString(", ", (Object[])this.bundleNames);
        return "ResourceBundle(" + concat + ")";
    }

    public static java.util.ResourceBundle instance() {
        return (java.util.ResourceBundle)Component.getInstance(ResourceBundle.class, true);
    }
}

