/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.MemberValue;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Scanner {
    private static final LogProvider log = Logging.getLogProvider(Scanner.class);
    protected String resourceName;
    protected ClassLoader classLoader;

    public Scanner(String resourceName) {
        this(resourceName, Thread.currentThread().getContextClassLoader());
    }

    public Scanner(String resourceName, ClassLoader classLoader) {
        this.resourceName = resourceName;
        this.classLoader = classLoader;
        ClassFile.class.getPackage();
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }

    protected void scan() {
        HashSet<String> paths = new HashSet<String>();
        if (this.resourceName == null) {
            for (URL url : ((URLClassLoader)this.classLoader).getURLs()) {
                String urlPath = url.getFile();
                if (urlPath.endsWith("/")) {
                    urlPath = urlPath.substring(0, urlPath.length() - 1);
                }
                paths.add(urlPath);
            }
        } else {
            try {
                Enumeration<URL> urlEnum = this.classLoader.getResources(this.resourceName);
                while (urlEnum.hasMoreElements()) {
                    String urlPath = urlEnum.nextElement().getFile();
                    if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                    if (urlPath.indexOf(33) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(33));
                    } else {
                        File dirOrArchive = new File(urlPath);
                        if (this.resourceName != null && this.resourceName.lastIndexOf(47) > 0) {
                            dirOrArchive = dirOrArchive.getParentFile();
                        }
                        urlPath = dirOrArchive.getParent();
                    }
                    paths.add(urlPath);
                }
            }
            catch (IOException ioe) {
                log.warn("could not read: " + this.resourceName, ioe);
                return;
            }
        }
        for (String urlPath : paths) {
            try {
                log.info("scanning: " + urlPath);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.handleDirectory(file, null);
                    continue;
                }
                this.handleArchive(file);
            }
            catch (IOException ioe) {
                log.warn("could not read entries", ioe);
            }
        }
    }

    private void handleArchive(File file) throws ZipException, IOException {
        log.debug("archive: " + file);
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            log.debug("found: " + name);
            this.handleItem(name);
        }
    }

    private void handleDirectory(File file, String path) {
        log.debug("directory: " + file);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this.handleItem(newPath);
        }
    }

    abstract void handleItem(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassFile getClassFile(String name) throws IOException {
        InputStream stream = this.classLoader.getResourceAsStream(name);
        DataInputStream dstream = new DataInputStream(stream);
        try {
            ClassFile classFile = new ClassFile(dstream);
            return classFile;
        }
        finally {
            dstream.close();
            stream.close();
        }
    }

    protected boolean hasAnnotation(ClassFile cf, Class<? extends Annotation> annotationType) {
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null) {
            return visible.getAnnotation(annotationType.getName()) != null;
        }
        return false;
    }

    protected String getAnnotationValue(ClassFile cf, Class<? extends Annotation> annotationType, String memberName) {
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null) {
            javassist.bytecode.annotation.Annotation annotation = visible.getAnnotation(annotationType.getName());
            if (annotation == null) {
                return null;
            }
            MemberValue memberValue = annotation.getMemberValue(memberName);
            return memberValue == null ? null : memberValue.toString();
        }
        return null;
    }

    public static String componentFilename(String name) {
        return name.substring(0, name.lastIndexOf(".class")) + ".component.xml";
    }
}

