/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.util.Comparator;
import javax.servlet.Filter;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.core.Init;
import org.jboss.seam.servlet.AbstractResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescriptor
implements Comparable<ComponentDescriptor> {
    protected String name;
    protected Class<?> componentClass;
    protected ScopeType scope;
    protected String jndiName;
    protected Boolean installed;
    protected boolean autoCreate;
    protected Integer precedence;

    public ComponentDescriptor(String name, Class<?> componentClass, ScopeType scope, boolean autoCreate, String jndiName, Boolean installed, Integer precedence) {
        this.name = name;
        this.componentClass = componentClass;
        this.scope = scope;
        this.jndiName = jndiName;
        this.installed = installed;
        this.autoCreate = autoCreate;
        this.precedence = precedence;
    }

    public ComponentDescriptor(String name, Class<?> componentClass, ScopeType scope) {
        this.name = name;
        this.componentClass = componentClass;
        this.scope = scope;
    }

    public ComponentDescriptor(Class componentClass) {
        this.componentClass = componentClass;
    }

    public ComponentDescriptor(Class componentClass, Boolean installed) {
        this.componentClass = componentClass;
        this.installed = installed;
    }

    public String getName() {
        return this.name == null ? Seam.getComponentName(this.componentClass) : this.name;
    }

    public ScopeType getScope() {
        return this.scope == null ? Seam.getComponentScope(this.componentClass) : this.scope;
    }

    public Class getComponentClass() {
        return this.componentClass;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean isAutoCreate() {
        return this.autoCreate || this.componentClass.isAnnotationPresent(AutoCreate.class);
    }

    public String[] getDependencies() {
        Install install = this.componentClass.getAnnotation(Install.class);
        if (install == null) {
            return null;
        }
        return install.dependencies();
    }

    public Class[] getGenericDependencies() {
        Install install = this.componentClass.getAnnotation(Install.class);
        if (install == null) {
            return null;
        }
        return install.genericDependencies();
    }

    public String[] getClassDependencies() {
        Install install = this.componentClass.getAnnotation(Install.class);
        if (install == null) {
            return null;
        }
        return install.classDependencies();
    }

    public boolean isInstalled() {
        if (this.installed != null) {
            return this.installed;
        }
        Install install = this.componentClass.getAnnotation(Install.class);
        if (install == null) {
            return true;
        }
        return install.debug() ? Init.instance().isDebug() : install.value();
    }

    public int getPrecedence() {
        if (this.precedence != null) {
            return this.precedence;
        }
        Install install = this.componentClass.getAnnotation(Install.class);
        if (install == null) {
            return 20;
        }
        return install.precedence();
    }

    @Override
    public int compareTo(ComponentDescriptor other) {
        return other.getPrecedence() - this.getPrecedence();
    }

    public boolean isFilter() {
        return Filter.class.isAssignableFrom(this.componentClass);
    }

    public boolean isResourceProvider() {
        return AbstractResource.class.isAssignableFrom(this.componentClass);
    }

    public String toString() {
        return "ComponentDescriptor(" + this.getName() + ":" + this.getComponentClass() + ')';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrecedenceComparator
    implements Comparator<ComponentDescriptor> {
        @Override
        public int compare(ComponentDescriptor obj1, ComponentDescriptor obj2) {
            return obj2.getPrecedence() - obj1.getPrecedence();
        }
    }
}

