/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Namespace;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Roles;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Jbpm;
import org.jboss.seam.core.PojoCache;
import org.jboss.seam.deployment.ComponentScanner;
import org.jboss.seam.deployment.NamespaceScanner;
import org.jboss.seam.init.ComponentDescriptor;
import org.jboss.seam.init.DependencyManager;
import org.jboss.seam.init.FactoryDescriptor;
import org.jboss.seam.init.NamespaceDescriptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Conversions;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initialization {
    public static final String COMPONENT_SUFFIX = ".component";
    private static final LogProvider log = Logging.getLogProvider(Initialization.class);
    private ServletContext servletContext;
    private Map<String, Conversions.PropertyValue> properties = new HashMap<String, Conversions.PropertyValue>();
    private Map<String, Set<ComponentDescriptor>> componentDescriptors = new HashMap<String, Set<ComponentDescriptor>>();
    private List<FactoryDescriptor> factoryDescriptors = new ArrayList<FactoryDescriptor>();
    private Set<Class> installedComponentClasses = new HashSet<Class>();
    private Set<String> importedPackages = new HashSet<String>();
    private Map<String, NamespaceDescriptor> namespaceMap = new HashMap<String, NamespaceDescriptor>();
    private final Map<String, EventListenerDescriptor> eventListenerDescriptors = new HashMap<String, EventListenerDescriptor>();
    private File[] hotDeployPaths;
    private ClassLoader hotDeployClassLoader;

    public Initialization(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Initialization create() {
        this.addNamespaces();
        this.initComponentsFromXmlDocument("/WEB-INF/components.xml");
        this.initComponentsFromXmlDocument("/WEB-INF/events.xml");
        this.initComponentsFromXmlDocuments();
        this.initPropertiesFromServletContext();
        this.initPropertiesFromResource();
        this.initJndiProperties();
        return this;
    }

    private void initComponentsFromXmlDocuments() {
        Enumeration<URL> resources;
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/components.xml");
        }
        catch (IOException ioe) {
            throw new RuntimeException("error scanning META-INF/components.xml files", ioe);
        }
        Properties replacements = this.getReplacements();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                log.info("reading " + url);
                this.installComponentsFromXmlElements(XML.getRootElement(url.openStream()), replacements);
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading " + url, e);
            }
        }
    }

    private void initComponentsFromXmlDocument(String resource) {
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            log.info("reading " + resource);
            try {
                this.installComponentsFromXmlElements(XML.getRootElement(stream), this.getReplacements());
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading /WEB-INF/components.xml", e);
            }
        }
    }

    private Properties getReplacements() {
        try {
            Properties replacements = new Properties();
            InputStream replaceStream = Resources.getResourceAsStream("components.properties");
            if (replaceStream != null) {
                replacements.load(replaceStream);
            }
            return replacements;
        }
        catch (IOException ioe) {
            throw new RuntimeException("error reading components.properties", ioe);
        }
    }

    private void installComponentsFromXmlElements(Element rootElement, Properties replacements) throws DocumentException, ClassNotFoundException {
        List importElements = rootElement.elements("import-java-package");
        for (Element importElement : importElements) {
            String pkgName = importElement.getTextTrim();
            this.importedPackages.add(pkgName);
            this.addNamespace(Package.getPackage(pkgName));
        }
        List componentElements = rootElement.elements("component");
        for (Element component : componentElements) {
            this.installComponentFromXmlElement(component, component.attributeValue("name"), component.attributeValue("class"), replacements);
        }
        List factoryElements = rootElement.elements("factory");
        for (Element factory : factoryElements) {
            this.installFactoryFromXmlElement(factory);
        }
        List elements = rootElement.elements("event");
        for (Element event : elements) {
            this.installEventListenerFromXmlElement(event);
        }
        for (Element elem : rootElement.elements()) {
            String ns = elem.getNamespace().getURI();
            NamespaceDescriptor nsInfo = this.namespaceMap.get(ns);
            if (nsInfo == null) continue;
            String name = elem.attributeValue("name");
            String elemName = Initialization.toCamelCase(elem.getName(), true);
            String className = nsInfo.getPackage().getName() + '.' + elemName;
            try {
                Install install;
                Class clazz = Reflections.classForName(className);
                Name nameAnnotation = clazz.getAnnotation(Name.class);
                if (name == null && nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if (nameAnnotation != null && nameAnnotation.value().equals(name) && ((install = clazz.getAnnotation(Install.class)) == null || install.value())) {
                    className = null;
                }
            }
            catch (ClassNotFoundException cnfe) {
                className = null;
            }
            if (name == null) {
                String prefix = nsInfo.getNamespace().prefix();
                name = Strings.isEmpty(prefix) ? elemName : prefix + '.' + elemName;
            }
            this.installComponentFromXmlElement(elem, name, className, replacements);
        }
    }

    private void installEventListenerFromXmlElement(Element event) {
        String type = event.attributeValue("type");
        if (type == null) {
            throw new IllegalArgumentException("must specify type for <event/> declaration");
        }
        EventListenerDescriptor eventListener = this.eventListenerDescriptors.get(type);
        if (eventListener == null) {
            eventListener = new EventListenerDescriptor(type);
            this.eventListenerDescriptors.put(type, eventListener);
        }
        List actions = event.elements("action");
        for (Element action : actions) {
            String actionExpression = action.attributeValue("expression");
            if (actionExpression == null) {
                throw new IllegalArgumentException("must specify expression for <action/> declaration");
            }
            eventListener.getListenerMethodBindings().add(actionExpression);
        }
    }

    private void installFactoryFromXmlElement(Element factory) {
        String scopeName = factory.attributeValue("scope");
        String name = factory.attributeValue("name");
        if (name == null) {
            throw new IllegalArgumentException("must specify name in <factory/> declaration");
        }
        String method = factory.attributeValue("method");
        String value = factory.attributeValue("value");
        if (method == null && value == null) {
            throw new IllegalArgumentException("must specify either method or value in <factory/> declaration for variable: " + name);
        }
        ScopeType scope = scopeName == null ? ScopeType.UNSPECIFIED : ScopeType.valueOf(scopeName.toUpperCase());
        boolean autoCreate = "true".equals(factory.attributeValue("auto-create"));
        this.factoryDescriptors.add(new FactoryDescriptor(name, scope, method, value, autoCreate));
    }

    private String replace(String value, Properties replacements) {
        if (value.startsWith("@")) {
            value = replacements.getProperty(value.substring(1, value.length() - 1));
        }
        return value;
    }

    private void installComponentFromXmlElement(Element component, String name, String className, Properties replacements) throws ClassNotFoundException {
        String installText = component.attributeValue("installed");
        boolean installed = false;
        if (installText == null || "true".equals(this.replace(installText, replacements))) {
            installed = true;
        }
        String scopeName = component.attributeValue("scope");
        String jndiName = component.attributeValue("jndi-name");
        String precedenceString = component.attributeValue("precedence");
        int precedence = precedenceString == null ? 20 : Integer.valueOf(precedenceString);
        ScopeType scope = scopeName == null ? null : ScopeType.valueOf(scopeName.toUpperCase());
        boolean autoCreate = "true".equals(component.attributeValue("auto-create"));
        if (className != null) {
            Class clazz;
            block14: {
                clazz = null;
                try {
                    clazz = Reflections.classForName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    for (String pkg : this.importedPackages) {
                        try {
                            clazz = Reflections.classForName(pkg + '.' + className);
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                    if (clazz != null) break block14;
                    throw cnfe;
                }
            }
            if (name == null) {
                if (!clazz.isAnnotationPresent(Name.class)) {
                    throw new IllegalArgumentException("Component class must have @Name annotation or name must be specified in components.xml: " + clazz.getName());
                }
                name = clazz.getAnnotation(Name.class).value();
            }
            ComponentDescriptor descriptor = new ComponentDescriptor(name, clazz, scope, autoCreate, jndiName, installed, precedence);
            this.addComponentDescriptor(descriptor);
            this.installedComponentClasses.add(clazz);
        } else if (name == null) {
            throw new IllegalArgumentException("must specify either class or name in <component/> declaration");
        }
        for (Element prop : component.elements()) {
            String propName = prop.attributeValue("name");
            if (propName == null) {
                propName = prop.getQName().getName();
            }
            String qualifiedPropName = name + '.' + Initialization.toCamelCase(propName, false);
            this.properties.put(qualifiedPropName, this.getPropertyValue(prop, qualifiedPropName, replacements));
        }
        for (Element prop : component.attributes()) {
            String attributeName = prop.getName();
            boolean isProperty = !"name".equals(attributeName) && !"installed".equals(attributeName) && !"scope".equals(attributeName) && !"class".equals(attributeName) && !"jndi-name".equals(attributeName) && !"precedence".equals(attributeName) && !"auto-create".equals(attributeName);
            if (!isProperty) continue;
            String qualifiedPropName = name + '.' + Initialization.toCamelCase(prop.getQName().getName(), false);
            this.properties.put(qualifiedPropName, this.getPropertyValue((Attribute)prop, replacements));
        }
    }

    private void addComponentDescriptor(ComponentDescriptor descriptor) {
        String name = descriptor.getName();
        Set<ComponentDescriptor> set = this.componentDescriptors.get(name);
        if (set == null) {
            set = new TreeSet<ComponentDescriptor>(new ComponentDescriptor.PrecedenceComparator());
            this.componentDescriptors.put(name, set);
        }
        if (!set.isEmpty()) {
            log.info("two components with same name, higher precedence wins: " + name);
        }
        if (!set.add(descriptor)) {
            throw new IllegalStateException("Two components with the same name and precedence: " + name);
        }
    }

    private Conversions.PropertyValue getPropertyValue(Attribute prop, Properties replacements) {
        return new Conversions.FlatPropertyValue(this.trimmedText(prop, replacements));
    }

    private Conversions.PropertyValue getPropertyValue(Element prop, String propName, Properties replacements) {
        List keyElements = prop.elements("key");
        List valueElements = prop.elements("value");
        if (valueElements.isEmpty() && keyElements.isEmpty()) {
            return new Conversions.FlatPropertyValue(this.trimmedText(prop, propName, replacements));
        }
        if (keyElements.isEmpty()) {
            int len = valueElements.size();
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            }
            return new Conversions.MultiPropertyValue(values);
        }
        if (valueElements.size() != keyElements.size()) {
            throw new IllegalArgumentException("value elements must match key elements: " + propName);
        }
        HashMap<String, String> keyedValues = new HashMap<String, String>();
        for (int i = 0; i < keyElements.size(); ++i) {
            String key = this.trimmedText((Element)keyElements.get(i), propName, replacements);
            String value = this.trimmedText((Element)valueElements.get(i), propName, replacements);
            keyedValues.put(key, value);
        }
        return new Conversions.AssociativePropertyValue(keyedValues);
    }

    private String trimmedText(Element element, String propName, Properties replacements) {
        String text = element.getTextTrim();
        if (text == null) {
            throw new IllegalArgumentException("property value must be specified in element body: " + propName);
        }
        return this.replace(text, replacements);
    }

    private String trimmedText(Attribute attribute, Properties replacements) {
        return this.replace(attribute.getText(), replacements);
    }

    public Initialization setProperty(String name, Conversions.PropertyValue value) {
        this.properties.put(name, value);
        return this;
    }

    public Initialization init() {
        log.info("initializing Seam");
        Lifecycle.beginInitialization(this.servletContext);
        Contexts.getApplicationContext().set("org.jboss.seam.properties", this.properties);
        this.initHotDeployClassLoader();
        this.scanForHotDeployableComponents();
        this.scanForComponents();
        this.addComponent(new ComponentDescriptor(Init.class), Contexts.getApplicationContext());
        Init init = (Init)Component.getInstance(Init.class, ScopeType.APPLICATION);
        ComponentDescriptor desc = this.findDescriptor(Jbpm.class);
        if (desc != null && desc.isInstalled()) {
            init.setJbpmInstalled(true);
        }
        init.setTimestamp(System.currentTimeMillis());
        init.setHotDeployPaths(this.hotDeployPaths);
        this.addSpecialComponents(init);
        this.installComponents(init);
        Lifecycle.endInitialization();
        log.info("done initializing Seam");
        return this;
    }

    public Initialization redeploy(HttpSession session) {
        log.info("redeploying");
        Lifecycle.beginReinitialization(this.servletContext, session);
        Init init = Init.instance();
        for (String name : init.getHotDeployableComponents()) {
            Component component = Component.forName(name);
            ScopeType scope = component.getScope();
            if (scope != ScopeType.STATELESS && scope.isContextActive()) {
                scope.getContext().remove(name);
            }
            Contexts.getApplicationContext().remove(name + COMPONENT_SUFFIX);
        }
        this.initHotDeployClassLoader();
        this.scanForHotDeployableComponents();
        init.setTimestamp(System.currentTimeMillis());
        init.setHotDeployPaths(this.hotDeployPaths);
        this.installComponents(init);
        Lifecycle.endInitialization();
        log.info("done redeploying");
        return this;
    }

    private void initHotDeployClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String path;
            String hotDeployDirectory;
            File directory;
            URL resource = contextClassLoader.getResource("META-INF/debug.xhtml");
            if (resource != null && (directory = new File(hotDeployDirectory = (path = resource.toExternalForm()).substring(9, path.length() - 46) + "dev")).exists()) {
                URL url = directory.toURL();
                URL[] urls = new URL[]{url};
                this.hotDeployClassLoader = new URLClassLoader(urls, contextClassLoader);
                this.hotDeployPaths = new File[]{directory};
            }
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    private void scanForHotDeployableComponents() {
        if (this.hotDeployClassLoader != null) {
            HashSet<Class<Object>> scannedClasses = new HashSet<Class<Object>>();
            scannedClasses.addAll(new ComponentScanner(null, this.hotDeployClassLoader).getClasses());
            HashSet<Package> scannedPackages = new HashSet<Package>();
            for (Class clazz : scannedClasses) {
                this.installScannedClass(scannedPackages, clazz);
            }
        }
    }

    private void scanForComponents() {
        HashSet<Class<Object>> scannedClasses = new HashSet<Class<Object>>();
        scannedClasses.addAll(new ComponentScanner("seam.properties").getClasses());
        scannedClasses.addAll(new ComponentScanner("META-INF/seam.properties").getClasses());
        scannedClasses.addAll(new ComponentScanner("META-INF/components.xml").getClasses());
        HashSet<Package> scannedPackages = new HashSet<Package>();
        for (Class clazz : scannedClasses) {
            this.installScannedClass(scannedPackages, clazz);
        }
    }

    private void installScannedClass(Set<Package> scannedPackages, Class<Object> scannedClass) {
        this.installScannedComponentAndRoles(scannedClass);
        this.installComponentsFromDescriptor(Initialization.classDescriptorFilename(scannedClass), scannedClass);
        Package pkg = scannedClass.getPackage();
        if (pkg != null && scannedPackages.add(pkg)) {
            this.installComponentsFromDescriptor(Initialization.packageDescriptorFilename(pkg), scannedClass);
        }
    }

    private static String classDescriptorFilename(Class<Object> scannedClass) {
        return scannedClass.getName().replace('.', '/') + ".component.xml";
    }

    private static String packageDescriptorFilename(Package pkg) {
        return pkg.getName().replace('.', '/') + "/components.xml";
    }

    private void installComponentsFromDescriptor(String fileName, Class clazz) {
        InputStream stream = clazz.getClassLoader().getResourceAsStream(fileName);
        if (stream != null) {
            try {
                Properties replacements = this.getReplacements();
                Element root = XML.getRootElement(stream);
                if (root.getName().equals("components")) {
                    this.installComponentsFromXmlElements(root, replacements);
                } else {
                    this.installComponentFromXmlElement(root, root.attributeValue("name"), clazz.getName(), replacements);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error while reading " + fileName, e);
            }
        }
    }

    private void installScannedComponentAndRoles(Class<Object> scannedClass) {
        if (scannedClass.isAnnotationPresent(Name.class)) {
            this.addComponentDescriptor(new ComponentDescriptor(scannedClass));
        }
        if (scannedClass.isAnnotationPresent(Role.class)) {
            this.installRole(scannedClass, scannedClass.getAnnotation(Role.class));
        }
        if (scannedClass.isAnnotationPresent(Roles.class)) {
            Role[] roles;
            for (Role role : roles = scannedClass.getAnnotation(Roles.class).value()) {
                this.installRole(scannedClass, role);
            }
        }
    }

    private void installRole(Class<Object> scannedClass, Role role) {
        ScopeType scope = Seam.getComponentRoleScope(scannedClass, role);
        this.addComponentDescriptor(new ComponentDescriptor(role.name(), scannedClass, scope));
    }

    private void addNamespace(Package pkg) {
        Namespace ns;
        if (pkg != null && (ns = pkg.getAnnotation(Namespace.class)) != null) {
            log.info("Namespace: " + ns.value() + ", package: " + pkg.getName() + ", prefix: " + ns.prefix());
            this.namespaceMap.put(ns.value(), new NamespaceDescriptor(ns, pkg));
        }
    }

    private void addNamespaces() {
        for (Package pkg : new NamespaceScanner("META-INF/components.xml").getPackages()) {
            this.addNamespace(pkg);
        }
        for (Package pkg : new NamespaceScanner("seam.properties").getPackages()) {
            this.addNamespace(pkg);
        }
        for (Package pkg : new NamespaceScanner("META-INF/seam.properties").getPackages()) {
            this.addNamespace(pkg);
        }
    }

    private void initPropertiesFromServletContext() {
        Enumeration params = this.servletContext.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            this.properties.put(name, new Conversions.FlatPropertyValue(this.servletContext.getInitParameter(name)));
        }
    }

    private void initPropertiesFromResource() {
        Properties props = this.loadFromResource("/seam.properties");
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            this.properties.put((String)me.getKey(), new Conversions.FlatPropertyValue((String)me.getValue()));
        }
    }

    private void initJndiProperties() {
        Properties jndiProperties = new Properties();
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/jndi.properties"));
        jndiProperties.putAll((Map<?, ?>)this.loadFromResource("/seam-jndi.properties"));
        Naming.setInitialContextProperties(jndiProperties);
    }

    private Properties loadFromResource(String resource) {
        Properties props = new Properties();
        InputStream stream = Resources.getResourceAsStream(resource, this.servletContext);
        if (stream != null) {
            log.info("reading properties from: " + resource);
            try {
                props.load(stream);
            }
            catch (IOException ioe) {
                log.error("could not read " + resource, ioe);
            }
        } else {
            log.debug("not found: " + resource);
        }
        return props;
    }

    protected ComponentDescriptor findDescriptor(Class<?> componentClass) {
        for (Set<ComponentDescriptor> components : this.componentDescriptors.values()) {
            for (ComponentDescriptor component : components) {
                if (!component.getComponentClass().equals(componentClass)) continue;
                return component;
            }
        }
        return null;
    }

    private void addSpecialComponents(Init init) {
        try {
            Reflections.classForName("org.jboss.cache.aop.PojoCache");
            this.addComponentDescriptor(new ComponentDescriptor(PojoCache.class, true));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            log.warn("Did not install PojoCache due to NoClassDefFoundError: " + e.getMessage());
        }
    }

    private void installComponents(Init init) {
        log.info("Installing components...");
        Context context = Contexts.getApplicationContext();
        DependencyManager manager = new DependencyManager(this.componentDescriptors);
        Set<ComponentDescriptor> installable = manager.installedSet();
        for (ComponentDescriptor componentDescriptor : installable) {
            String compName = componentDescriptor.getName() + COMPONENT_SUFFIX;
            if (context.isSet(compName)) continue;
            this.addComponent(componentDescriptor, context);
            if (componentDescriptor.isAutoCreate()) {
                init.addAutocreateVariable(componentDescriptor.getName());
            }
            if (componentDescriptor.isFilter()) {
                init.addInstalledFilter(componentDescriptor.getName());
            }
            if (!componentDescriptor.isResourceProvider()) continue;
            init.addResourceProvider(componentDescriptor.getName());
        }
        for (FactoryDescriptor factoryDescriptor : this.factoryDescriptors) {
            if (factoryDescriptor.isValueBinding()) {
                init.addFactoryValueBinding(factoryDescriptor.getName(), factoryDescriptor.getValue(), factoryDescriptor.getScope());
            } else {
                init.addFactoryMethodBinding(factoryDescriptor.getName(), factoryDescriptor.getMethod(), factoryDescriptor.getScope());
            }
            if (!factoryDescriptor.isAutoCreate()) continue;
            init.addAutocreateVariable(factoryDescriptor.getName());
        }
        for (EventListenerDescriptor listenerDescriptor : this.eventListenerDescriptors.values()) {
            for (String expression : listenerDescriptor.getListenerMethodBindings()) {
                init.addObserverMethodBinding(listenerDescriptor.getType(), Expressions.instance().createMethodBinding(expression));
            }
        }
    }

    protected void addComponent(ComponentDescriptor descriptor, Context context) {
        String name = descriptor.getName();
        String componentName = name + COMPONENT_SUFFIX;
        try {
            Component component = new Component(descriptor.getComponentClass(), name, descriptor.getScope(), descriptor.getJndiName());
            context.set(componentName, component);
            if (descriptor.getComponentClass().getClassLoader() == this.hotDeployClassLoader) {
                Init.instance().addHotDeployableComponent(component.getName());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not create Component: " + name, e);
        }
    }

    private static String toCamelCase(String hyphenated, boolean initialUpper) {
        StringTokenizer tokens = new StringTokenizer(hyphenated, "-");
        StringBuilder result = new StringBuilder(hyphenated.length());
        String firstToken = tokens.nextToken();
        if (initialUpper) {
            result.append(Character.toUpperCase(firstToken.charAt(0))).append(firstToken.substring(1));
        } else {
            result.append(firstToken);
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventListenerDescriptor {
        private String type;
        private List<String> listenerMethodBindings = new ArrayList<String>();

        EventListenerDescriptor(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getListenerMethodBindings() {
            return this.listenerMethodBindings;
        }

        public String toString() {
            return "EventListenerDescriptor(" + this.type + ')';
        }
    }
}

