/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.log;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.seam.log.LogImpl;
import org.jboss.seam.log.LogProvider;

public final class Log4JProvider
implements LogProvider {
    private final Logger logger;
    private final boolean isWrapped;
    private static final String LOG_IMPL_FQCN = LogImpl.class.getName();
    private static final String LOG_PROVIDER_FQCN = Log4JProvider.class.getName();

    Log4JProvider(String category, boolean wrapped) {
        this.logger = Logger.getLogger((String)category);
        this.isWrapped = wrapped;
    }

    private String getFQCN() {
        return this.isWrapped ? LOG_IMPL_FQCN : LOG_PROVIDER_FQCN;
    }

    public void debug(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.DEBUG, object, null);
    }

    public void debug(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.DEBUG, object, t);
    }

    public void error(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.ERROR, object, null);
    }

    public void error(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.ERROR, object, t);
    }

    public void fatal(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.FATAL, object, null);
    }

    public void fatal(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.FATAL, object, t);
    }

    public void info(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.INFO, object, null);
    }

    public void info(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.INFO, object, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void trace(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.DEBUG, object, null);
    }

    public void trace(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.DEBUG, object, t);
    }

    public void warn(Object object) {
        this.logger.log(this.getFQCN(), (Priority)Level.WARN, object, null);
    }

    public void warn(Object object, Throwable t) {
        this.logger.log(this.getFQCN(), (Priority)Level.WARN, object, t);
    }
}

