/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractFilter
implements Filter {
    private ServletContext servletContext;
    private String urlPattern;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    boolean matchesRequestPath(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return true;
        }
        String path = ((HttpServletRequest)request).getServletPath();
        String pattern = this.getUrlPattern();
        if (pattern == null) {
            return true;
        }
        if (path == null || "".equals(path)) {
            path = "/";
        }
        if (pattern == null || "".equals(pattern)) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public void destroy() {
    }
}

