/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */ 
package org.jboss.security.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *  Generic Context used by the Mapping Framework
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @version $Revision$
 *  @since  Aug 24, 2006
 */
public class MappingContext
{ 
   private List modules = new ArrayList();
   
   public MappingContext(List mod)
   { 
      this.modules = mod;
   }
   
   /**
    * Get the set of mapping modules
    * @return
    */
   public List getModules()
   {
      return this.modules;
   }
   
   /**
    * Apply mapping semantics on the passed object
    * @param obj Read-only Contextual Map
    * @param mappedObject an object on which mapping will be applied 
    */
   public <T> void performMapping(Map obj, T mappedObject)
   {
      int len = modules.size(); 
      
      for(int i = 0 ; i < len; i++)
      {
         MappingProvider<T> mp = (MappingProvider<T>)modules.get(i);
         mp.performMapping(obj, mappedObject);
      } 
   } 
}
