/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.lang.reflect.Constructor;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SecuritySPIActions;

public class SecurityContextFactory {
    private static String defaultFQN = "org.jboss.security.plugins.JBossSecurityContext";
    private static String defaultUtilClass = "org.jboss.security.plugins.JBossSecurityContextUtil";

    public static SecurityContext createSecurityContext(String securityDomain) throws Exception {
        return SecurityContextFactory.createSecurityContext(securityDomain, defaultFQN);
    }

    public static SecurityContext createSecurityContext(String securityDomain, String fqnClass) throws Exception {
        if (securityDomain == null) {
            throw new IllegalArgumentException("securityDomain is null");
        }
        if (fqnClass == null) {
            throw new IllegalArgumentException("fqnClass is null");
        }
        Class clazz = SecurityContextFactory.getContextClass(fqnClass);
        Constructor ctr = clazz.getConstructor(String.class);
        return (SecurityContext)ctr.newInstance(securityDomain);
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain) throws Exception {
        SecurityContext jsc = SecurityContextFactory.createSecurityContext(securityDomain);
        jsc.getUtil().createSubjectInfo(p, cred, s);
        return jsc;
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain, String fqnClass) throws Exception {
        SecurityContext sc = SecurityContextFactory.createSecurityContext(securityDomain, fqnClass);
        sc.getUtil().createSubjectInfo(p, cred, s);
        return sc;
    }

    public static SecurityContextUtil createUtil(SecurityContext sc) throws Exception {
        Class clazz = SecurityContextFactory.getContextClass(defaultUtilClass);
        Constructor ctr = clazz.getConstructor(SecurityContext.class);
        return (SecurityContextUtil)ctr.newInstance(sc);
    }

    public static SecurityContextUtil createUtil(SecurityContext sc, String utilFQN) throws Exception {
        Class clazz = SecurityContextFactory.getContextClass(utilFQN);
        Constructor ctr = clazz.getConstructor(SecurityContext.class);
        return (SecurityContextUtil)ctr.newInstance(sc);
    }

    private static Class getContextClass(String className) throws Exception {
        ClassLoader tcl = SecuritySPIActions.getContextClassLoader();
        return tcl.loadClass(className);
    }
}

