/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.persister.ArrayPersister;
import org.jboss.serial.persister.ClassReferencePersister;
import org.jboss.serial.persister.ExternalizePersister;
import org.jboss.serial.persister.Persister;
import org.jboss.serial.persister.PrivateWritePersister;
import org.jboss.serial.persister.ProxyPersister;
import org.jboss.serial.persister.RegularObjectPersister;

public class PersistResolver {
    static Persister arrayPersister = new ArrayPersister();
    static ExternalizePersister externalizePersister = new ExternalizePersister();
    static PrivateWritePersister privateWritePersister = new PrivateWritePersister();
    static RegularObjectPersister defaultPersister = new RegularObjectPersister();
    static ClassReferencePersister classReferencePersister = new ClassReferencePersister();
    static ProxyPersister proxyPersister = new ProxyPersister();
    static /* synthetic */ Class class$java$lang$Class;

    public static Persister resolvePersister(byte id) {
        switch (id) {
            case 1: {
                return defaultPersister;
            }
            case 2: {
                return arrayPersister;
            }
            case 3: {
                return externalizePersister;
            }
            case 4: {
                return privateWritePersister;
            }
            case 5: {
                return classReferencePersister;
            }
            case 6: {
                return proxyPersister;
            }
        }
        return defaultPersister;
    }

    public static Persister resolvePersister(Object objToBeSerialized, ClassMetaData metaData) {
        if (metaData.getClazz() == (class$java$lang$Class == null ? (class$java$lang$Class = PersistResolver.class$("java.lang.Class")) : class$java$lang$Class)) {
            return classReferencePersister;
        }
        if (metaData.isArray()) {
            return arrayPersister;
        }
        if (metaData.isExternalizable()) {
            return externalizePersister;
        }
        if (metaData.getPrivateMethodRead() != null) {
            return privateWritePersister;
        }
        if (metaData.isProxy()) {
            return proxyPersister;
        }
        return defaultPersister;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        privateWritePersister.setExternalizer(externalizePersister);
        privateWritePersister.setRegular(defaultPersister);
        defaultPersister.setId((byte)1);
        arrayPersister.setId((byte)2);
        externalizePersister.setId((byte)3);
        privateWritePersister.setId((byte)4);
        classReferencePersister.setId((byte)5);
        proxyPersister.setId((byte)6);
    }
}

