/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.SubDeployer;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.util.jmx.ObjectNameFactory;
import org.w3c.dom.Document;

public class DeploymentInfo {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    public Date date = new Date();
    public URL url;
    public URL localUrl;
    public URL watch;
    public String shortName;
    public long lastDeployed = 0L;
    public long lastModified = 0L;
    public String status;
    public SubDeployer deployer;
    public ClassLoader ucl;
    public ClassLoader localCl;
    public final Collection classpath = new ArrayList();
    public final List mbeans = new ArrayList();
    public final Set subDeployments = new HashSet();
    public DeploymentInfo parent = null;
    public String webContext;
    public Manifest manifest;
    public Document document;
    public Object metaData;
    public boolean isXML;
    public boolean isDirectory;
    public ObjectName deployedObject;

    public DeploymentInfo(URL url, DeploymentInfo parent) throws DeploymentException {
        this.url = url;
        this.watch = url;
        this.parent = parent;
        if (url.getProtocol().startsWith("file") && new File(url.getFile()).isDirectory()) {
            this.isDirectory = true;
        }
        if (!this.isDirectory) {
            try {
                url.openStream().close();
            }
            catch (Exception e) {
                throw new DeploymentException("url " + url + " could not be opened, does it exist?");
            }
        }
        if (parent != null) {
            parent.subDeployments.add(this);
        }
        this.shortName = DeploymentInfo.getShortName(url.getFile());
        this.isXML = this.shortName.toLowerCase().endsWith("xml");
    }

    public void createClassLoaders(MBeanServer server) throws Exception {
        if (this.isXML) {
            this.ucl = this.localCl = Thread.currentThread().getContextClassLoader();
        } else {
            this.localCl = new URLClassLoader(new URL[]{this.localUrl});
            this.ucl = new UnifiedClassLoader(this.localUrl, server, DEFAULT_LOADER_REPOSITORY);
        }
    }

    public Manifest getManifest() {
        try {
            if (this.manifest == null) {
                File file = new File(this.localUrl.getFile());
                this.manifest = file.isDirectory() ? new Manifest(new FileInputStream(new File(file, "META-INF/MANIFEST.MF"))) : new JarFile(file).getManifest();
            }
            return this.manifest;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void cleanup(Logger log) {
        if (!this.isXML) {
            ((UnifiedClassLoader)this.ucl).unregister();
        }
        this.subDeployments.clear();
        this.mbeans.clear();
        if (this.localUrl == null || this.localUrl.equals(this.url)) {
            log.info((Object)("not deleting localUrl, it is null or not a copy: " + this.localUrl));
        } else if (this.recursiveDelete(new File(this.localUrl.getFile()))) {
            log.info((Object)("Cleaned Deployment " + this.url));
        } else {
            log.info((Object)("could not delete directory " + this.localUrl.toString() + " restart will delete it"));
        }
    }

    private boolean recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                if (!this.recursiveDelete(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return f.delete();
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof DeploymentInfo) {
            return ((DeploymentInfo)other).url.equals(this.url);
        }
        return false;
    }

    public String toString() {
        return super.toString() + "{ url=" + this.url + " }";
    }

    public static String getShortName(String name) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        name = name.substring(name.lastIndexOf("/") + 1);
        return name;
    }
}

