/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;

public class DeploymentFilter
implements FileFilter {
    private static final Comparator reverseComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int idx1 = ((String)o1).length();
            int idx2 = ((String)o2).length();
            int comp = 0;
            while (comp == 0 && idx1 > 0 && idx2 > 0) {
                comp = ((String)o1).charAt(--idx1) - ((String)o2).charAt(--idx2);
            }
            return comp == 0 ? idx1 - idx2 : comp;
        }
    };
    private static final String[] DEFAULT_PREFIXES = new String[]{"#", "%", ",", ".", "_$"};
    private static final String[] DEFAULT_SUFFIXES = new String[]{"#", "$", "%", ".BAK", ".old", ".orig", ".rej", ".bak", ",v", "~"};
    private static final String[] DEFAULT_MATCHES = new String[]{".make.state", ".nse_depinfo", "CVS", "CVS.admin", "RCS", "RCSLOG", "SCCS", "TAGS", "core", "tags"};
    private String[] suffixes;
    private String[] prefixes;
    private String[] matches;

    public DeploymentFilter() {
        this.suffixes = DEFAULT_SUFFIXES;
        this.prefixes = DEFAULT_PREFIXES;
        this.matches = DEFAULT_MATCHES;
    }

    public DeploymentFilter(String[] matches, String[] prefixes, String[] suffixes) {
        if (matches != null) {
            Arrays.sort(matches);
            this.matches = matches;
        } else {
            this.matches = DEFAULT_MATCHES;
        }
        if (prefixes != null) {
            Arrays.sort(prefixes);
            this.prefixes = prefixes;
        } else {
            this.prefixes = DEFAULT_PREFIXES;
        }
        if (suffixes != null) {
            Arrays.sort(suffixes, reverseComparator);
            this.suffixes = suffixes;
        } else {
            this.suffixes = DEFAULT_SUFFIXES;
        }
    }

    public boolean accept(File file) {
        String name = file.getName();
        int index = Arrays.binarySearch(this.matches, name);
        if (index >= 0) {
            return false;
        }
        index = Arrays.binarySearch(this.prefixes, name);
        if (index >= 0) {
            return false;
        }
        if (index < -1 && name.startsWith(this.prefixes[-2 - index])) {
            return false;
        }
        index = Arrays.binarySearch(this.suffixes, name, reverseComparator);
        if (index >= 0) {
            return false;
        }
        return index >= -1 || !name.endsWith(this.suffixes[-2 - index]);
    }

    static {
        Arrays.sort(DEFAULT_PREFIXES);
        Arrays.sort(DEFAULT_SUFFIXES, reverseComparator);
        Arrays.sort(DEFAULT_MATCHES);
    }
}

