/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.scanner.AbstractDeploymentScanner;
import org.jboss.deployment.scanner.DeploymentScanner;
import org.jboss.deployment.scanner.URLDeploymentScannerMBean;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.NullArgumentException;

public class URLDeploymentScanner
extends AbstractDeploymentScanner
implements DeploymentScanner,
URLDeploymentScannerMBean {
    protected List urlList = Collections.synchronizedList(new ArrayList());
    protected Set deployedSet = Collections.synchronizedSet(new HashSet());
    protected File serverHome;
    protected Comparator sorter;
    protected FileFilter filter;

    public void setURLList(List list) {
        if (list == null) {
            throw new NullArgumentException("list");
        }
        boolean debug = this.log.isDebugEnabled();
        this.urlList.clear();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (url == null) {
                throw new NullArgumentException("list element");
            }
            this.addURL(url);
        }
        if (debug) {
            this.log.debug((Object)("URL list: " + this.urlList));
        }
    }

    public void setURLComparator(String comparatorClassName) {
        try {
            this.sorter = (Comparator)Class.forName(comparatorClassName).newInstance();
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to create URLComparator.", (Throwable)e);
        }
    }

    public String getURLComparator() {
        if (this.sorter == null) {
            return null;
        }
        return this.sorter.getClass().getName();
    }

    public void setFilter(String filterClassName) {
        try {
            this.filter = (FileFilter)Class.forName(filterClassName).newInstance();
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to create URLComparator.", (Throwable)e);
        }
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getClass().getName();
    }

    public List getURLList() {
        return new ArrayList(this.urlList);
    }

    public void addURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        this.urlList.add(url);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added url: " + url));
        }
    }

    public void removeURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        boolean success = this.urlList.remove(url);
        if (success && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removed url: " + url));
        }
    }

    public boolean hasURL(URL url) {
        if (url == null) {
            throw new NullArgumentException("url");
        }
        return this.urlList.contains(url);
    }

    public void setURLs(String listspec) throws MalformedURLException {
        if (listspec == null) {
            throw new NullArgumentException("listspec");
        }
        boolean debug = this.log.isDebugEnabled();
        LinkedList<URL> list = new LinkedList<URL>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urlspec = stok.nextToken().trim();
            if (debug) {
                this.log.debug((Object)("Adding URL from spec: " + urlspec));
            }
            URL url = this.makeURL(urlspec);
            if (debug) {
                this.log.debug((Object)("URL: " + url));
            }
            list.add(url);
        }
        this.setURLList(list);
    }

    protected URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        boolean trace = this.log.isTraceEnabled();
        try {
            url = new URL(urlspec);
            if (trace) {
                this.log.trace((Object)("using raw url: " + url));
            }
        }
        catch (MalformedURLException e) {
            File file = new File(urlspec);
            if (trace) {
                this.log.trace((Object)("converted to file: " + file));
            }
            if (!file.isAbsolute()) {
                file = new File(this.serverHome, urlspec);
                if (trace) {
                    this.log.trace((Object)("made absolute: " + file));
                }
            }
            try {
                file = file.getCanonicalFile();
                if (trace) {
                    this.log.trace((Object)("made canonical: " + file));
                }
            }
            catch (IOException x) {
                throw new MalformedURLException("Invalid urlspec: " + urlspec);
            }
            url = file.toURL();
        }
        return url;
    }

    public void addURL(String urlspec) throws MalformedURLException {
        this.addURL(this.makeURL(urlspec));
    }

    public void removeURL(String urlspec) throws MalformedURLException {
        this.removeURL(this.makeURL(urlspec));
    }

    public boolean hasURL(String urlspec) throws MalformedURLException {
        return this.hasURL(this.makeURL(urlspec));
    }

    protected void deploy(DeployedURL du) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Deploying: " + du));
            }
            this.deployer.deploy(du.url);
            du.deployed();
            if (!this.deployedSet.contains(du)) {
                this.deployedSet.add(du);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to deploy: " + du), (Throwable)e);
        }
    }

    protected void undeploy(DeployedURL du) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Undeploying: " + du));
            }
            this.deployer.undeploy(du.url);
            this.deployedSet.remove(du);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to undeploy: " + du), (Throwable)e);
        }
    }

    protected boolean isDeployed(URL url) {
        DeployedURL du = new DeployedURL(url);
        return this.deployedSet.contains(du);
    }

    public synchronized void scan() throws Exception {
        if (this.urlList == null) {
            throw new IllegalStateException("not initialized");
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"Scanning for new deployments");
        }
        List list = this.urlList;
        synchronized (list) {
            URL[] urls = this.urlList.toArray(new URL[0]);
            int i = 0;
            while (i < urls.length) {
                if (!this.isDeployed(urls[i])) {
                    if (urls[i].getProtocol().equals("file")) {
                        this.scanDirectory(urls[i]);
                    } else {
                        this.deploy(new DeployedURL(urls[i]));
                    }
                }
                ++i;
            }
        }
        if (trace) {
            this.log.trace((Object)"Scanning existing deployments for removal or modification");
        }
        LinkedList<DeployedURL> removed = new LinkedList<DeployedURL>();
        LinkedList<DeployedURL> modified = new LinkedList<DeployedURL>();
        Iterator iter = this.deployedSet.iterator();
        while (iter.hasNext()) {
            DeployedURL du = (DeployedURL)iter.next();
            if (trace) {
                this.log.trace((Object)("Checking deployment: " + du));
            }
            if (du.isRemoved()) {
                removed.add(du);
                continue;
            }
            if (!du.isModified()) continue;
            modified.add(du);
        }
        Iterator iter2 = removed.iterator();
        while (iter2.hasNext()) {
            DeployedURL du = (DeployedURL)iter2.next();
            this.undeploy(du);
        }
        Iterator iter3 = modified.iterator();
        while (iter3.hasNext()) {
            DeployedURL du = (DeployedURL)iter3.next();
            this.undeploy(du);
            this.deploy(du);
        }
    }

    protected void scanDirectory(URL url) throws Exception {
        File[] files;
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Scanning directory: " + url));
        }
        if (this.isDeployed(url)) {
            return;
        }
        File file = new File(url.getFile());
        if (!file.exists()) {
            if (trace) {
                this.log.trace((Object)("Skipping non-existant file: " + file));
            }
            return;
        }
        if (!file.isDirectory()) {
            this.deploy(new DeployedURL(url));
            return;
        }
        File[] fileArray = files = this.filter == null ? file.listFiles() : file.listFiles(this.filter);
        if (files == null) {
            throw new Exception("Null files returned from directory listing");
        }
        LinkedList<URL> list = new LinkedList<URL>();
        int i = 0;
        while (i < files.length) {
            if (trace) {
                this.log.trace((Object)("Checking deployment file: " + files[i]));
            }
            if (!this.isDeployed(url = files[i].toURL())) {
                list.add(url);
            }
            ++i;
        }
        if (this.sorter != null) {
            Collections.sort(list, this.sorter);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            url = (URL)iter.next();
            this.deploy(new DeployedURL(url));
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.serverHome = ServerConfigLocator.locate().getServerHomeDir();
        return super.preRegister(server, name);
    }

    protected class DeployedURL {
        public URL url;
        public URL watchUrl;
        public long deployedLastModified;
        static /* synthetic */ Class class$java$net$URL;

        public DeployedURL(URL url) {
            this.url = url;
        }

        public void deployed() {
            this.deployedLastModified = this.getLastModified();
        }

        public boolean isFile() {
            return this.url.getProtocol().equals("file");
        }

        public File getFile() {
            return new File(this.url.getFile());
        }

        public boolean isRemoved() {
            if (this.isFile()) {
                File file = this.getFile();
                return !file.exists();
            }
            return false;
        }

        public long getLastModified() {
            if (this.watchUrl == null) {
                try {
                    Object o = URLDeploymentScanner.this.getServer().invoke(URLDeploymentScanner.this.getDeployer(), "getWatchUrl", new Object[]{this.url}, new String[]{(class$java$net$URL == null ? (class$java$net$URL = DeployedURL.class$("java.net.URL")) : class$java$net$URL).getName()});
                    this.watchUrl = o == null ? this.url : (URL)o;
                    URLDeploymentScanner.this.getLog().debug((Object)("Watch URL for: " + this.url + " -> " + this.watchUrl));
                }
                catch (Exception e) {
                    this.watchUrl = this.url;
                    URLDeploymentScanner.this.getLog().debug((Object)("Unable to obtain watchUrl from deployer.  Use url: " + this.url), (Throwable)e);
                }
            }
            try {
                URLConnection connection = this.watchUrl != null ? this.watchUrl.openConnection() : this.url.openConnection();
                long lastModified = connection.getLastModified();
                return lastModified;
            }
            catch (IOException e) {
                URLDeploymentScanner.this.getLog().warn((Object)("Failed to check modfication of deployed url: " + this.url), (Throwable)e);
                return -1L;
            }
        }

        public boolean isModified() {
            return this.deployedLastModified != this.getLastModified();
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof DeployedURL) {
                return ((DeployedURL)other).url.equals(this.url);
            }
            return false;
        }

        public String toString() {
            return super.toString() + "{ url=" + this.url + ", deployedLastModified=" + this.deployedLastModified + " }";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

