/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.logging.Log4jServiceMBean;
import org.jboss.logging.Logger;
import org.jboss.logging.util.CategoryStream;
import org.jboss.util.NullArgumentException;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.ThrowableListener;

public class Log4jService
implements Log4jServiceMBean,
MBeanRegistration {
    public static final String DEFAULT_PATH = System.getProperty((class$org$jboss$logging$Log4jService == null ? (class$org$jboss$logging$Log4jService = Log4jService.class$("org.jboss.logging.Log4jService")) : class$org$jboss$logging$Log4jService).getName() + ".configfile", "log4j.xml");
    public static final boolean CATCH_SYSTEM_OUT = Log4jService.getBoolean((class$org$jboss$logging$Log4jService == null ? (class$org$jboss$logging$Log4jService = Log4jService.class$("org.jboss.logging.Log4jService")) : class$org$jboss$logging$Log4jService).getName() + ".catchSystemOut", true);
    public static final boolean CATCH_SYSTEM_ERR = Log4jService.getBoolean((class$org$jboss$logging$Log4jService == null ? (class$org$jboss$logging$Log4jService = Log4jService.class$("org.jboss.logging.Log4jService")) : class$org$jboss$logging$Log4jService).getName() + ".catchSystemErr", true);
    private static final Category log = Category.getInstance((Class)(class$org$jboss$logging$Log4jService == null ? (class$org$jboss$logging$Log4jService = Log4jService.class$("org.jboss.logging.Log4jService")) : class$org$jboss$logging$Log4jService));
    private String configurationPath;
    private int refreshPeriod;
    private ThrowableListenerLoggingAdapter throwableAdapter;
    private PrintStream out;
    private PrintStream err;
    private Timer timer = new Timer(true);
    static /* synthetic */ Class class$org$jboss$logging$Log4jService;

    private static boolean getBoolean(String name, boolean defaultValue) {
        String value = System.getProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        return new Boolean(value);
    }

    public Log4jService() {
        this(DEFAULT_PATH, 60);
    }

    public Log4jService(String path) {
        this(path, 60);
    }

    public Log4jService(String path, int refreshPeriod) {
        this.configurationPath = path;
        this.refreshPeriod = refreshPeriod;
    }

    public int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String path) {
        this.configurationPath = path;
    }

    public void start() throws Exception {
        log.debug((Object)("Configuration path: " + this.configurationPath));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(this.configurationPath);
        if (url == null) {
            throw new FileNotFoundException("Failed to find logj4 configuration: " + this.configurationPath);
        }
        log.debug((Object)("Configuration URL: " + url));
        URLWatchTimerTask timerTask = new URLWatchTimerTask(url);
        timerTask.run();
        this.timer.schedule((TimerTask)timerTask, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
        Category category = Category.getRoot();
        this.throwableAdapter = new ThrowableListenerLoggingAdapter();
        ThrowableHandler.addThrowableListener((ThrowableListener)this.throwableAdapter);
        log.debug((Object)("Added ThrowableListener: " + this.throwableAdapter));
        log.info((Object)"Started");
    }

    private void installSystemAdapters() {
        Category category;
        if (CATCH_SYSTEM_OUT) {
            category = Category.getInstance((String)"STDOUT");
            this.out = System.out;
            System.setOut((PrintStream)new CategoryStream(category, Priority.INFO, this.out));
            log.debug((Object)"Installed System.out adapter");
        }
        if (CATCH_SYSTEM_ERR) {
            category = Category.getInstance((String)"STDERR");
            this.err = System.err;
            System.setErr((PrintStream)new CategoryStream(category, Priority.ERROR, this.err));
            log.debug((Object)"Installed System.err adapter");
        }
    }

    private void uninstallSystemAdapters() {
        if (this.out != null) {
            System.out.flush();
            System.setOut(this.out);
            log.debug((Object)"Removed System.out adapter");
            this.out = null;
        }
        if (this.err != null) {
            System.err.flush();
            System.setErr(this.err);
            log.debug((Object)"Removed System.err adapter");
            this.err = null;
        }
    }

    public void stop() {
        ThrowableHandler.removeThrowableListener((ThrowableListener)this.throwableAdapter);
        this.uninstallSystemAdapters();
        Category.shutdown();
        log.debug((Object)"Stopped");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.start();
        return name == null ? Log4jServiceMBean.OBJECT_NAME : name;
    }

    public void postRegister(Boolean b) {
    }

    public void preDeregister() {
    }

    public void postDeregister() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class URLWatchTimerTask
    extends TimerTask {
        private Logger log = Logger.getLogger((Class)(class$org$jboss$logging$Log4jService$URLWatchTimerTask == null ? (class$org$jboss$logging$Log4jService$URLWatchTimerTask = URLWatchTimerTask.class$("org.jboss.logging.Log4jService$URLWatchTimerTask")) : class$org$jboss$logging$Log4jService$URLWatchTimerTask));
        private long lastConfigured = -1L;
        private URL url;
        static /* synthetic */ Class class$org$jboss$logging$Log4jService$URLWatchTimerTask;

        public URLWatchTimerTask(URL url) {
            if (url == null) {
                throw new NullArgumentException("url");
            }
            this.url = url;
        }

        public void run() {
            this.log.trace((Object)"Checking if configuration changed");
            boolean trace = this.log.isTraceEnabled();
            try {
                URLConnection conn = this.url.openConnection();
                if (trace) {
                    this.log.trace((Object)("connection: " + conn));
                }
                long lastModified = conn.getLastModified();
                if (trace) {
                    this.log.trace((Object)("last modified: " + lastModified));
                }
                if (this.lastConfigured < lastModified) {
                    this.log.debug((Object)"URL changed, configuring");
                    this.reconfigure(conn);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to check URL: " + this.url), (Throwable)e);
            }
        }

        private void reconfigure(URLConnection conn) {
            boolean xml = false;
            xml = this.url.getProtocol().equals("file") ? this.url.getFile().toLowerCase().endsWith(".xml") : conn.getContentType().toLowerCase().equals("text/xml");
            this.log.debug((Object)("reconfiguring; xml=" + xml));
            Log4jService.this.uninstallSystemAdapters();
            if (xml) {
                DOMConfigurator.configure((URL)this.url);
            } else {
                PropertyConfigurator.configure((URL)this.url);
            }
            Log4jService.this.installSystemAdapters();
            this.lastConfigured = System.currentTimeMillis();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class ThrowableListenerLoggingAdapter
    implements ThrowableListener {
        private Logger log = Logger.getLogger((Class)(class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter == null ? (class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter = ThrowableListenerLoggingAdapter.class$("org.jboss.logging.Log4jService$ThrowableListenerLoggingAdapter")) : class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter));
        static /* synthetic */ Class class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter;

        private ThrowableListenerLoggingAdapter() {
        }

        public void onThrowable(int type, Throwable t) {
            switch (type) {
                default: {
                    this.log.error((Object)"unhandled throwable", t);
                    break;
                }
                case 2: {
                    this.log.warn((Object)"unhandled throwable", t);
                    break;
                }
                case 0: {
                    this.log.trace((Object)"unhandled throwable, status is unknown", t);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

