/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceCreator;
import org.jboss.util.jmx.JMXExceptionDecoder;
import org.jboss.util.jmx.ObjectNameFactory;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ServiceConfigurator {
    private static Hashtable primitives = new Hashtable();
    private final MBeanServer server;
    private final ServiceController serviceController;
    private final ServiceCreator serviceCreator;
    private final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$util$Properties;

    public ServiceConfigurator(MBeanServer server, ServiceController serviceController, ServiceCreator serviceCreator) {
        this.server = server;
        this.serviceController = serviceController;
        this.serviceCreator = serviceCreator;
    }

    /*
     * Unable to fully structure code
     */
    public List install(Element config) throws DeploymentException {
        mbeans = new ArrayList<E>();
        try {
            if (config.getTagName().equals("mbean")) {
                this.internalInstall(config, mbeans);
            } else {
                nl = config.getChildNodes();
                i = 0;
                while (i < nl.getLength()) {
                    if (nl.item(i).getNodeType() == 1 && (element = (Element)nl.item(i)).getTagName().equals("mbean")) {
                        mbean = (Element)nl.item(i);
                        this.internalInstall(mbean, mbeans);
                    }
                    ++i;
                }
            }
            return mbeans;
        }
        catch (DeploymentException de) {
            li = mbeans.listIterator(mbeans.size());
            ** while (li.hasPrevious())
        }
lbl-1000:
        // 1 sources

        {
            mbean = (ObjectName)li.previous();
            try {
                this.serviceCreator.remove(mbean);
            }
            catch (Exception e) {
                this.log.info((Object)("exception removing mbean after failed deployment: " + mbean), (Throwable)e);
            }
            continue;
        }
lbl27:
        // 1 sources

        throw de;
    }

    private ObjectName internalInstall(Element mbeanElement, List mbeans) throws DeploymentException {
        ObjectInstance instance = null;
        ObjectName mbeanName = this.parseObjectName(mbeanElement);
        try {
            instance = this.serviceCreator.install(mbeanName, mbeanElement);
        }
        catch (ClassNotFoundException cnfe) {
            this.serviceController.registerWaitingForClass(mbeanName, mbeanElement);
            return mbeanName;
        }
        catch (Exception e) {
            throw new DeploymentException("could not create mbean", e);
        }
        this.serviceController.registerMBeanClassName(instance);
        mbeanName = instance.getObjectName();
        mbeans.add(mbeanName);
        if (mbeanName != null) {
            try {
                this.configure(mbeanName, mbeanElement, mbeans);
                this.serviceController.getServiceContext((ObjectName)mbeanName).state = ServiceContext.CONFIGURED;
            }
            catch (DeploymentException de) {
                this.serviceController.getServiceContext((ObjectName)mbeanName).state = ServiceContext.FAILED;
                throw de;
            }
        }
        return mbeanName;
    }

    protected void configure(ObjectName objectName, Element mbeanElement, List mbeans) throws DeploymentException {
        MBeanInfo info;
        boolean debug = this.log.isDebugEnabled();
        try {
            info = this.server.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException e) {
            throw new DeploymentException("trying to configure nonexistent mbean: " + objectName);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not get mbeanInfo", JMXExceptionDecoder.decode((Exception)e));
        }
        if (info == null) {
            throw new DeploymentException("MBeanInfo is null for mbean: " + objectName);
        }
        MBeanAttributeInfo[] attributes = info.getAttributes();
        NodeList attrs = mbeanElement.getChildNodes();
        int j = 0;
        while (j < attrs.getLength()) {
            block40: {
                if (attrs.item(j).getNodeType() == 1) {
                    Element element = (Element)attrs.item(j);
                    if (element.getTagName().equals("attribute")) {
                        String attributeName = element.getAttribute("name");
                        if (element.hasChildNodes()) {
                            Node n = element.getFirstChild();
                            String attributeText = null;
                            if (n instanceof Text) {
                                attributeText = ((Text)n).getData().trim();
                            }
                            int k = 0;
                            while (k < attributes.length) {
                                if (attributeName.equals(attributes[k].getName())) {
                                    Class typeClass;
                                    String typeName = attributes[k].getType();
                                    if (primitives.containsKey(typeName)) {
                                        typeClass = (Class)primitives.get(typeName);
                                    } else {
                                        try {
                                            typeClass = Class.forName(typeName);
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw new DeploymentException("Attribute class " + typeName + " not found");
                                        }
                                    }
                                    Object value = null;
                                    if (typeClass.equals(class$org$w3c$dom$Element == null ? ServiceConfigurator.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element)) {
                                        NodeList nl = element.getChildNodes();
                                        int i = 0;
                                        while (i < nl.getLength()) {
                                            n = nl.item(i);
                                            if (n.getNodeType() == 1) {
                                                value = (Element)n;
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                    if (typeClass.equals(class$javax$management$ObjectName == null ? ServiceConfigurator.class$("javax.management.ObjectName") : class$javax$management$ObjectName)) {
                                        try {
                                            value = new ObjectName(attributeText);
                                        }
                                        catch (Exception e) {
                                            throw new DeploymentException(e.getMessage());
                                        }
                                    }
                                    if (typeClass.equals(class$java$util$Properties == null ? ServiceConfigurator.class$("java.util.Properties") : class$java$util$Properties)) {
                                        try {
                                            ByteArrayInputStream is = new ByteArrayInputStream(attributeText.getBytes());
                                            Properties p = new Properties();
                                            p.load(is);
                                            value = p;
                                        }
                                        catch (Exception e) {
                                            throw new DeploymentException(e.getMessage());
                                        }
                                    }
                                    if (value == null) {
                                        PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                                        if (editor == null) {
                                            throw new DeploymentException("No property editor for attribute: " + attributeName + "; type=" + typeClass);
                                        }
                                        editor.setAsText(attributeText);
                                        value = editor.getValue();
                                    }
                                    this.log.debug((Object)(attributeName + " set to " + value + " in " + objectName));
                                    this.setAttribute(objectName, new Attribute(attributeName, value));
                                    break block40;
                                }
                                ++k;
                            }
                            throw new DeploymentException("No Attribute found with name: " + attributeName);
                        }
                    } else if (element.getTagName().equals("depends")) {
                        if (!element.hasChildNodes()) {
                            throw new DeploymentException("No ObjectName supplied for depends in  " + objectName);
                        }
                        String mbeanRefName = element.getAttribute("optional-attribute-name");
                        if ("".equals(mbeanRefName)) {
                            mbeanRefName = null;
                        }
                        ObjectName dependsObjectName = this.processDependency(objectName, element, mbeans);
                        if (debug) {
                            this.log.debug((Object)("considering " + (mbeanRefName == null ? "<anonymous>" : mbeanRefName.toString()) + " with object name " + dependsObjectName));
                        }
                        if (mbeanRefName != null) {
                            this.setAttribute(objectName, new Attribute(mbeanRefName, dependsObjectName));
                        }
                    } else if (element.getTagName().equals("depends-list")) {
                        String dependsListName = element.getAttribute("optional-attribute-name");
                        if ("".equals(dependsListName)) {
                            dependsListName = null;
                        }
                        NodeList dependsList = element.getChildNodes();
                        ArrayList<ObjectName> dependsListNames = new ArrayList<ObjectName>();
                        int l = 0;
                        while (l < dependsList.getLength()) {
                            Element dependsElement;
                            if (dependsList.item(l).getNodeType() == 1 && (dependsElement = (Element)dependsList.item(l)).getTagName().equals("depends-list-element")) {
                                if (!dependsElement.hasChildNodes()) {
                                    throw new DeploymentException("Empty depends-list-element!");
                                }
                                ObjectName dependsObjectName = this.processDependency(objectName, dependsElement, mbeans);
                                if (!dependsListNames.contains(dependsObjectName)) {
                                    dependsListNames.add(dependsObjectName);
                                }
                            }
                            ++l;
                        }
                        if (dependsListName != null) {
                            this.setAttribute(objectName, new Attribute(dependsListName, dependsListNames));
                        }
                    }
                }
            }
            ++j;
        }
    }

    private ObjectName processDependency(ObjectName container, Element element, List mbeans) throws DeploymentException {
        ObjectName dependsObjectName = null;
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node childNode = nl.item(i);
            if (childNode.getNodeType() == 1) {
                Element child = (Element)childNode;
                if (child.getTagName().equals("mbean")) {
                    dependsObjectName = this.internalInstall(child, mbeans);
                    break;
                }
                throw new DeploymentException("Non mbean child element in depends tag: " + child);
            }
            ++i;
        }
        if (dependsObjectName == null) {
            if (nl.item(0).getNodeType() == 3) {
                String name = ((Text)nl.item(0)).getData().trim();
                dependsObjectName = ObjectNameFactory.create((String)name);
            } else {
                throw new DeploymentException("Nothing supplied for an object name! " + element);
            }
        }
        this.serviceController.registerDependency(container, dependsObjectName);
        return dependsObjectName;
    }

    private void setAttribute(ObjectName name, Attribute attr) throws DeploymentException {
        try {
            this.server.setAttribute(name, attr);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception setting attribute " + attr + " on mbean " + name, JMXExceptionDecoder.decode((Exception)e));
        }
    }

    public String getConfiguration(ObjectName[] objectNames) throws Exception {
        boolean debug = this.log.isDebugEnabled();
        StringWriter out = new StringWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element serverElement = doc.createElement("server");
        int j = 0;
        while (j < objectNames.length) {
            Element mbeanElement = this.internalGetConfiguration(doc, objectNames[j]);
            serverElement.appendChild(mbeanElement);
            ++j;
        }
        doc.appendChild(serverElement);
        new DOMWriter((Writer)out, false).print((Node)doc, true);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    Element getConfiguration(ObjectName name) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        return this.internalGetConfiguration(doc, name);
    }

    private Element internalGetConfiguration(Document doc, ObjectName name) throws Exception {
        Element mbeanElement = doc.createElement("mbean");
        mbeanElement.setAttribute("name", name.toString());
        MBeanInfo info = this.server.getMBeanInfo(name);
        mbeanElement.setAttribute("code", info.getClassName());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        boolean hasAttributes = true;
        int i = 0;
        while (i < attributes.length) {
            this.log.trace((Object)("considering attribute: " + attributes[i]));
            if (attributes[i].isReadable() && attributes[i].isWritable()) {
                Element attributeElement = null;
                if (attributes[i].getType().equals("javax.management.ObjectName")) {
                    attributeElement = doc.createElement("depends");
                    attributeElement.setAttribute("optional-attribute-name", attributes[i].getName());
                } else {
                    attributeElement = doc.createElement("attribute");
                    attributeElement.setAttribute("name", attributes[i].getName());
                }
                Object value = this.server.getAttribute(name, attributes[i].getName());
                if (value != null) {
                    if (value instanceof Element) {
                        attributeElement.appendChild(doc.importNode((Element)value, true));
                    } else {
                        attributeElement.appendChild(doc.createTextNode(value.toString()));
                    }
                }
                mbeanElement.appendChild(attributeElement);
            }
            ++i;
        }
        ServiceContext sc = this.serviceController.getServiceContext(name);
        Iterator i2 = sc.iDependOn.iterator();
        while (i2.hasNext()) {
            ServiceContext needs = (ServiceContext)i2.next();
            Element dependsElement = doc.createElement("depends");
            dependsElement.appendChild(doc.createTextNode(needs.objectName.toString()));
            mbeanElement.appendChild(dependsElement);
        }
        return mbeanElement;
    }

    private ObjectName parseObjectName(Element element) throws DeploymentException {
        String name = element.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new DeploymentException("MBean attribute 'name' must be given.");
        }
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException mone) {
            throw new DeploymentException("Malformed ObjectName: " + name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitives.put("int", Integer.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("long", Long.TYPE);
    }
}

