/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.lang.reflect.Constructor;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.system.ConfigurationException;
import org.jboss.util.jmx.JMXExceptionDecoder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceCreator {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$system$ServiceCreator == null ? (class$org$jboss$system$ServiceCreator = ServiceCreator.class$("org.jboss.system.ServiceCreator")) : class$org$jboss$system$ServiceCreator));
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$system$ServiceCreator;

    public ServiceCreator(MBeanServer server) {
        this.server = server;
    }

    public ObjectInstance install(ObjectName mbeanName, Element mbeanElement) throws Exception {
        boolean debug = log.isDebugEnabled();
        if (this.server.isRegistered(mbeanName)) {
            throw new DeploymentException("Trying to install an already registered mbean: " + mbeanName);
        }
        String code = mbeanElement.getAttribute("code");
        if (code == null) {
            throw new ConfigurationException("missing 'code' attribute");
        }
        ConstructorInfo constructor = ConstructorInfo.create(mbeanElement);
        log.debug((Object)("About to create bean: " + mbeanName));
        try {
            if (debug) {
                log.debug((Object)("code: " + code));
            }
            ObjectInstance instance = this.server.createMBean(code, mbeanName, constructor.params, constructor.signature);
            if (debug) {
                log.debug((Object)("Created bean: " + mbeanName));
            }
            return instance;
        }
        catch (Exception e) {
            Throwable newE = JMXExceptionDecoder.decode((Exception)e);
            if (newE instanceof ClassNotFoundException) {
                log.debug((Object)("Class not found for mbean: " + mbeanName));
                throw (ClassNotFoundException)newE;
            }
            try {
                this.server.unregisterMBean(mbeanName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw e;
        }
    }

    public void remove(ObjectName name) throws Exception {
        String domain = name.getDomain();
        int hcode = name.hashCode();
        if (domain == null || "".equals(domain)) {
            name = new ObjectName(this.server.getDefaultDomain() + name);
        }
        this.server.unregisterMBean(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConstructorInfo {
        public static final Object[] EMPTY_PARAMS = new Object[0];
        public static final String[] EMPTY_SIGNATURE = new String[0];
        public String[] signature = EMPTY_SIGNATURE;
        public Object[] params = EMPTY_PARAMS;
        static /* synthetic */ Class class$java$lang$String;

        private ConstructorInfo() {
        }

        public static ConstructorInfo create(Element element) throws ConfigurationException {
            ConstructorInfo info = new ConstructorInfo();
            NodeList list = element.getElementsByTagName("constructor");
            if (list.getLength() > 1) {
                throw new ConfigurationException("only one <constructor> element may be defined");
            }
            if (list.getLength() == 1) {
                element = (Element)list.item(0);
                list = element.getElementsByTagName("arg");
                int length = list.getLength();
                info.params = new Object[length];
                info.signature = new String[length];
                int j = 0;
                while (j < length) {
                    Element arg = (Element)list.item(j);
                    String signature = arg.getAttribute("type");
                    String value = arg.getAttribute("value");
                    Object realValue = value;
                    if (signature != null) {
                        if (signature.equals("short")) {
                            signature = Short.TYPE.getName();
                            realValue = new Short(value);
                        } else if (signature.equals("int")) {
                            signature = Integer.TYPE.getName();
                            realValue = new Integer(value);
                        } else if (signature.equals("long")) {
                            signature = Long.TYPE.getName();
                            realValue = new Long(value);
                        } else if (signature.equals("byte")) {
                            signature = Byte.TYPE.getName();
                            realValue = new Byte(value);
                        } else if (signature.equals("char")) {
                            signature = Character.TYPE.getName();
                            realValue = new Character(value.charAt(0));
                        } else if (signature.equals("float")) {
                            signature = Float.TYPE.getName();
                            realValue = new Float(value);
                        } else if (signature.equals("double")) {
                            signature = Double.TYPE.getName();
                            realValue = new Double(value);
                        } else if (signature.equals("boolean")) {
                            signature = Boolean.TYPE.getName();
                            realValue = new Boolean(value);
                        } else {
                            try {
                                Class<?> signatureClass = Thread.currentThread().getContextClassLoader().loadClass(signature);
                                Constructor<?> signatureConstructor = signatureClass.getConstructor(class$java$lang$String == null ? ConstructorInfo.class$("java.lang.String") : class$java$lang$String);
                                realValue = signatureConstructor.newInstance(value);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    info.signature[j] = signature;
                    info.params[j] = realValue;
                    ++j;
                }
            }
            return info;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

