/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.util.MuBoolean;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.Null;

public class ServerConfigImpl
implements ServerConfig,
ServerConfigImplMBean {
    private Properties props;
    private File homeDir;
    private URL homeURL;
    private URL libraryURL;
    private Object patchURL;
    private String serverName;
    private File serverBaseDir;
    private File serverHomeDir;
    private File serverTempDir;
    private File serverDataDir;
    private URL serverBaseURL;
    private URL serverHomeURL;
    private URL serverLibraryURL;
    private URL serverConfigURL;
    private MuBoolean exitOnShutdown;

    public ServerConfigImpl(Properties props) throws Exception {
        this.props = props;
        this.homeDir = this.getFile("jboss.home.dir");
        if (this.homeDir == null) {
            throw new Exception("Missing configuration value for: jboss.home.dir");
        }
        System.setProperty("jboss.home.dir", this.homeDir.toString());
        this.homeURL = this.getURL("jboss.home.url");
        if (this.homeURL == null) {
            this.homeURL = this.homeDir.toURL();
        }
        System.setProperty("jboss.home.url", this.homeURL.toString());
    }

    private URL getURL(String name) throws MalformedURLException {
        String value = this.props.getProperty(name, null);
        if (value != null) {
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            return new URL(value);
        }
        return null;
    }

    private File getFile(String name) {
        String value = this.props.getProperty(name, null);
        if (value != null) {
            return new File(value);
        }
        return null;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public URL getHomeURL() {
        return this.homeURL;
    }

    public URL getLibraryURL() {
        if (this.libraryURL == null) {
            try {
                this.libraryURL = this.getURL("jboss.lib.url");
                if (this.libraryURL == null) {
                    this.libraryURL = new URL(this.homeURL, "lib/");
                }
                System.setProperty("jboss.lib.url", this.libraryURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.libraryURL;
    }

    public URL getPatchURL() {
        if (this.patchURL == null) {
            try {
                this.patchURL = this.getURL("jboss.patch.url");
                if (this.patchURL == null) {
                    this.patchURL = Null.VALUE;
                } else {
                    System.setProperty("jboss.patch.url", this.patchURL.toString());
                }
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        if (this.patchURL == Null.VALUE) {
            return null;
        }
        return (URL)this.patchURL;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.props.getProperty("jboss.server.name", "default");
            System.setProperty("jboss.server.name", this.serverName);
        }
        return this.serverName;
    }

    public File getServerBaseDir() {
        if (this.serverBaseDir == null) {
            this.serverBaseDir = this.getFile("jboss.server.base.dir");
            if (this.serverBaseDir == null) {
                this.serverBaseDir = new File(this.homeDir, "server");
                System.setProperty("jboss.server.base.dir", this.serverBaseDir.toString());
            }
        }
        return this.serverBaseDir;
    }

    public File getServerHomeDir() {
        if (this.serverHomeDir == null) {
            this.serverHomeDir = this.getFile("jboss.server.home.dir");
            if (this.serverHomeDir == null) {
                this.serverHomeDir = new File(this.getServerBaseDir(), this.getServerName());
                System.setProperty("jboss.server.home.dir", this.serverHomeDir.toString());
            }
        }
        return this.serverHomeDir;
    }

    public File getServerTempDir() {
        if (this.serverTempDir == null) {
            this.serverTempDir = this.getFile("jboss.server.temp.dir");
            if (this.serverTempDir == null) {
                this.serverTempDir = new File(this.getServerHomeDir(), "tmp");
                System.setProperty("jboss.server.temp.dir", this.serverTempDir.toString());
            }
        }
        return this.serverTempDir;
    }

    public File getServerDataDir() {
        if (this.serverDataDir == null) {
            this.serverDataDir = this.getFile("jboss.server.data.dir");
            if (this.serverDataDir == null) {
                this.serverDataDir = new File(this.getServerHomeDir(), "db");
                System.setProperty("jboss.server.data.dir", this.serverDataDir.toString());
            }
        }
        return this.serverDataDir;
    }

    public URL getServerBaseURL() {
        if (this.serverBaseURL == null) {
            try {
                this.serverBaseURL = this.getURL("jboss.server.base.url");
                if (this.serverBaseURL == null) {
                    this.serverBaseURL = new URL(this.homeURL, "server/");
                }
                System.setProperty("jboss.server.base.url", this.serverBaseURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverBaseURL;
    }

    public URL getServerHomeURL() {
        if (this.serverHomeURL == null) {
            try {
                this.serverHomeURL = this.getURL("jboss.server.home.url");
                if (this.serverHomeURL == null) {
                    this.serverHomeURL = new URL(this.getServerBaseURL(), this.getServerName() + "/");
                }
                System.setProperty("jboss.server.home.url", this.serverHomeURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverHomeURL;
    }

    public URL getServerLibraryURL() {
        if (this.serverLibraryURL == null) {
            try {
                this.serverLibraryURL = this.getURL("jboss.server.lib.url");
                if (this.serverLibraryURL == null) {
                    this.serverLibraryURL = new URL(this.getServerHomeURL(), "lib/");
                }
                System.setProperty("jboss.server.lib.url", this.serverLibraryURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverLibraryURL;
    }

    public URL getServerConfigURL() {
        if (this.serverConfigURL == null) {
            try {
                this.serverConfigURL = this.getURL("jboss.server.config.url");
                if (this.serverConfigURL == null) {
                    this.serverConfigURL = new URL(this.getServerHomeURL(), "conf/");
                }
                System.setProperty("jboss.server.config.url", this.serverConfigURL.toString());
            }
            catch (MalformedURLException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        return this.serverConfigURL;
    }

    public void setExitOnShutdown(boolean flag) {
        if (this.exitOnShutdown == null) {
            this.exitOnShutdown = new MuBoolean(flag);
        } else {
            this.exitOnShutdown.set(flag);
        }
    }

    public boolean getExitOnShutdown() {
        if (this.exitOnShutdown == null) {
            String value = this.props.getProperty("jboss.server.exitonshutdown", null);
            this.exitOnShutdown = value == null ? new MuBoolean(false) : new MuBoolean(value);
        }
        return this.exitOnShutdown.get();
    }
}

