/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerInfoMBean;
import org.jboss.util.jmx.ObjectNameFactory;

public class ServerInfo
implements ServerInfoMBean,
MBeanRegistration {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$system$server$ServerInfo == null ? (class$org$jboss$system$server$ServerInfo = ServerInfo.class$("org.jboss.system.server.ServerInfo")) : class$org$jboss$system$server$ServerInfo));
    private String hostName;
    private String hostAddress;
    private MBeanServer server;
    static /* synthetic */ Class class$org$jboss$system$server$ServerInfo;
    static /* synthetic */ Class class$java$lang$String;

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        log.info((Object)("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor")));
        log.info((Object)("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor")));
        log.info((Object)("OS-System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch")));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Full System Properties Dump");
            Enumeration<?> names = System.getProperties().propertyNames();
            while (names.hasMoreElements()) {
                String pname = (String)names.nextElement();
                log.debug((Object)("    " + pname + ": " + System.getProperty(pname)));
            }
        }
        return name == null ? ServerInfoMBean.OBJECT_NAME : name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Error looking up local hostname", (Throwable)e);
                this.hostName = "<unknown>";
            }
        }
        return this.hostName;
    }

    public String getHostAddress() {
        if (this.hostAddress == null) {
            try {
                this.hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Error looking up local address", (Throwable)e);
                this.hostAddress = "<unknown>";
            }
        }
        return this.hostAddress;
    }

    public String listMemoryUsage() {
        String rc = "<P><B>Total Memory: </B>" + Runtime.getRuntime().totalMemory() + " </P>" + "<P><B>Free Memory: </B>" + Runtime.getRuntime().freeMemory() + " </P>";
        return rc;
    }

    public String listThreadDump() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        int activeThreads = root.activeCount() - 1;
        int activeGroups = root.activeGroupCount() + 1;
        String rc = "<b>Total Threads:</b> " + activeThreads + "<br>" + "<b>Total Thread Groups:</b> " + activeGroups + "<br>" + this.getThreadGroupInfo(root);
        return rc;
    }

    private String getThreadGroupInfo(ThreadGroup group) {
        StringBuffer rc = new StringBuffer();
        rc.append("<BR><B>");
        rc.append("Thread Group: " + group.getName());
        rc.append("</B> : ");
        rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
        rc.append("<blockquote>");
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads, false);
        int i = 0;
        while (i < threads.length && threads[i] != null) {
            rc.append("<B>");
            rc.append("Thread: " + threads[i].getName());
            rc.append("</B> : ");
            rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon());
            rc.append("<BR>");
            ++i;
        }
        ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
        group.enumerate(groups, false);
        int i2 = 0;
        while (i2 < groups.length && groups[i2] != null) {
            rc.append(this.getThreadGroupInfo(groups[i2]));
            ++i2;
        }
        rc.append("</blockquote>");
        return rc.toString();
    }

    public String displayPackageInfo(String pkgName) {
        Package pkg = Package.getPackage(pkgName);
        if (pkg == null) {
            return "<h2>Package:" + pkgName + " Not Found!</h2>";
        }
        StringBuffer info = new StringBuffer("<h2>Package: " + pkgName + "</h2>");
        this.displayPackageInfo(pkg, info);
        return info.toString();
    }

    public String displayInfoForClass(String className) throws Exception {
        Class clazz = (Class)this.server.invoke(DEFAULT_LOADER_REPOSITORY, "findClass", new Object[]{className}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = ServerInfo.class$("java.lang.String")) : class$java$lang$String).getName()});
        if (clazz == null) {
            return "<h2>Class:" + className + " Not Found!</h2>";
        }
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            return "<h2>Class:" + className + " has no Package info</h2>";
        }
        StringBuffer info = new StringBuffer("<h1>Class: " + pkg.getName() + "</h1>");
        ClassLoader cl = clazz.getClassLoader();
        info.append("<h2>ClassLoader: " + cl + "</h2>\n");
        info.append("<h3>ProtectionDomain</h3>\n");
        info.append("<pre>\n" + clazz.getProtectionDomain() + "</pre>\n");
        info.append("<h2>Package: " + pkg.getName() + "</h2>");
        this.displayPackageInfo(pkg, info);
        return info.toString();
    }

    public String displayAllPackageInfo() {
        return "Broken right now";
    }

    private void displayPackageInfo(Package pkg, StringBuffer info) {
        info.append("<pre>\n");
        info.append("SpecificationTitle: " + pkg.getSpecificationTitle());
        info.append("\nSpecificationVersion: " + pkg.getSpecificationVersion());
        info.append("\nSpecificationVendor: " + pkg.getSpecificationVendor());
        info.append("\nImplementationTitle: " + pkg.getImplementationTitle());
        info.append("\nImplementationVersion: " + pkg.getImplementationVersion());
        info.append("\nImplementationVendor: " + pkg.getImplementationVendor());
        info.append("\nisSealed: " + pkg.isSealed());
        info.append("</pre>\n");
    }

    public String getProperty(String name) {
        return System.getProperty(name);
    }

    public Map showProperties() {
        return new HashMap(System.getProperties()){

            public String toString() {
                StringBuffer buff = new StringBuffer();
                buff.append("<table>");
                Iterator iter = this.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    buff.append("<tr><td align=\"left\">").append(key).append("</td><td align=\"left\">").append(this.get(key)).append("</td></tr>\n\r");
                }
                buff.append("</table>");
                return buff.toString();
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

