/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.system.BarrierControllerMBean;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.jboss.system.ServiceMBeanSupport;

public class BarrierController
extends ListenerServiceMBeanSupport
implements BarrierControllerMBean {
    private ObjectName barrierName;
    private Boolean createOnStartup;
    private Boolean enableOnStartup;
    private String createHandback;
    private String startHandback;
    private String stopHandback;
    private String destroyHandback;
    private Boolean dynamicSubscriptions;
    protected Barrier barrier;

    public String getBarrierStateString() {
        return this.barrier != null ? this.barrier.getStateString() : null;
    }

    public void setBarrierObjectName(ObjectName barrierName) {
        if (this.barrierName == null) {
            this.barrierName = barrierName;
        }
    }

    public ObjectName getBarrierObjectName() {
        return this.barrierName;
    }

    public void setBarrierCreatedOnStartup(Boolean createOnStartup) {
        if (this.createOnStartup == null) {
            this.createOnStartup = createOnStartup;
        }
    }

    public Boolean getBarrierCreatedOnStartup() {
        if (this.createOnStartup == null) {
            this.createOnStartup = Boolean.TRUE;
        }
        return this.createOnStartup;
    }

    public void setBarrierEnabledOnStartup(Boolean enableOnStartup) {
        if (this.enableOnStartup == null) {
            this.enableOnStartup = enableOnStartup;
        }
    }

    public Boolean getBarrierEnabledOnStartup() {
        if (this.enableOnStartup == null) {
            this.enableOnStartup = this.enableOnStartup();
        }
        return this.enableOnStartup;
    }

    public void setCreateBarrierHandback(String createHandback) {
        if (this.createHandback == null) {
            this.createHandback = createHandback;
        }
    }

    public String getCreateBarrierHandback() {
        return this.createHandback;
    }

    public void setStartBarrierHandback(String startHandback) {
        if (this.startHandback == null) {
            this.startHandback = startHandback;
        }
    }

    public String getStartBarrierHandback() {
        return this.startHandback;
    }

    public void setStopBarrierHandback(String stopHandback) {
        if (this.stopHandback == null) {
            this.stopHandback = stopHandback;
        }
    }

    public String getStopBarrierHandback() {
        return this.stopHandback;
    }

    public void setDestroyBarrierHandback(String destroyHandback) {
        if (this.destroyHandback == null) {
            this.destroyHandback = destroyHandback;
        }
    }

    public String getDestroyBarrierHandback() {
        return this.destroyHandback;
    }

    public void setDynamicSubscriptions(Boolean dynamicSubscriptions) {
        if (this.dynamicSubscriptions == null) {
            this.dynamicSubscriptions = dynamicSubscriptions;
        }
    }

    public Boolean getDynamicSubscriptions() {
        if (this.dynamicSubscriptions == null) {
            this.dynamicSubscriptions = Boolean.TRUE;
        }
        return this.dynamicSubscriptions;
    }

    protected Boolean enableOnStartup() {
        return Boolean.FALSE;
    }

    protected void createService() throws Exception {
        this.barrier = new Barrier(this.getServiceName());
        this.getServer().registerMBean(this.barrier, this.barrierName);
        if (this.getBarrierCreatedOnStartup().booleanValue()) {
            this.barrier.create();
        }
        if (this.getBarrierEnabledOnStartup().booleanValue()) {
            this.startBarrier();
        }
        this.subscribe(this.getDynamicSubscriptions());
    }

    protected void destroyService() {
        this.unsubscribe();
        this.destroyBarrier();
        try {
            this.getServer().unregisterMBean(this.barrierName);
        }
        catch (Throwable e) {
            this.log.debug((Object)"Unexpected error during Barrier unregister", e);
        }
        this.barrier = null;
    }

    public void handleNotification2(Notification n, Object handback) {
        this.log.debug((Object)("Got notification: " + n));
        if (this.createHandback != null && this.createHandback.equals(handback)) {
            this.log.debug((Object)("Saw '" + handback + "' handback, creating barrier"));
            this.createBarrier();
        } else if (this.startHandback != null && this.startHandback.equals(handback)) {
            this.log.debug((Object)("Saw '" + handback + "' handback, starting barrier"));
            this.startBarrier();
        } else if (this.stopHandback != null && this.stopHandback.equals(handback)) {
            this.log.debug((Object)("Saw '" + handback + "' handback, stopping barrier"));
            this.stopBarrier();
        } else if (this.destroyHandback != null && this.destroyHandback.equals(handback)) {
            this.log.debug((Object)("Saw '" + handback + "' handback, destroying barrier"));
            this.destroyBarrier();
        }
    }

    public void createBarrier() {
        try {
            this.barrier.create();
        }
        catch (Throwable e) {
            this.log.warn((Object)("Failed to create barrier: " + this.barrierName), e);
        }
    }

    public void startBarrier() {
        try {
            this.barrier.start();
        }
        catch (Throwable e) {
            this.log.warn((Object)("Failed to start barrier: " + this.barrierName), e);
        }
    }

    public void stopBarrier() {
        try {
            this.barrier.stop();
        }
        catch (Throwable e) {
            this.log.warn((Object)("Failed to stop barrier: " + this.barrierName), e);
        }
    }

    public void destroyBarrier() {
        try {
            this.barrier.destroy();
        }
        catch (Throwable e) {
            this.log.warn((Object)("Failed to destroy barrier: " + this.barrierName), e);
        }
    }

    public static class Barrier
    extends ServiceMBeanSupport
    implements BarrierMBean {
        private ObjectName barrierController;

        public Barrier(ObjectName barrierController) {
            this.barrierController = barrierController;
        }

        public ObjectName getBarrierController() {
            return this.barrierController;
        }
    }

    public static interface BarrierMBean {
        public ObjectName getBarrierController();

        public String getStateString();

        public int getState();

        public void jbossInternalLifecycle(String var1) throws Exception;
    }
}

