/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */

package org.jboss.test.visitor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * A visitor driver that traverses the class hierarchy, and for each
 * class in the hierarchy, the interfaces, declared methods and fields.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 43811 $
 */
public class TypeHierarchyTraversal
{
   /**
    * 
    * @param rootClass
    * @param visitor
    */
   public static void visit(Class rootClass, TypeVisitor visitor)
   {
      Class clazz = rootClass;
      while( clazz != null )
      {
         processType(clazz, visitor);
         clazz = clazz.getSuperclass();
      }
   }
   static void processType(Class clazz, TypeVisitor visitor)
   {
      visitor.visitClass(clazz);
      Class[] ifaces = clazz.getInterfaces();
      visitor.visitInterfaces(ifaces);
      Method[] methods = clazz.getDeclaredMethods();
      visitor.visitMethods(methods);
      Field[] fields = clazz.getDeclaredFields();
      visitor.visitFields(fields);
   }
}
