/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
extends TestCase {
    long startTime;

    public AbstractTestCase(String name) {
        super(name);
    }

    public abstract Logger getLog();

    public URL getResource(String name) {
        return AbstractTestCase.findResource(((Object)((Object)this)).getClass(), name);
    }

    public static URL findResource(final Class clazz, final String name) {
        PrivilegedAction<URL> action = new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return clazz.getResource(name);
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected void setUp() throws Exception {
        this.log("Starting");
        this.startTime = System.currentTimeMillis();
    }

    protected void tearDown() throws Exception {
        this.getLog().debug((Object)(this.getName() + " took " + (System.currentTimeMillis() - this.startTime) + "ms"));
        this.log("Stopping");
    }

    protected void configureLogging() {
    }

    protected abstract void enableTrace(String var1);

    protected void assertEquals(float one, float two) {
        AbstractTestCase.assertEquals((float)one, (float)two, (float)0.0f);
    }

    protected void assertEquals(double one, double two) {
        AbstractTestCase.assertEquals((double)one, (double)two, (double)0.0);
    }

    protected void assertEquals(Object[] expected, Object[] actual) {
        if (!Arrays.equals(expected, actual)) {
            throw new AssertionFailedError("expected: " + Arrays.asList(expected) + " actual: " + Arrays.asList(actual));
        }
    }

    protected void assertEquals(String context, Object[] expected, Object[] actual) {
        if (!Arrays.equals(expected, actual)) {
            throw new AssertionFailedError(context + " expected: " + Arrays.asList(expected) + " actual: " + Arrays.asList(actual));
        }
    }

    protected void assertEmpty(Collection c) {
        AbstractTestCase.assertNotNull((Object)c);
        if (!c.isEmpty()) {
            throw new AssertionFailedError("Expected empty collection " + c);
        }
    }

    protected void assertEmpty(String context, Collection c) {
        AbstractTestCase.assertNotNull((Object)c);
        if (!c.isEmpty()) {
            throw new AssertionFailedError(context);
        }
    }

    protected void checkThrowable(Class expected, Throwable throwable) {
        if (expected == null) {
            AbstractTestCase.fail((String)"Must provide an expected class");
        }
        if (throwable == null) {
            AbstractTestCase.fail((String)"Must provide a throwable for comparison");
        }
        if (throwable instanceof AssertionFailedError || throwable instanceof AssertionError) {
            throw (Error)throwable;
        }
        if (!expected.equals(throwable.getClass())) {
            this.getLog().error((Object)"Unexpected throwable", throwable);
            AbstractTestCase.fail((String)("Unexpected throwable: " + throwable));
        } else {
            this.getLog().debug((Object)("Got expected " + expected.getName() + "(" + throwable + ")"));
        }
    }

    protected byte[] serialize(Serializable object) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        return baos.toByteArray();
    }

    protected Object deserialize(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    protected <T> T assertInstanceOf(Object o, Class<T> expectedType) {
        return this.assertInstanceOf(o, expectedType, true);
    }

    protected <T> T assertInstanceOf(Object o, Class<T> expectedType, boolean allowNull) {
        if (expectedType == null) {
            AbstractTestCase.fail((String)"Null expectedType");
        }
        if (o == null && allowNull) {
            return null;
        }
        try {
            return expectedType.cast(o);
        }
        catch (ClassCastException e) {
            AbstractTestCase.fail((String)("Object " + o + " of class " + o.getClass().getName() + " is not an instanceof " + expectedType.getName()));
            return null;
        }
    }

    private void log(String context) {
        this.getLog().debug((Object)("==== " + context + " " + this.getName() + " ===="));
    }
}

