/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.security;

import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;

public abstract class PolicyPlugin
extends Policy {
    private static PermissionCollection none;
    private static PermissionCollection fileRead;
    private static PermissionCollection all;

    public static PolicyPlugin getInstance(Class clazz) throws Exception {
        String policyClassName = System.getProperty("org.jboss.test.security.PolicyPlugin", "org.jboss.test.security.TestsPolicyPlugin");
        Class<?> policyClass = Thread.currentThread().getContextClassLoader().loadClass(policyClassName);
        Class[] sig = new Class[]{Class.class};
        Constructor<?> ctor = policyClass.getConstructor(sig);
        Object[] args = new Object[]{clazz};
        return (PolicyPlugin)ctor.newInstance(args);
    }

    public void refresh() {
    }

    protected PermissionCollection noPermissions() {
        if (none == null) {
            none = new Permissions();
        }
        return none;
    }

    protected PermissionCollection fileReadPermissions() {
        if (fileRead == null) {
            fileRead = new Permissions();
            fileRead.add(new FilePermission("<<ALL FILES>>", "read"));
        }
        return fileRead;
    }

    protected PermissionCollection allPermissions() {
        if (all == null) {
            all = new Permissions();
            all.add(new AllPermission());
        }
        return all;
    }
}

