/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TxUtils;

public class TransactionTimeout {
    protected final TransactionManager transactionManager;
    private static TransactionTimeout instance = null;

    private TransactionTimeout() {
        try {
            InitialContext context = new InitialContext();
            this.transactionManager = (TransactionManager)context.lookup("java:/TransactionManager");
        }
        catch (NamingException e) {
            throw new IllegalStateException("An error occured while looking up the transaction manager: " + e);
        }
    }

    public long getTimeLeftInTx() throws TransactionTimeoutException {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (TxUtils.isCompleted(tx)) {
                return -1L;
            }
            if (!(tx instanceof TransactionImpl)) {
                return -1L;
            }
            TransactionImpl txImpl = (TransactionImpl)tx;
            return txImpl.getTimeLeftBeforeTimeout();
        }
        catch (Exception ignored) {
            return -1L;
        }
    }

    public static long getTimeLeftInTransaction() throws TransactionTimeoutException {
        if (instance == null) {
            instance = new TransactionTimeout();
        }
        return instance.getTimeLeftInTx();
    }

    public static class TransactionTimeoutException
    extends Exception {
    }
}

