/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedJarFromStream
extends AbstractVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private ZipInputStream zis;
    private HashMap<String, JarEntryContents> entries = new HashMap();
    private URL jarURL;
    private URL entryURL;
    private String vfsPath;
    private String name;
    private long lastModified;
    private long size;
    private boolean inited;

    public NestedJarFromStream(VFSContext context, VirtualFileHandler parent, ZipInputStream zis, URL jarURL, ZipEntry entry) {
        super(context, parent, entry.getName());
        this.jarURL = jarURL;
        this.name = entry.getName();
        this.lastModified = entry.getTime();
        this.size = entry.getSize();
        this.zis = zis;
        try {
            if (parent != null) {
                String vfsParentUrl = parent.toVfsUrl().toString();
                this.vfsUrl = vfsParentUrl.endsWith("/") ? new URL(String.valueOf(vfsParentUrl) + this.name) : new URL(String.valueOf(vfsParentUrl) + "/" + this.name);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        if (!this.inited) {
            this.init();
        }
        return this.entries.get(this.name);
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        if (!this.inited) {
            this.init();
        }
        ArrayList<VirtualFileHandler> children = new ArrayList<VirtualFileHandler>();
        children.addAll(this.entries.values());
        return children;
    }

    @Override
    public boolean isLeaf() throws IOException {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.lastModified;
    }

    public Iterator<JarEntryContents> getEntries() throws IOException {
        if (!this.inited) {
            this.init();
        }
        return this.entries.values().iterator();
    }

    public JarEntryContents getEntry(String name) throws IOException {
        if (!this.inited) {
            this.init();
        }
        return this.entries.get(name);
    }

    public ZipEntry getJarEntry(String name) throws IOException {
        JarEntryContents jec;
        if (!this.inited) {
            this.init();
        }
        return (jec = this.entries.get(name)) != null ? jec.getEntry() : null;
    }

    public byte[] getContents(String name) throws IOException {
        JarEntryContents jec;
        if (!this.inited) {
            this.init();
        }
        return (jec = this.entries.get(name)) != null ? jec.getContents() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPathName() {
        return this.vfsPath;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.zis;
    }

    @Override
    public void close() {
        this.entries.clear();
        if (this.zis != null) {
            try {
                this.zis.close();
            }
            catch (IOException e) {
                this.log.error((Object)"close error", (Throwable)e);
            }
            this.zis = null;
        }
    }

    @Override
    public URI toURI() throws URISyntaxException {
        try {
            if (this.entryURL == null) {
                this.entryURL = new URL(this.jarURL, this.getName());
            }
        }
        catch (MalformedURLException e) {
            throw new URISyntaxException("Failed to create relative jarURL", e.getMessage());
        }
        return this.entryURL.toURI();
    }

    @Override
    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('[');
        tmp.append("name=");
        tmp.append(this.getName());
        tmp.append(",size=");
        tmp.append(this.getSize());
        tmp.append(",lastModified=");
        tmp.append(this.lastModified);
        tmp.append(",URI=");
        try {
            tmp.append(this.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        tmp.append(']');
        return tmp.toString();
    }

    protected void init() throws IOException {
        this.inited = true;
        ZipEntry entry = this.zis.getNextEntry();
        while (entry != null) {
            try {
                String url = String.valueOf(this.toURI().toASCIIString()) + "!/" + entry.getName();
                URL jecURL = new URL(url);
                JarEntryContents jec = new JarEntryContents(this.getVFSContext(), this, entry, jecURL, this.zis, this.getPathName());
                this.entries.put(entry.getName(), jec);
                entry = this.zis.getNextEntry();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        this.zis.close();
        this.zis = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JarEntryContents
    extends AbstractVirtualFileHandler {
        private static final long serialVersionUID = 1L;
        private ZipEntry entry;
        private URL entryURL;
        private String vfsPath;
        private byte[] contents;
        private boolean isJar;
        private NestedJarFromStream njar;
        private InputStream openStream;

        JarEntryContents(VFSContext context, VirtualFileHandler parent, ZipEntry entry, URL entryURL, InputStream zis, String parentVfsPath) throws IOException {
            super(context, parent, entry.getName());
            this.entry = entry;
            this.entryURL = entryURL;
            this.vfsPath = String.valueOf(parentVfsPath) + "/" + entry.getName();
            this.isJar = JarUtils.isArchive(entry.getName());
            int size = (int)entry.getSize();
            if (size <= 0) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
            byte[] tmp = new byte[1024];
            while (zis.available() > 0) {
                int length = zis.read(tmp);
                if (length <= 0) continue;
                baos.write(tmp, 0, length);
            }
            this.contents = baos.toByteArray();
        }

        @Override
        public boolean isHidden() throws IOException {
            return false;
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public byte[] getContents() {
            return this.contents;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public String getPathName() {
            return this.vfsPath;
        }

        @Override
        public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
            List<VirtualFileHandler> children = null;
            if (this.isJar) {
                this.initNestedJar();
                children = this.njar.getChildren(ignoreErrors);
            }
            return children;
        }

        @Override
        public VirtualFileHandler findChild(String path) throws IOException {
            if (!this.isJar) {
                throw new FileNotFoundException("JarEntryContents(" + this.entry.getName() + ") has no children");
            }
            this.initNestedJar();
            VirtualFileHandler child = this.njar.findChild(path);
            return child;
        }

        @Override
        public long getLastModified() {
            return this.entry.getTime();
        }

        @Override
        public long getSize() {
            return this.entry.getSize();
        }

        @Override
        public boolean isLeaf() {
            if (this.isJar) {
                return false;
            }
            return !this.entry.isDirectory();
        }

        @Override
        public synchronized InputStream openStream() throws IOException {
            this.initNestedJar();
            this.openStream = this.njar != null ? this.njar.openStream() : new ByteArrayInputStream(this.contents);
            return this.openStream;
        }

        @Override
        public synchronized void close() {
            if (this.openStream != null) {
                try {
                    this.openStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"close error", (Throwable)e);
                }
                this.openStream = null;
            }
        }

        @Override
        public URI toURI() throws URISyntaxException {
            return this.entryURL.toURI();
        }

        @Override
        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('[');
            tmp.append("name=");
            tmp.append(this.entry.getName());
            tmp.append(",size=");
            tmp.append(this.entry.getSize());
            tmp.append(",time=");
            tmp.append(this.entry.getTime());
            tmp.append(",URI=");
            try {
                tmp.append(this.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            tmp.append(']');
            return tmp.toString();
        }

        private synchronized void initNestedJar() throws IOException {
            if (this.isJar && this.njar == null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.contents);
                ZipInputStream zis = new ZipInputStream(bais);
                this.njar = new NestedJarFromStream(this.getVFSContext(), this, zis, this.entryURL, this.entry);
            }
        }
    }
}

