/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators;

import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.bridge.PolicySetFinderModule;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.locators.AbstractJBossPolicyLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPolicySetLocator
extends AbstractJBossPolicyLocator {
    private XACMLPolicy thePolicySet;
    private List<PolicySetFinderModule> pfml = new ArrayList<PolicySetFinderModule>();

    public JBossPolicySetLocator() {
    }

    public JBossPolicySetLocator(Set<XACMLPolicy> policies) {
        this.setPolicies(policies);
    }

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
        for (XACMLPolicy xp : policies) {
            if (xp.getType() != 0) continue;
            this.pfml.add(this.getPopulatedPolicySetFinderModule(xp));
        }
        this.map.put("policy_finder_module", this.pfml);
    }

    private PolicySetFinderModule getPopulatedPolicySetFinderModule(XACMLPolicy xpolicy) {
        PolicySetFinderModule psfm = new PolicySetFinderModule();
        List<XACMLPolicy> policyList = xpolicy.getEnclosingPolicies();
        ArrayList<Policy> sunxacmlPolicies = new ArrayList<Policy>();
        for (XACMLPolicy xp : policyList) {
            sunxacmlPolicies.add((Policy)xp.get("underlying_policy"));
        }
        psfm.set((PolicySet)xpolicy.get("underlying_policy"), sunxacmlPolicies);
        xpolicy.set("policy_finder_module", psfm);
        return psfm;
    }
}

