/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.cfg.annotations.Version;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XAnnotatedElement;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XMember;
import org.hibernate.reflection.XProperty;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Keyword;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.Text;
import org.hibernate.search.annotations.Unstored;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.BinderHelper;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilder<T> {
    private final List<XMember> keywordGetters = new ArrayList<XMember>();
    private final List<String> keywordNames = new ArrayList<String>();
    private final List<FieldBridge> keywordBridges = new ArrayList<FieldBridge>();
    private final List<XMember> unstoredGetters = new ArrayList<XMember>();
    private final List<String> unstoredNames = new ArrayList<String>();
    private final List<FieldBridge> unstoredBridges = new ArrayList<FieldBridge>();
    private final List<XMember> textGetters = new ArrayList<XMember>();
    private final List<String> textNames = new ArrayList<String>();
    private final List<FieldBridge> textBridges = new ArrayList<FieldBridge>();
    private final List<String> fieldNames = new ArrayList<String>();
    private final List<XMember> fieldGetters = new ArrayList<XMember>();
    private final List<FieldBridge> fieldBridges = new ArrayList<FieldBridge>();
    private final List<Field.Store> fieldStore = new ArrayList<Field.Store>();
    private final List<Field.Index> fieldIndex = new ArrayList<Field.Index>();
    private final XClass beanClass;
    private final DirectoryProvider directoryProvider;
    private String idKeywordName;
    private final Analyzer analyzer;
    private Float idBoost;
    public static final String CLASS_FIELDNAME = "_hibernate_class";
    private TwoWayFieldBridge idBridge;
    private Set<Class> mappedSubclasses = new HashSet<Class>();
    private ReflectionManager reflectionManager;

    public DocumentBuilder(XClass clazz, Analyzer analyzer, DirectoryProvider directory, ReflectionManager reflectionManager) {
        this.beanClass = clazz;
        this.analyzer = analyzer;
        this.directoryProvider = directory;
        this.reflectionManager = reflectionManager;
        if (clazz == null) {
            throw new AssertionFailure("Unable to build a DocumentBuilder with a null class");
        }
        for (XClass currClass = this.beanClass; currClass != null; currClass = currClass.getSuperclass()) {
            List<XProperty> methods = currClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMember(method);
            }
            List<XProperty> fields = currClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMember(field);
            }
        }
        if (this.idKeywordName == null) {
            throw new HibernateException("No document id for: " + clazz.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeMember(XProperty member) {
        Field fieldAnn;
        DocumentId documentIdAnn;
        Text textAnn;
        Unstored unstoredAnn;
        Keyword keywordAnn = member.getAnnotation(Keyword.class);
        if (keywordAnn != null) {
            String name = BinderHelper.getAttributeName(member, keywordAnn.name());
            if (keywordAnn.id()) {
                this.idKeywordName = name;
                this.idBoost = this.getBoost(member);
                FieldBridge fieldBridge = BridgeFactory.guessType(member);
                if (!(fieldBridge instanceof TwoWayFieldBridge)) throw new HibernateException("Bridge for document id does not implement IdFieldBridge: " + member.getName());
                this.idBridge = (TwoWayFieldBridge)fieldBridge;
            } else {
                DocumentBuilder.setAccessible(member);
                this.keywordGetters.add(member);
                this.keywordNames.add(name);
                this.keywordBridges.add(BridgeFactory.guessType(member));
            }
        }
        if ((unstoredAnn = member.getAnnotation(Unstored.class)) != null) {
            DocumentBuilder.setAccessible(member);
            this.unstoredGetters.add(member);
            this.unstoredNames.add(BinderHelper.getAttributeName(member, unstoredAnn.name()));
            this.unstoredBridges.add(BridgeFactory.guessType(member));
        }
        if ((textAnn = member.getAnnotation(Text.class)) != null) {
            DocumentBuilder.setAccessible(member);
            this.textGetters.add(member);
            this.textNames.add(BinderHelper.getAttributeName(member, textAnn.name()));
            this.textBridges.add(BridgeFactory.guessType(member));
        }
        if ((documentIdAnn = member.getAnnotation(DocumentId.class)) != null) {
            if (this.idKeywordName != null) {
                throw new AssertionFailure("Two document id assigned: " + this.idKeywordName + " and " + BinderHelper.getAttributeName(member, documentIdAnn.name()));
            }
            this.idKeywordName = BinderHelper.getAttributeName(member, documentIdAnn.name());
            FieldBridge fieldBridge = BridgeFactory.guessType(member);
            if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                throw new HibernateException("Bridge for document id does not implement IdFieldBridge: " + member.getName());
            }
            this.idBridge = (TwoWayFieldBridge)fieldBridge;
            this.idBoost = this.getBoost(member);
        }
        if ((fieldAnn = member.getAnnotation(Field.class)) == null) return;
        DocumentBuilder.setAccessible(member);
        this.fieldGetters.add(member);
        this.fieldNames.add(BinderHelper.getAttributeName(member, fieldAnn.name()));
        this.fieldStore.add(this.getStore(fieldAnn.store()));
        this.fieldIndex.add(this.getIndex(fieldAnn.index()));
        this.fieldBridges.add(BridgeFactory.guessType(member));
    }

    private Field.Store getStore(Store store) {
        switch (store) {
            case NO: {
                return Field.Store.NO;
            }
            case YES: {
                return Field.Store.YES;
            }
            case COMPRESS: {
                return Field.Store.COMPRESS;
            }
        }
        throw new AssertionFailure("Unexpected Store: " + (Object)((Object)store));
    }

    private Field.Index getIndex(Index index) {
        switch (index) {
            case NO: {
                return Field.Index.NO;
            }
            case NO_NORMS: {
                return Field.Index.NO_NORMS;
            }
            case TOKENIZED: {
                return Field.Index.TOKENIZED;
            }
            case UN_TOKENISED: {
                return Field.Index.UN_TOKENIZED;
            }
        }
        throw new AssertionFailure("Unexpected Index: " + (Object)((Object)index));
    }

    private Float getBoost(XAnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Boost boost = element.getAnnotation(Boost.class);
        return boost != null ? Float.valueOf(boost.value()) : null;
    }

    private Object getMemberValue(T bean, XMember getter) {
        Object value;
        try {
            value = getter.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }

    public Document getDocument(T instance, Serializable id) {
        Object value;
        XMember member;
        int i;
        Document doc = new Document();
        XClass instanceClass = this.reflectionManager.toXClass(instance.getClass());
        Float boost = this.getBoost(instanceClass);
        if (boost != null) {
            doc.setBoost(boost.floatValue());
        }
        org.apache.lucene.document.Field classField = new org.apache.lucene.document.Field(CLASS_FIELDNAME, instanceClass.getName(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(classField);
        this.idBridge.set(this.idKeywordName, id, doc, Field.Store.YES, Field.Index.UN_TOKENIZED, this.idBoost);
        for (i = 0; i < this.keywordNames.size(); ++i) {
            member = this.keywordGetters.get(i);
            value = this.getMemberValue(instance, member);
            this.keywordBridges.get(i).set(this.keywordNames.get(i), value, doc, Field.Store.YES, Field.Index.UN_TOKENIZED, this.getBoost(member));
        }
        for (i = 0; i < this.textNames.size(); ++i) {
            member = this.textGetters.get(i);
            value = this.getMemberValue(instance, member);
            this.textBridges.get(i).set(this.textNames.get(i), value, doc, Field.Store.YES, Field.Index.TOKENIZED, this.getBoost(member));
        }
        for (i = 0; i < this.unstoredNames.size(); ++i) {
            member = this.unstoredGetters.get(i);
            value = this.getMemberValue(instance, member);
            this.unstoredBridges.get(i).set(this.unstoredNames.get(i), value, doc, Field.Store.NO, Field.Index.TOKENIZED, this.getBoost(member));
        }
        for (i = 0; i < this.fieldNames.size(); ++i) {
            member = this.fieldGetters.get(i);
            value = this.getMemberValue(instance, member);
            this.fieldBridges.get(i).set(this.fieldNames.get(i), value, doc, this.fieldStore.get(i), this.fieldIndex.get(i), this.getBoost(member));
        }
        return doc;
    }

    public Term getTerm(Serializable id) {
        return new Term(this.idKeywordName, this.idBridge.objectToString(id));
    }

    public DirectoryProvider getDirectoryProvider() {
        return this.directoryProvider;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private static void setAccessible(XMember member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            member.setAccessible(true);
        }
    }

    public TwoWayFieldBridge getIdBridge() {
        return this.idBridge;
    }

    public String getIdKeywordName() {
        return this.idKeywordName;
    }

    public static Class getDocumentClass(Document document) {
        String className = document.get(CLASS_FIELDNAME);
        try {
            return ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Unable to load indexed class: " + className, e);
        }
    }

    public static Serializable getDocumentId(FullTextIndexEventListener listener, Class clazz, Document document) {
        DocumentBuilder<Object> builder = listener.getDocumentBuilders().get(clazz);
        if (builder == null) {
            throw new HibernateException("No Lucene configuration set up for: " + clazz.getName());
        }
        return (Serializable)builder.getIdBridge().get(builder.getIdKeywordName(), document);
    }

    public void postInitialize(Set<Class> indexedClasses) {
        Class plainClass = this.reflectionManager.toClass(this.beanClass);
        HashSet<Class> tempMappedSubclasses = new HashSet<Class>();
        for (Class currentClass : indexedClasses) {
            if (!plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
    }

    public Set<Class> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    static {
        Version.touch();
    }
}

