/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class ExceptionHandler {
    private ExceptionHandler() {
    }

    public static JMException handleException(Throwable t) {
        ExceptionHandler.handleRuntimeExceptionOrError(t);
        Exception e = (Exception)t;
        if (e instanceof OperationsException) {
            return (OperationsException)e;
        }
        if (e instanceof ReflectionException) {
            return (ReflectionException)e;
        }
        if (e instanceof MBeanRegistrationException) {
            return (MBeanRegistrationException)e;
        }
        if (e instanceof ClassNotFoundException) {
            return new ReflectionException(e);
        }
        if (e instanceof IllegalAccessException) {
            return new ReflectionException(e);
        }
        if (e instanceof InstantiationException) {
            return new ReflectionException(e);
        }
        if (e instanceof NoSuchMethodException) {
            return new ReflectionException(e);
        }
        if (e instanceof MBeanException) {
            Throwable cause = e.getCause();
            if (cause instanceof JMException) {
                return (JMException)cause;
            }
            return (MBeanException)e;
        }
        return new MBeanException(e);
    }

    private static void handleRuntimeExceptionOrError(Throwable e) {
        if (e instanceof RuntimeOperationsException) {
            throw (RuntimeOperationsException)e;
        }
        if (e instanceof RuntimeErrorException) {
            throw (RuntimeErrorException)e;
        }
        if (e instanceof RuntimeMBeanException) {
            throw (RuntimeMBeanException)e;
        }
        if (e instanceof IllegalArgumentException) {
            throw new RuntimeOperationsException((IllegalArgumentException)e);
        }
        if (e instanceof IndexOutOfBoundsException) {
            throw new RuntimeOperationsException((IndexOutOfBoundsException)e);
        }
        if (e instanceof NullPointerException) {
            throw new RuntimeOperationsException((NullPointerException)e);
        }
        if (e instanceof Error) {
            throw new RuntimeErrorException((Error)e);
        }
        if (e instanceof RuntimeException) {
            throw new RuntimeMBeanException((RuntimeException)e);
        }
    }
}

