/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.ClusterMergeStatus;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.AsynchEventHandler;
import org.jboss.ha.framework.server.DistributedReplicantManagerImplMBean;
import org.jboss.logging.Logger;

public class DistributedReplicantManagerImpl
implements DistributedReplicantManagerImplMBean,
HAPartition.HAMembershipExtendedListener,
HAPartition.HAPartitionStateTransfer,
AsynchEventHandler.AsynchEventProcessor {
    protected static final String SERVICE_NAME = "DistributedReplicantManager";
    protected static int threadID;
    protected ConcurrentReaderHashMap localReplicants = new ConcurrentReaderHashMap();
    protected ConcurrentReaderHashMap replicants = new ConcurrentReaderHashMap();
    protected ConcurrentReaderHashMap keyListeners = new ConcurrentReaderHashMap();
    protected HashMap intraviewIdCache = new HashMap();
    protected HAPartition partition;
    protected AsynchEventHandler asynchHandler;
    protected Logger log;
    protected MBeanServer mbeanserver;
    protected ObjectName jmxName;
    protected String nodeName = null;
    protected Latch partitionNameKnown = new Latch();
    protected boolean trace;
    protected Class[] add_types = new Class[]{String.class, String.class, Serializable.class};
    protected Class[] remove_types = new Class[]{String.class, String.class};

    public DistributedReplicantManagerImpl(HAPartition partition, MBeanServer server) {
        this.partition = partition;
        this.mbeanserver = server;
        this.log = Logger.getLogger((String)(DistributedReplicantManagerImpl.class.getName() + "." + partition.getPartitionName()));
        this.trace = this.log.isTraceEnabled();
    }

    public void init() throws Exception {
        this.log.debug((Object)"registerRPCHandler");
        this.partition.registerRPCHandler(SERVICE_NAME, this);
        this.log.debug((Object)"subscribeToStateTransferEvents");
        this.partition.subscribeToStateTransferEvents(SERVICE_NAME, this);
        this.log.debug((Object)"registerMembershipListener");
        this.partition.registerMembershipListener(this);
        String name = "jboss:service=DistributedReplicantManager,partitionName=" + this.partition.getPartitionName();
        this.jmxName = new ObjectName(name);
        this.mbeanserver.registerMBean(this, this.jmxName);
    }

    public void start() throws Exception {
        this.nodeName = this.partition.getNodeName();
        this.asynchHandler = new AsynchEventHandler(this, "AsynchKeyChangeHandler");
        this.asynchHandler.start();
        this.partitionNameKnown.release();
    }

    public void stop() throws Exception {
        try {
            this.asynchHandler.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to stop asynchHandler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (this.localReplicants != null) {
            ConcurrentReaderHashMap concurrentReaderHashMap = this.localReplicants;
            synchronized (concurrentReaderHashMap) {
                String[] keys = new String[this.localReplicants.size()];
                this.localReplicants.keySet().toArray(keys);
                for (int n = 0; n < keys.length; ++n) {
                    this.removeLocal(keys[n]);
                }
            }
        }
        this.mbeanserver.unregisterMBean(this.jmxName);
        this.partition.unregisterRPCHandler(SERVICE_NAME, this);
        this.partition.unsubscribeFromStateTransferEvents(SERVICE_NAME, this);
        this.partition.unregisterMembershipListener(this);
    }

    public String listContent() throws Exception {
        Collection services = this.getAllServices();
        StringBuffer result = new StringBuffer();
        Iterator catsIter = services.iterator();
        result.append("<pre>");
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            HashMap content = (HashMap)this.replicants.get((Object)category);
            if (content == null) {
                content = new HashMap();
            }
            Iterator keysIter = content.keySet().iterator();
            result.append("-----------------------------------------------\n");
            result.append("Service : ").append(category).append("\n\n");
            Serializable local = this.lookupLocalReplicant(category);
            if (local == null) {
                result.append("\t- Service is *not* available locally\n");
            } else {
                result.append("\t- Service *is* also available locally\n");
            }
            while (keysIter.hasNext()) {
                String location = (String)keysIter.next();
                result.append("\t- ").append(location).append("\n");
            }
            result.append("\n");
        }
        result.append("</pre>");
        return result.toString();
    }

    public String listXmlContent() throws Exception {
        Collection services = this.getAllServices();
        StringBuffer result = new StringBuffer();
        result.append("<ReplicantManager>\n");
        for (String category : services) {
            HashMap content = (HashMap)this.replicants.get((Object)category);
            if (content == null) {
                content = new HashMap();
            }
            Iterator keysIter = content.keySet().iterator();
            result.append("\t<Service>\n");
            result.append("\t\t<ServiceName>").append(category).append("</ServiceName>\n");
            Serializable local = this.lookupLocalReplicant(category);
            if (local != null) {
                result.append("\t\t<Location>\n");
                result.append("\t\t\t<Name local=\"True\">").append(this.nodeName).append("</Name>\n");
                result.append("\t\t</Location>\n");
            }
            while (keysIter.hasNext()) {
                String location = (String)keysIter.next();
                result.append("\t\t<Location>\n");
                result.append("\t\t\t<Name local=\"False\">").append(location).append("</Name>\n");
                result.append("\t\t</Location>\n");
            }
            result.append("\t<Service>\n");
        }
        result.append("<ReplicantManager>\n");
        return result.toString();
    }

    public Serializable getCurrentState() {
        Collection services = this.getAllServices();
        HashMap<String, HashMap> result = new HashMap<String, HashMap>();
        for (String category : services) {
            HashMap content = (HashMap)this.replicants.get((Object)category);
            content = content == null ? new HashMap() : (HashMap)content.clone();
            Serializable local = this.lookupLocalReplicant(category);
            if (local != null) {
                content.put(this.nodeName, local);
            }
            result.put(category, content);
        }
        Object[] globalResult = new Object[]{result, this.intraviewIdCache};
        return globalResult;
    }

    public void setCurrentState(Serializable newState) {
        Object[] globalState = (Object[])newState;
        HashMap map = (HashMap)globalState[0];
        this.replicants.putAll((Map)map);
        this.intraviewIdCache = (HashMap)globalState[1];
        if (this.trace) {
            this.log.trace((Object)(this.nodeName + ": received new state, will republish local replicants"));
        }
        MembersPublisher publisher = new MembersPublisher();
        publisher.start();
    }

    public Collection getAllServices() {
        HashSet services = new HashSet();
        services.addAll(this.localReplicants.keySet());
        services.addAll(this.replicants.keySet());
        return services;
    }

    public void membershipChangedDuringMerge(Vector deadMembers, Vector newMembers, Vector allMembers, Vector originatingGroups) {
        this.log.info((Object)"Merging partitions...");
        this.log.info((Object)("Dead members: " + deadMembers.size()));
        this.log.info((Object)("Originating groups: " + originatingGroups));
        this.purgeDeadMembers(deadMembers);
        if (newMembers.size() > 0) {
            new MergeMembers().start();
        }
    }

    public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        this.log.info((Object)("I am (" + this.nodeName + ") received membershipChanged event:"));
        this.log.info((Object)("Dead members: " + deadMembers.size() + " (" + deadMembers + ")"));
        this.log.info((Object)("New Members : " + newMembers.size() + " (" + newMembers + ")"));
        this.log.info((Object)("All Members : " + allMembers.size() + " (" + allMembers + ")"));
        this.purgeDeadMembers(deadMembers);
    }

    public void processEvent(Object event) {
        KeyChangeEvent kce = (KeyChangeEvent)event;
        this.notifyKeyListeners(kce.key, kce.replicants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, Serializable replicant) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("add, key=" + key + ", value=" + replicant));
        }
        this.partitionNameKnown.acquire();
        Object[] args = new Object[]{key, this.nodeName, replicant};
        this.partition.callMethodOnCluster(SERVICE_NAME, "_add", args, this.add_types, true);
        ConcurrentReaderHashMap concurrentReaderHashMap = this.localReplicants;
        synchronized (concurrentReaderHashMap) {
            this.localReplicants.put((Object)key, (Object)replicant);
            this.notifyKeyListeners(key, this.lookupReplicants(key));
        }
    }

    public void remove(String key) throws Exception {
        this.partitionNameKnown.acquire();
        if (this.localReplicants.containsKey((Object)key)) {
            Object[] args = new Object[]{key, this.nodeName};
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_remove", args, this.remove_types, true);
            this.removeLocal(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLocal(String key) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.localReplicants;
        synchronized (concurrentReaderHashMap) {
            this.localReplicants.remove((Object)key);
            ArrayList result = this.lookupReplicants(key);
            if (result == null) {
                result = new ArrayList();
            }
            this.notifyKeyListeners(key, result);
        }
    }

    public Serializable lookupLocalReplicant(String key) {
        return (Serializable)this.localReplicants.get((Object)key);
    }

    public List lookupReplicants(String key) {
        Serializable local = this.lookupLocalReplicant(key);
        HashMap replicant = (HashMap)this.replicants.get((Object)key);
        if (replicant == null && local == null) {
            return null;
        }
        ArrayList<Serializable> rtn = new ArrayList<Serializable>();
        if (replicant == null) {
            if (local != null) {
                rtn.add(local);
            }
        } else {
            ClusterNode[] nodes = this.partition.getClusterNodes();
            for (int i = 0; i < nodes.length; ++i) {
                String replNode = nodes[i].getName();
                if (local != null && this.nodeName.equals(replNode)) {
                    rtn.add(local);
                    continue;
                }
                Object replVal = replicant.get(replNode);
                if (replVal == null) continue;
                rtn.add((Serializable)replVal);
            }
        }
        return rtn;
    }

    public List lookupReplicantsNodeNames(String key) {
        boolean locallyReplicated = this.localReplicants.containsKey((Object)key);
        HashMap replicant = (HashMap)this.replicants.get((Object)key);
        if (replicant == null && !locallyReplicated) {
            return null;
        }
        ArrayList<String> rtn = new ArrayList<String>();
        if (replicant == null) {
            if (locallyReplicated) {
                rtn.add(this.nodeName);
            }
        } else {
            Set keys = replicant.keySet();
            ClusterNode[] nodes = this.partition.getClusterNodes();
            for (int i = 0; i < nodes.length; ++i) {
                String keyOwner = nodes[i].getName();
                if (locallyReplicated && this.nodeName.equals(keyOwner)) {
                    rtn.add(this.nodeName);
                    continue;
                }
                if (!keys.contains(keyOwner)) continue;
                rtn.add(keyOwner);
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.keyListeners;
        synchronized (concurrentReaderHashMap) {
            ArrayList<DistributedReplicantManager.ReplicantListener> listeners = (ArrayList<DistributedReplicantManager.ReplicantListener>)this.keyListeners.get((Object)key);
            if (listeners == null) {
                listeners = new ArrayList<DistributedReplicantManager.ReplicantListener>();
                this.keyListeners.put((Object)key, listeners);
            }
            listeners.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(String key, DistributedReplicantManager.ReplicantListener subscriber) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.keyListeners;
        synchronized (concurrentReaderHashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get((Object)key);
            if (listeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.keyListeners.remove((Object)key);
            }
        }
    }

    public int getReplicantsViewId(String key) {
        Integer result = (Integer)this.intraviewIdCache.get(key);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public boolean isMasterReplica(String key) {
        if (this.trace) {
            this.log.trace((Object)("isMasterReplica, key=" + key));
        }
        if (!this.localReplicants.containsKey((Object)key)) {
            if (this.trace) {
                this.log.trace((Object)("no localReplicants, key=" + key + ", isMasterReplica=false"));
            }
            return false;
        }
        Vector allNodes = this.partition.getCurrentView();
        HashMap repForKey = (HashMap)this.replicants.get((Object)key);
        if (repForKey == null) {
            if (this.trace) {
                this.log.trace((Object)("no replicants, key=" + key + ", isMasterReplica=true"));
            }
            return true;
        }
        Vector replicaNodes = new Vector(repForKey.keySet());
        boolean isMasterReplica = false;
        for (int i = 0; i < allNodes.size(); ++i) {
            String aMember = (String)allNodes.elementAt(i);
            if (this.trace) {
                this.log.trace((Object)("Testing member: " + aMember));
            }
            if (replicaNodes.contains(aMember)) {
                if (!this.trace) break;
                this.log.trace((Object)"Member found in replicaNodes, isMasterReplica=false");
                break;
            }
            if (!aMember.equals(this.nodeName)) continue;
            if (this.trace) {
                this.log.trace((Object)"Member == nodeName, isMasterReplica=true");
            }
            isMasterReplica = true;
            break;
        }
        return isMasterReplica;
    }

    public void _add(String key, String nodeName, Serializable replicant) {
        if (this.trace) {
            this.log.trace((Object)("_add(" + key + ", " + nodeName));
        }
        try {
            this.addReplicant(key, nodeName, replicant);
            KeyChangeEvent kce = new KeyChangeEvent();
            kce.key = key;
            kce.replicants = this.lookupReplicants(key);
            this.asynchHandler.queueEvent(kce);
        }
        catch (Exception ex) {
            this.log.error((Object)"_add failed", (Throwable)ex);
        }
    }

    public void _remove(String key, String nodeName) {
        try {
            if (this.removeReplicant(key, nodeName)) {
                KeyChangeEvent kce = new KeyChangeEvent();
                kce.key = key;
                kce.replicants = this.lookupReplicants(key);
                this.asynchHandler.queueEvent(kce);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"_remove failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeReplicant(String key, String nodeName) throws Exception {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.replicants;
        synchronized (concurrentReaderHashMap) {
            HashMap replicant = (HashMap)this.replicants.get((Object)key);
            if (replicant == null) {
                return false;
            }
            Object removed = replicant.remove(nodeName);
            if (removed != null) {
                Collection values = replicant.values();
                if (values.size() == 0) {
                    this.replicants.remove((Object)key);
                }
                return true;
            }
        }
        return false;
    }

    public Object[] lookupLocalReplicants() throws Exception {
        this.partitionNameKnown.acquire();
        Object[] rtn = new Object[]{this.nodeName, this.localReplicants};
        if (this.trace) {
            this.log.trace((Object)("lookupLocalReplicants called (" + rtn[0] + "). Return: " + this.localReplicants.size()));
        }
        return rtn;
    }

    protected int calculateReplicantsHash(List members) {
        int result = 0;
        Object obj = null;
        for (int i = 0; i < members.size(); ++i) {
            obj = members.get(i);
            if (obj == null) continue;
            result += obj.hashCode();
        }
        return result;
    }

    protected int updateReplicantsHashId(String key) {
        List nodes = this.lookupReplicantsNodeNames(key);
        int result = 0;
        if (nodes == null || nodes.size() == 0) {
            this.intraviewIdCache.remove(key);
        } else {
            result = this.calculateReplicantsHash(nodes);
            this.intraviewIdCache.put(key, new Integer(result));
        }
        return result;
    }

    protected void addReplicant(String key, String nodeName, Serializable replicant) {
        this.addReplicant((Map)this.replicants, key, nodeName, replicant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReplicant(Map map, String key, String nodeName, Serializable replicant) {
        Map map2 = map;
        synchronized (map2) {
            HashMap<String, Serializable> rep = (HashMap<String, Serializable>)map.get(key);
            if (rep == null) {
                if (this.trace) {
                    this.log.trace((Object)"_adding new HashMap");
                }
                rep = new HashMap<String, Serializable>();
                map.put(key, rep);
            }
            rep.put(nodeName, replicant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getKeysReplicatedByNode(String nodeName) {
        Vector<String> result = new Vector<String>();
        ConcurrentReaderHashMap concurrentReaderHashMap = this.replicants;
        synchronized (concurrentReaderHashMap) {
            for (String key : this.replicants.keySet()) {
                HashMap values = (HashMap)this.replicants.get((Object)key);
                if (values == null || !values.containsKey(nodeName)) continue;
                result.add(key);
            }
        }
        return result;
    }

    protected boolean replicantEntryAlreadyExists(String key, String nodeName) {
        return this.replicantEntryAlreadyExists((Map)this.replicants, key, nodeName);
    }

    protected boolean replicantEntryAlreadyExists(Map map, String key, String nodeName) {
        HashMap rep = (HashMap)map.get(key);
        if (rep == null) {
            return false;
        }
        return rep.containsKey(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyKeyListeners(String key, List newReplicants) {
        if (this.trace) {
            this.log.trace((Object)"notifyKeyListeners");
        }
        int newId = this.updateReplicantsHashId(key);
        ArrayList listeners = (ArrayList)this.keyListeners.get((Object)key);
        if (listeners == null) {
            if (this.trace) {
                this.log.trace((Object)"listeners is null");
            }
            return;
        }
        DistributedReplicantManager.ReplicantListener[] toNotify = null;
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            toNotify = new DistributedReplicantManager.ReplicantListener[listeners.size()];
            toNotify = listeners.toArray(toNotify);
        }
        if (this.trace) {
            this.log.trace((Object)("notifying " + toNotify.length + " listeners for key change: " + key));
        }
        for (int i = 0; i < toNotify.length; ++i) {
            if (toNotify[i] == null) continue;
            toNotify[i].replicantsChanged(key, newReplicants, newId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void republishLocalReplicants() {
        try {
            HashMap localReplicants;
            if (this.trace) {
                this.log.trace((Object)"Start Re-Publish local replicants in DRM");
            }
            ConcurrentReaderHashMap concurrentReaderHashMap = this.localReplicants;
            synchronized (concurrentReaderHashMap) {
                localReplicants = new HashMap(this.localReplicants);
            }
            for (Map.Entry entry : localReplicants.entrySet()) {
                String key = (String)entry.getKey();
                Object replicant = entry.getValue();
                if (replicant == null) continue;
                if (this.trace) {
                    this.log.trace((Object)("publishing, key=" + key + ", value=" + replicant));
                }
                Object[] args = new Object[]{key, this.nodeName, replicant};
                this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_add", args, this.add_types, true);
                this.notifyKeyListeners(key, this.lookupReplicants(key));
            }
            if (this.trace) {
                this.log.trace((Object)"End Re-Publish local replicants");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Re-Publish failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeMembers() {
        boolean isAlreadyMerging = ClusterMergeStatus.isMergeInProcess();
        try {
            ClusterMergeStatus.startMergeProcess();
            this.log.debug((Object)"Start merging members in DRM service...");
            HashSet<String> notifies = new HashSet<String>();
            ArrayList rsp = this.partition.callMethodOnCluster(SERVICE_NAME, "lookupLocalReplicants", new Object[0], new Class[0], true);
            if (rsp.size() == 0) {
                this.log.debug((Object)"No responses from other nodes during the DRM merge process.");
            } else {
                this.log.debug((Object)("The DRM merge process has received " + rsp.size() + " answers"));
            }
            for (int i = 0; i < rsp.size(); ++i) {
                Object o = rsp.get(i);
                if (o == null) {
                    this.log.warn((Object)"As part of the answers received during the DRM merge process, a NULL message was received!");
                    continue;
                }
                if (o instanceof Throwable) {
                    this.log.warn((Object)"As part of the answers received during the DRM merge process, a Throwable was received!", (Throwable)o);
                    continue;
                }
                Object[] objs = (Object[])o;
                String node = (String)objs[0];
                Map replicants = (Map)objs[1];
                for (String key : replicants.keySet()) {
                    if (this.replicantEntryAlreadyExists(key, node)) continue;
                    this.addReplicant(key, node, (Serializable)replicants.get(key));
                    notifies.add(key);
                }
                Vector currentStatus = this.getKeysReplicatedByNode(node);
                if (currentStatus.size() <= replicants.size()) continue;
                int currentKeysMax = currentStatus.size();
                for (int currentKeysId = 0; currentKeysId < currentKeysMax; ++currentKeysId) {
                    String theKey = (String)currentStatus.elementAt(currentKeysId);
                    if (replicants.containsKey(theKey)) continue;
                    this.removeReplicant(theKey, node);
                    notifies.add(theKey);
                }
            }
            for (String key : notifies) {
                this.notifyKeyListeners(key, this.lookupReplicants(key));
            }
            this.log.debug((Object)"..Finished merging members in DRM service");
        }
        catch (Exception ex) {
            this.log.error((Object)"merge failed", (Throwable)ex);
        }
        finally {
            if (!isAlreadyMerging) {
                ClusterMergeStatus.endMergeProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeDeadMembers(Vector deadMembers) {
        if (deadMembers.size() <= 0) {
            return;
        }
        this.log.debug((Object)("purgeDeadMembers, " + deadMembers));
        try {
            ConcurrentReaderHashMap concurrentReaderHashMap = this.replicants;
            synchronized (concurrentReaderHashMap) {
                for (String key : this.replicants.keySet()) {
                    HashMap replicant = (HashMap)this.replicants.get((Object)key);
                    boolean modified = false;
                    for (int i = 0; i < deadMembers.size(); ++i) {
                        String node = deadMembers.elementAt(i).toString();
                        this.log.debug((Object)("trying to remove deadMember " + node + " for key " + key));
                        Object removed = replicant.remove(node);
                        if (removed != null) {
                            this.log.debug((Object)(node + " was removed"));
                            modified = true;
                            continue;
                        }
                        this.log.debug((Object)(node + " was NOT removed!!!"));
                    }
                    if (!modified) continue;
                    this.notifyKeyListeners(key, this.lookupReplicants(key));
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"purgeDeadMembers failed", (Throwable)ex);
        }
    }

    protected void cleanupKeyListeners() {
    }

    protected static synchronized int nextThreadID() {
        return threadID++;
    }

    protected class MembersPublisher
    extends Thread {
        public MembersPublisher() {
            super("DRM Async Publisher#" + DistributedReplicantManagerImpl.nextThreadID());
        }

        public void run() {
            DistributedReplicantManagerImpl.this.log.debug((Object)"DRM: Sleeping before re-publishing for 50ms just in case");
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DistributedReplicantManagerImpl.this.republishLocalReplicants();
        }
    }

    protected class MergeMembers
    extends Thread {
        public MergeMembers() {
            super("DRM Async Merger#" + DistributedReplicantManagerImpl.nextThreadID());
        }

        public void run() {
            DistributedReplicantManagerImpl.this.log.debug((Object)"Sleeping for 50ms before mergeMembers");
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DistributedReplicantManagerImpl.this.mergeMembers();
        }
    }

    static class KeyChangeEvent {
        String key;
        List replicants;

        KeyChangeEvent() {
        }
    }
}

