/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.AsynchEventHandler;
import org.jboss.ha.framework.server.DistributedReplicantManagerImpl;
import org.jboss.ha.framework.server.DistributedStateImpl;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class HAPartitionImpl
extends RpcDispatcher
implements MessageListener,
MembershipListener,
HAPartition,
AsynchEventHandler.AsynchEventProcessor {
    protected HashMap rpcHandlers = new HashMap();
    protected HashMap stateHandlers = new HashMap();
    protected boolean allowSyncListeners = false;
    protected ArrayList synchListeners = new ArrayList();
    protected ArrayList asynchListeners = new ArrayList();
    protected AsynchEventHandler asynchHandler;
    protected Vector members = null;
    protected Vector jgmembers = null;
    public Vector history = null;
    protected Vector otherMembers = null;
    protected Vector jgotherMembers = null;
    protected String partitionName;
    protected IpAddress localJGAddress = null;
    protected String nodeName;
    protected ClusterNode me = null;
    protected long timeout = 60000L;
    protected JChannel channel;
    protected DistributedReplicantManagerImpl replicantManager;
    protected DistributedStateImpl dsManager;
    protected Logger log;
    protected Logger clusterLifeCycleLog;
    protected long currentViewId = -1L;
    protected MBeanServer server;
    protected long state_transfer_timeout = 60000L;
    protected boolean bindIntoJndi = true;
    protected boolean isStateSet = false;
    protected Exception setStateException;
    private final Object stateLock = new Object();

    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        MarshalledValueInputStream mvis = new MarshalledValueInputStream((InputStream)bais);
        return mvis.readObject();
    }

    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream((OutputStream)baos);
        mvos.writeObject(obj);
        mvos.flush();
        return baos.toByteArray();
    }

    public long getStateTransferTimeout() {
        return this.state_transfer_timeout;
    }

    public void setStateTransferTimeout(long state_transfer_timeout) {
        this.state_transfer_timeout = state_transfer_timeout;
    }

    public long getMethodCallTimeout() {
        return this.timeout;
    }

    public void setMethodCallTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HAPartitionImpl(String partitionName, JChannel channel, boolean deadlock_detection, MBeanServer server) throws Exception {
        this(partitionName, channel, deadlock_detection);
        this.server = server;
    }

    public HAPartitionImpl(String partitionName, JChannel channel, boolean deadlock_detection) throws Exception {
        super((Channel)channel, null, null, new Object(), deadlock_detection);
        this.log = Logger.getLogger((String)(HAPartition.class.getName() + "." + partitionName));
        this.clusterLifeCycleLog = Logger.getLogger((String)(HAPartition.class.getName() + ".lifecycle." + partitionName));
        this.channel = channel;
        this.partitionName = partitionName;
        this.history = new Vector();
        this.setMarshaller(new MarshallerImpl());
        this.logHistory("Partition object created");
    }

    public void init() throws Exception {
        this.log.info((Object)"Initializing");
        this.logHistory("Initializing partition");
        this.log.debug((Object)"setMembershipListener");
        this.setMembershipListener(this);
        this.log.debug((Object)"setMessageListener");
        this.setMessageListener(this);
        this.log.debug((Object)"create replicant manager");
        this.replicantManager = new DistributedReplicantManagerImpl(this, this.server);
        this.log.debug((Object)"init replicant manager");
        this.replicantManager.init();
        this.log.debug((Object)"bind replicant manager");
        this.log.debug((Object)"create distributed state");
        this.dsManager = new DistributedStateImpl(this, this.server);
        this.log.debug((Object)"init distributed state service");
        this.dsManager.init();
        this.log.debug((Object)"bind distributed state service");
        this.asynchHandler = new AsynchEventHandler(this, "AsynchViewChangeHandler");
        this.log.debug((Object)"done initing.");
    }

    public void startPartition() throws Exception {
        this.logHistory("Starting partition");
        this.log.debug((Object)"get nodeName");
        this.localJGAddress = (IpAddress)this.channel.getLocalAddress();
        this.me = new ClusterNode(this.localJGAddress);
        this.nodeName = this.me.getName();
        this.log.debug((Object)"Get current members");
        View view = this.channel.getView();
        this.jgmembers = (Vector)view.getMembers().clone();
        this.members = this.translateAddresses(this.jgmembers);
        this.log.info((Object)("Number of cluster members: " + this.members.size()));
        for (int m = 0; m > this.members.size(); ++m) {
            Object node = this.members.get(m);
            this.log.debug(node);
        }
        this.jgotherMembers = (Vector)view.getMembers().clone();
        this.jgotherMembers.remove(this.channel.getLocalAddress());
        this.otherMembers = this.translateAddresses(this.jgotherMembers);
        this.log.info((Object)("Other members: " + this.otherMembers.size()));
        this.verifyNodeIsUnique(view.getMembers());
        this.currentViewId = view.getVid().getId();
        this.fetchState();
        this.replicantManager.start();
        this.dsManager.start();
        this.asynchHandler.start();
        if (!this.bindIntoJndi) {
            return;
        }
        InitialContext ctx = new InitialContext();
        this.bind("/HAPartition/" + this.partitionName, this, HAPartitionImpl.class, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchState() throws Exception {
        this.log.info((Object)("Fetching state (will wait for " + this.state_transfer_timeout + " milliseconds):"));
        this.isStateSet = false;
        long start = System.currentTimeMillis();
        boolean rc = this.channel.getState(null, this.state_transfer_timeout);
        if (rc) {
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.isStateSet) {
                    if (this.setStateException != null) {
                        throw this.setStateException;
                    }
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException iex) {}
                }
            }
            long stop = System.currentTimeMillis();
            this.log.info((Object)("state was retrieved successfully (in " + (stop - start) + " milliseconds)"));
        } else {
            Vector vector = this.members;
            synchronized (vector) {
                while (this.members.size() == 0) {
                    this.log.debug((Object)"waiting on viewAccepted()");
                    try {
                        this.members.wait();
                    }
                    catch (InterruptedException iex) {}
                }
            }
            if (this.isCurrentNodeCoordinator()) {
                this.log.info((Object)"State could not be retrieved (we are the first member in group)");
            } else {
                throw new IllegalStateException("Initial state transfer failed: Channel.getState() returned false");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePartition() throws Exception {
        this.logHistory("Closing partition");
        this.log.info((Object)("Closing partition " + this.partitionName));
        try {
            this.asynchHandler.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to stop asynchHandler", (Throwable)e);
        }
        try {
            this.replicantManager.stop();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.dsManager.stop();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.channel.disconnect();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        if (this.bindIntoJndi) {
            String boundName = "/HAPartition/" + this.partitionName;
            InitialContext ctx = new InitialContext();
            try {
                ctx.unbind(boundName);
            }
            finally {
                ctx.close();
            }
            NonSerializableFactory.unbind((String)boundName);
        }
        this.log.info((Object)("Partition " + this.partitionName + " closed."));
    }

    public void destroyPartition() throws Exception {
        try {
            this.replicantManager.destroy();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.dsManager.destroy();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            this.channel.close();
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
        }
        this.log.info((Object)("Partition " + this.partitionName + " destroyed."));
    }

    public byte[] getState() {
        this.logHistory("getState called on partition");
        boolean debug = this.log.isDebugEnabled();
        this.log.debug((Object)"getState called.");
        try {
            HashMap<String, Serializable> state = new HashMap<String, Serializable>();
            for (String key : this.stateHandlers.keySet()) {
                HAPartition.HAPartitionStateTransfer subscriber = (HAPartition.HAPartitionStateTransfer)this.stateHandlers.get(key);
                if (debug) {
                    this.log.debug((Object)("getState for " + key));
                }
                state.put(key, subscriber.getCurrentState());
            }
            return HAPartitionImpl.objectToByteBuffer(state);
        }
        catch (Exception ex) {
            this.log.error((Object)"getState failed", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(byte[] obj) {
        this.logHistory("setState called on partition");
        try {
            this.log.debug((Object)"setState called");
            if (obj == null) {
                this.log.debug((Object)"state is null");
                return;
            }
            int state_size = obj != null ? obj.length : 0;
            Runtime rt = Runtime.getRuntime();
            long used_mem_before = rt.totalMemory() - rt.freeMemory();
            HashMap state = (HashMap)HAPartitionImpl.objectFromByteBuffer(obj);
            for (String key : state.keySet()) {
                this.log.debug((Object)("setState for " + key));
                Object someState = state.get(key);
                HAPartition.HAPartitionStateTransfer subscriber = (HAPartition.HAPartitionStateTransfer)this.stateHandlers.get(key);
                if (subscriber != null) {
                    try {
                        subscriber.setCurrentState((Serializable)someState);
                    }
                    catch (Exception e) {
                        if ("DistributedReplicantManager".equals(key) || "DistributedState".equals(key)) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException(e);
                        }
                        this.log.error((Object)("Caught exception setting state to " + subscriber), (Throwable)e);
                    }
                    continue;
                }
                this.log.debug((Object)("There is no stateHandler for: " + key));
            }
            long used_mem_after = rt.totalMemory() - rt.freeMemory();
            this.log.debug((Object)("received a state of " + state_size + " bytes; expanded memory by " + (used_mem_after - used_mem_before) + " bytes (used memory before: " + used_mem_before + ", used memory after: " + used_mem_after + ")"));
            this.isStateSet = true;
        }
        catch (Throwable t) {
            this.log.error((Object)"failed setting state", t);
            this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
        }
        finally {
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
            }
        }
    }

    public void receive(Message msg) {
    }

    public void suspect(Address suspected_mbr) {
        this.logHistory("Node suspected: " + (suspected_mbr == null ? "null" : suspected_mbr.toString()));
        if (this.isCurrentNodeCoordinator()) {
            this.clusterLifeCycleLog.info((Object)("Suspected member: " + suspected_mbr));
        } else {
            this.log.info((Object)("Suspected member: " + suspected_mbr));
        }
    }

    public void block() {
    }

    public void viewAccepted(View newView) {
        try {
            this.currentViewId = newView.getVid().getId();
            this.jgotherMembers = (Vector)newView.getMembers().clone();
            this.jgotherMembers.remove(this.channel.getLocalAddress());
            this.otherMembers = this.translateAddresses(this.jgotherMembers);
            Vector translatedNewView = this.translateAddresses((Vector)newView.getMembers().clone());
            this.logHistory("New view: " + translatedNewView + " with viewId: " + this.currentViewId + " (old view: " + this.members + " )");
            Vector oldMembers = this.members;
            Vector newjgMembers = (Vector)newView.getMembers().clone();
            Vector newMembers = this.translateAddresses(newjgMembers);
            if (this.members == null) {
                this.members = newMembers;
                this.jgmembers = newjgMembers;
                this.log.debug((Object)"ViewAccepted: initial members set");
                return;
            }
            this.members = newMembers;
            this.jgmembers = newjgMembers;
            int difference = 0;
            difference = oldMembers == null ? newMembers.size() - 1 : newMembers.size() - oldMembers.size();
            if (this.isCurrentNodeCoordinator()) {
                this.clusterLifeCycleLog.info((Object)("New cluster view for partition " + this.partitionName + " (id: " + this.currentViewId + ", delta: " + difference + ") : " + this.members));
            } else {
                this.log.info((Object)("New cluster view for partition " + this.partitionName + ": " + this.currentViewId + " (" + this.members + " delta: " + difference + ")"));
            }
            ViewChangeEvent event = new ViewChangeEvent();
            event.viewId = this.currentViewId;
            event.allMembers = translatedNewView;
            event.deadMembers = this.getDeadMembers(oldMembers, event.allMembers);
            event.newMembers = this.getNewMembers(oldMembers, event.allMembers);
            event.originatingGroups = null;
            if (newView instanceof MergeView) {
                MergeView mergeView = (MergeView)newView;
                event.originatingGroups = mergeView.getSubgroups();
            }
            this.log.debug((Object)("membership changed from " + (oldMembers == null ? 0 : oldMembers.size()) + " to " + event.allMembers.size()));
            this.asynchHandler.queueEvent(event);
            if (this.allowSyncListeners) {
                this.notifyListeners(this.synchListeners, event.viewId, event.allMembers, event.deadMembers, event.newMembers, event.originatingGroups);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"ViewAccepted failed", (Throwable)ex);
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public DistributedReplicantManager getDistributedReplicantManager() {
        return this.replicantManager;
    }

    public DistributedState getDistributedStateService() {
        return this.dsManager;
    }

    public long getCurrentViewId() {
        return this.currentViewId;
    }

    public Vector getCurrentView() {
        Vector<String> result = new Vector<String>(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            result.add(((ClusterNode)this.members.elementAt(i)).getName());
        }
        return result;
    }

    public ClusterNode[] getClusterNodes() {
        ClusterNode[] nodes = new ClusterNode[this.members.size()];
        this.members.toArray(nodes);
        return nodes;
    }

    public ClusterNode getClusterNode() {
        return this.me;
    }

    public boolean isCurrentNodeCoordinator() {
        if (this.members == null || this.members.size() == 0 || this.me == null) {
            return false;
        }
        return this.members.elementAt(0).equals(this.me);
    }

    public void registerRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.put(objName, subscriber);
    }

    public void unregisterRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.remove(objName);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, boolean excludeSelf) throws Exception {
        return this.callMethodOnCluster(objName, methodName, args, null, excludeSelf);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return this.callMethodOnCluster(objName, methodName, args, types, excludeSelf, this.timeout);
    }

    public ArrayList callMethodOnCluster(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf, long methodTimeout) throws Exception {
        ArrayList<Object> rtn = new ArrayList<Object>();
        MethodCall m = null;
        RspList rsp = null;
        boolean trace = this.log.isTraceEnabled();
        m = types != null ? new MethodCall(objName + "." + methodName, args, types) : new MethodCall(objName + "." + methodName, args);
        if (excludeSelf) {
            if (trace) {
                this.log.trace((Object)("callMethodOnCluster(true), objName=" + objName + ", methodName=" + methodName + ", members=" + this.jgotherMembers));
            }
            rsp = this.callRemoteMethods(this.jgotherMembers, m, 2, methodTimeout);
        } else {
            if (trace) {
                this.log.trace((Object)("callMethodOnCluster(false), objName=" + objName + ", methodName=" + methodName + ", members=" + this.members));
            }
            rsp = this.callRemoteMethods(null, m, 2, methodTimeout);
        }
        if (rsp != null) {
            for (int i = 0; i < rsp.size(); ++i) {
                Object item = rsp.elementAt(i);
                if (item instanceof Rsp) {
                    Rsp response = (Rsp)item;
                    boolean wasReceived = response.wasReceived();
                    if (wasReceived) {
                        item = response.getValue();
                        if (item instanceof NoHandlerForRPC) continue;
                        rtn.add(item);
                        continue;
                    }
                    if (!trace) continue;
                    this.log.trace((Object)("Ignoring non-received response: " + response));
                    continue;
                }
                if (!(item instanceof NoHandlerForRPC)) {
                    rtn.add(item);
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)"Ignoring NoHandlerForRPC");
            }
        }
        return rtn;
    }

    public ArrayList callMethodOnCoordinatorNode(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        return this.callMethodOnCoordinatorNode(objName, methodName, args, types, excludeSelf, this.timeout);
    }

    public ArrayList callMethodOnCoordinatorNode(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf, long methodTimeout) throws Exception {
        ArrayList<Object> rtn = new ArrayList<Object>();
        MethodCall m = null;
        RspList rsp = null;
        boolean trace = this.log.isTraceEnabled();
        m = types != null ? new MethodCall(objName + "." + methodName, args, types) : new MethodCall(objName + "." + methodName, args);
        if (trace) {
            this.log.trace((Object)("callMethodOnCoordinatorNode(false), objName=" + objName + ", methodName=" + methodName));
        }
        Vector coordinatorOnly = new Vector();
        if (!this.isCurrentNodeCoordinator() || !excludeSelf) {
            coordinatorOnly.addElement(this.jgmembers.elementAt(0));
        }
        if ((rsp = this.callRemoteMethods(coordinatorOnly, m, 2, methodTimeout)) != null) {
            for (int i = 0; i < rsp.size(); ++i) {
                Object item = rsp.elementAt(i);
                if (item instanceof Rsp) {
                    Rsp response = (Rsp)item;
                    boolean wasReceived = response.wasReceived();
                    if (wasReceived) {
                        item = response.getValue();
                        if (item instanceof NoHandlerForRPC) continue;
                        rtn.add(item);
                        continue;
                    }
                    if (!trace) continue;
                    this.log.trace((Object)("Ignoring non-received response: " + response));
                    continue;
                }
                if (!(item instanceof NoHandlerForRPC)) {
                    rtn.add(item);
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)"Ignoring NoHandlerForRPC");
            }
        }
        return rtn;
    }

    public void callAsynchMethodOnCluster(String objName, String methodName, Object[] args, boolean excludeSelf) throws Exception {
        this.callAsynchMethodOnCluster(objName, methodName, args, null, excludeSelf);
    }

    public void callAsynchMethodOnCluster(String objName, String methodName, Object[] args, Class[] types, boolean excludeSelf) throws Exception {
        MethodCall m = null;
        boolean trace = this.log.isTraceEnabled();
        m = types != null ? new MethodCall(objName + "." + methodName, args, types) : new MethodCall(objName + "." + methodName, args);
        if (excludeSelf) {
            if (trace) {
                this.log.trace((Object)("callAsynchMethodOnCluster(true), objName=" + objName + ", methodName=" + methodName + ", members=" + this.jgotherMembers));
            }
            this.callRemoteMethods(this.jgotherMembers, m, 6, this.timeout);
        } else {
            if (trace) {
                this.log.trace((Object)("callAsynchMethodOnCluster(false), objName=" + objName + ", methodName=" + methodName + ", members=" + this.members));
            }
            this.callRemoteMethods(null, m, 6, this.timeout);
        }
    }

    public void subscribeToStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.put(objectName, subscriber);
    }

    public void unsubscribeFromStateTransferEvents(String objectName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.stateHandlers.remove(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMembershipListener(HAPartition.HAMembershipListener listener) {
        boolean isAsynch;
        boolean bl = isAsynch = !this.allowSyncListeners || listener instanceof HAPartition.AsynchHAMembershipListener || listener instanceof HAPartition.AsynchHAMembershipExtendedListener;
        if (isAsynch) {
            ArrayList arrayList = this.asynchListeners;
            synchronized (arrayList) {
                this.asynchListeners.add(listener);
            }
        }
        ArrayList arrayList = this.synchListeners;
        synchronized (arrayList) {
            this.synchListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMembershipListener(HAPartition.HAMembershipListener listener) {
        boolean isAsynch;
        boolean bl = isAsynch = !this.allowSyncListeners || listener instanceof HAPartition.AsynchHAMembershipListener || listener instanceof HAPartition.AsynchHAMembershipExtendedListener;
        if (isAsynch) {
            ArrayList arrayList = this.asynchListeners;
            synchronized (arrayList) {
                this.asynchListeners.remove(listener);
            }
        }
        ArrayList arrayList = this.synchListeners;
        synchronized (arrayList) {
            this.synchListeners.remove(listener);
        }
    }

    public boolean getAllowSynchronousMembershipNotifications() {
        return this.allowSyncListeners;
    }

    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.allowSyncListeners = allowSync;
    }

    public Object handle(Message req) {
        Object body = null;
        Object retval = null;
        MethodCall method_call = null;
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Partition " + this.partitionName + " received msg"));
        }
        if (req == null || req.getBuffer() == null) {
            this.log.warn((Object)"message or message buffer is null !");
            return null;
        }
        try {
            body = HAPartitionImpl.objectFromByteBuffer(req.getBuffer());
        }
        catch (Exception e) {
            this.log.warn((Object)("failed unserializing message buffer (msg=" + req + ")"), (Throwable)e);
            return null;
        }
        if (body == null || !(body instanceof MethodCall)) {
            this.log.warn((Object)"message does not contain a MethodCall object !");
            return null;
        }
        method_call = (MethodCall)body;
        String methodName = method_call.getName();
        if (trace) {
            this.log.trace((Object)("pre methodName: " + methodName));
        }
        int idx = methodName.lastIndexOf(46);
        String handlerName = methodName.substring(0, idx);
        String newMethodName = methodName.substring(idx + 1);
        if (trace) {
            this.log.trace((Object)("handlerName: " + handlerName + " methodName: " + newMethodName));
            this.log.trace((Object)("Handle: " + methodName));
        }
        method_call.setName(newMethodName);
        Object handler = this.rpcHandlers.get(handlerName);
        if (handler == null) {
            if (trace) {
                this.log.debug((Object)("No rpc handler registered under: " + handlerName));
            }
            return new NoHandlerForRPC();
        }
        try {
            retval = method_call.invoke(handler);
            if (trace) {
                this.log.trace((Object)("rpc call return value: " + retval));
            }
        }
        catch (Throwable t) {
            if (trace) {
                this.log.trace((Object)"rpc call threw exception", t);
            }
            retval = t;
        }
        return retval;
    }

    public void processEvent(Object event) {
        ViewChangeEvent vce = (ViewChangeEvent)event;
        this.notifyListeners(this.asynchListeners, vce.viewId, vce.allMembers, vce.deadMembers, vce.newMembers, vce.originatingGroups);
    }

    protected void verifyNodeIsUnique(Vector javaGroupIpAddresses) throws Exception {
        byte[] localUniqueName = this.localJGAddress.getAdditionalData();
        if (localUniqueName == null) {
            this.log.warn((Object)"No additional information has been found in the JavaGroup address: make sure you are running with a correct version of JGroups and that the protocol  you are using supports the 'additionalData' behaviour");
            return;
        }
        for (int i = 0; i < javaGroupIpAddresses.size(); ++i) {
            IpAddress address = (IpAddress)javaGroupIpAddresses.elementAt(i);
            if (address.equals((Object)this.localJGAddress) || !localUniqueName.equals(address.getAdditionalData())) continue;
            throw new Exception("Local node removed from cluster (" + this.localJGAddress + "): another node (" + address + ") publicizing the same name was already there");
        }
    }

    protected void bind(String jndiName, Object who, Class classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext" + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    protected Vector getDeadMembers(Vector oldMembers, Vector newMembers) {
        boolean debug = this.log.isDebugEnabled();
        if (oldMembers == null) {
            oldMembers = new Vector();
        }
        if (newMembers == null) {
            newMembers = new Vector();
        }
        Vector dead = (Vector)oldMembers.clone();
        dead.removeAll(newMembers);
        if (dead.size() > 0 && debug) {
            this.log.debug((Object)("dead members: " + dead));
        }
        return dead;
    }

    protected Vector getNewMembers(Vector oldMembers, Vector allMembers) {
        if (oldMembers == null) {
            oldMembers = new Vector();
        }
        if (allMembers == null) {
            allMembers = new Vector();
        }
        Vector newMembers = (Vector)allMembers.clone();
        newMembers.removeAll(oldMembers);
        return newMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(ArrayList theListeners, long viewID, Vector allMembers, Vector deadMembers, Vector newMembers, Vector originatingGroups) {
        this.log.debug((Object)("Begin notifyListeners, viewID: " + viewID));
        ArrayList arrayList = theListeners;
        synchronized (arrayList) {
            theListeners = (ArrayList)theListeners.clone();
        }
        for (int i = 0; i < theListeners.size(); ++i) {
            HAPartition.HAMembershipListener aListener = null;
            try {
                aListener = (HAPartition.HAMembershipListener)theListeners.get(i);
                if (originatingGroups != null && aListener instanceof HAPartition.HAMembershipExtendedListener) {
                    HAPartition.HAMembershipExtendedListener exListener = (HAPartition.HAMembershipExtendedListener)aListener;
                    exListener.membershipChangedDuringMerge(deadMembers, newMembers, allMembers, originatingGroups);
                    continue;
                }
                aListener.membershipChanged(deadMembers, newMembers, allMembers);
                continue;
            }
            catch (Throwable e) {
                this.log.warn((Object)("HAMembershipListener callback failure: " + aListener), e);
            }
        }
        this.log.debug((Object)("End notifyListeners, viewID: " + viewID));
    }

    public void setBindIntoJndi(boolean bind) {
        this.bindIntoJndi = bind;
    }

    public boolean getBindIntoJndi() {
        return this.bindIntoJndi;
    }

    protected Vector translateAddresses(Vector jgAddresses) {
        if (jgAddresses == null) {
            return null;
        }
        Vector<ClusterNode> result = new Vector<ClusterNode>(jgAddresses.size());
        for (int i = 0; i < jgAddresses.size(); ++i) {
            IpAddress addr = (IpAddress)jgAddresses.elementAt(i);
            result.add(new ClusterNode(addr));
        }
        return result;
    }

    public void logHistory(String message) {
        try {
            this.history.add(new SimpleDateFormat().format(new Date()) + " : " + message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MarshallerImpl
    implements RpcDispatcher.Marshaller {
        private MarshallerImpl() {
        }

        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            return HAPartitionImpl.objectFromByteBuffer(buf);
        }

        public byte[] objectToByteBuffer(Object obj) throws Exception {
            return HAPartitionImpl.objectToByteBuffer(obj);
        }
    }

    private static class ViewChangeEvent {
        long viewId;
        Vector deadMembers;
        Vector newMembers;
        Vector allMembers;
        Vector originatingGroups;

        private ViewChangeEvent() {
        }
    }

    private static class NoHandlerForRPC
    implements Serializable {
        static final long serialVersionUID = -1263095408483622838L;

        private NoHandlerForRPC() {
        }
    }
}

