/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.retro;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Retro
extends MatchingTask {
    private static String lSep = System.getProperty("line.separator");
    private CommandlineJava cmd = new CommandlineJava();
    private int maxSrc = 1000;
    private Path classpath;
    private Path compilerClasspath;
    private Path compileSourcepath;
    private File destDir;
    private boolean verbose = false;
    private boolean suppress = true;
    private String maxmemory = null;
    protected boolean failOnError = true;

    public void setVerbose(boolean i) {
        this.verbose = i;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setSuppress(boolean i) {
        this.suppress = i;
    }

    public boolean getSupress() {
        return this.suppress;
    }

    public void setMaxmemory(String maxmemory) {
        this.maxmemory = maxmemory;
    }

    public String getMaxmemory() {
        return this.maxmemory;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public void setMaxSrc(int maxSrc) {
        this.maxSrc = maxSrc;
    }

    public int getMaxSrc() {
        return this.maxSrc;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setCompilerClasspathRef(Reference r) {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = new Path(this.getProject());
        }
        this.compilerClasspath.setRefid(r);
    }

    public void setCompilerclasspath(Path cp) {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = cp;
        } else {
            this.compilerClasspath.append(cp);
        }
    }

    public Path getCompilerclasspath() {
        return this.compilerClasspath;
    }

    public Path createCompilerclasspath() {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = new Path(this.getProject());
        }
        return this.compilerClasspath.createPath();
    }

    public Path createSrc() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.cmd.createVmArgument();
    }

    public void execute() throws BuildException {
        if (this.verbose) {
            this.cmd.createArgument().setValue("-verbose");
        }
        if (this.suppress) {
            this.cmd.createArgument().setValue("-suppress");
        }
        if (this.destDir != null) {
            this.cmd.createArgument().setValue("-destdir");
            this.cmd.createArgument().setFile(this.destDir);
        }
        this.logAndAddFilesToCompile(this.cmd);
        this.getProject().log("compileSourcepath: " + this.compileSourcepath, 4);
        try {
            if (this.classpath == null) {
                throw new BuildException("No classpath");
            }
            this.classpath.append(this.compilerClasspath);
            Java java = (Java)this.getProject().createTask("java");
            if (this.getClasspath() != null) {
                this.getProject().log("using user supplied classpath: " + this.getClasspath(), 4);
                java.setClasspath(this.getClasspath().concatSystemClasspath("ignore"));
            } else {
                Path classpath = new Path(this.getProject());
                classpath = classpath.concatSystemClasspath("only");
                this.getProject().log("using system classpath: " + classpath, 4);
                java.setClasspath(classpath);
            }
            java.setDir(this.getProject().getBaseDir());
            java.setClassname("org.jboss.ant.tasks.retro.Weaver");
            String[] jvmargs = this.cmd.getVmCommand().getArguments();
            for (int i = 0; i < jvmargs.length; ++i) {
                java.createJvmarg().setValue(jvmargs[i]);
            }
            String[] args = this.cmd.getJavaCommand().getArguments();
            for (int i = 0; i < args.length; ++i) {
                java.createArg().setValue(args[i]);
            }
            java.setFailonerror(this.getFailonerror());
            java.setFork(true);
            java.setTaskName("retro");
            if (this.maxmemory != null) {
                java.setMaxmemory(this.maxmemory);
            }
            java.execute();
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error running weaver: ", (Throwable)ex, this.getLocation());
        }
    }

    protected void logAndAddFilesToCompile(CommandlineJava cmd) {
        int i;
        ArrayList<String> compilingFiles = new ArrayList<String>();
        if (this.compileSourcepath != null) {
            String[] list = this.compileSourcepath.list();
            for (i = 0; i < list.length; ++i) {
                File srcDir = this.getProject().resolveFile(list[i]);
                if (!srcDir.exists()) {
                    throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
                }
                this.getProject().log("Adding classes from src: " + srcDir, 3);
                DirectoryScanner ds = this.getDirectoryScanner(srcDir);
                String[] files = ds.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    if (!files[j].endsWith(".class")) continue;
                    File f = new File(srcDir, files[j]);
                    compilingFiles.add(f.getAbsolutePath());
                    this.getProject().log("Adding class: " + f, 4);
                }
            }
        }
        int length = 0;
        for (i = 0; i < compilingFiles.size() && (length += ((String)compilingFiles.get(i)).length() + 1) <= this.maxSrc; ++i) {
        }
        if (length < this.maxSrc) {
            StringBuffer niceSourceList = new StringBuffer("Files\n");
            for (int i2 = 0; i2 < compilingFiles.size(); ++i2) {
                String file = (String)compilingFiles.get(i2);
                cmd.createArgument().setValue(file);
                niceSourceList.append("    " + file + lSep);
            }
        } else {
            BufferedWriter writer = null;
            try {
                File sourceFiles = File.createTempFile("src", ".tmp");
                if (this.verbose) {
                    System.out.println("[info] Total length of filenames to be compiled is greater than " + this.maxSrc + ", listing files in --SOURCEPATH: " + sourceFiles.getAbsolutePath());
                }
                sourceFiles.deleteOnExit();
                writer = new BufferedWriter(new FileWriter(sourceFiles));
                for (int i3 = 0; i3 < compilingFiles.size(); ++i3) {
                    writer.write((String)compilingFiles.get(i3));
                    writer.newLine();
                }
                writer.flush();
                cmd.createArgument().setValue("--SOURCEPATH");
                cmd.createArgument().setValue(sourceFiles.getAbsolutePath());
            }
            catch (IOException e) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }
}

