/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.config; 

import org.jboss.security.auth.login.BaseAuthenticationInfo; 

//$Id: ApplicationPolicy.java 64299 2007-07-26 06:31:11Z anil.saldhana@jboss.com $

/**
 *  Application Policy Information Holder
 *  - Authentication
 *  - Authorization
 *  - Audit
 *  - Mapping 
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jun 9, 2006 
 *  @version $Revision: 64299 $
 */
public class ApplicationPolicy
{
   private String name;
   private BaseAuthenticationInfo authenticationInfo;
   private AuthorizationInfo authorizationInfo;
   private AuditInfo auditInfo;
   private MappingInfo roleMappingInfo;
   private IdentityTrustInfo identityTrustInfo;
   
   //Parent PolicyConfig
   private PolicyConfig policyConfig;
   
   public ApplicationPolicy(String theName)
   {
      if(theName == null)
         throw new IllegalArgumentException("name is null");
      this.name = theName;
   }

   public ApplicationPolicy(String theName,BaseAuthenticationInfo info)
   { 
      this(theName);
      authenticationInfo = info;
   }

   public ApplicationPolicy(String theName,AuthorizationInfo info)
   {  
      this(theName);
      authorizationInfo = info;
   }

   public ApplicationPolicy(String theName,
         BaseAuthenticationInfo info, AuthorizationInfo info2)
   { 
      this(theName); 
      authenticationInfo = info;
      authorizationInfo = info2;
   }

   public BaseAuthenticationInfo getAuthenticationInfo()
   {
      return authenticationInfo;
   }

   public void setAuthenticationInfo(BaseAuthenticationInfo authenticationInfo)
   {
      this.authenticationInfo = authenticationInfo;
   }

   public AuthorizationInfo getAuthorizationInfo()
   {
      return authorizationInfo;
   }

   public void setAuthorizationInfo(AuthorizationInfo authorizationInfo)
   {
      this.authorizationInfo = authorizationInfo;
   } 

   public MappingInfo getRoleMappingInfo()
   {
      return roleMappingInfo;
   }

   public void setRoleMappingInfo(MappingInfo roleMappingInfo)
   {
      this.roleMappingInfo = roleMappingInfo;
   } 

   public AuditInfo getAuditInfo()
   {
      return auditInfo;
   }

   public void setAuditInfo(AuditInfo auditInfo)
   {
      this.auditInfo = auditInfo;
   } 

   public IdentityTrustInfo getIdentityTrustInfo()
   {
      return identityTrustInfo;
   }

   public void setIdentityTrustInfo(IdentityTrustInfo identityTrustInfo)
   {
      this.identityTrustInfo = identityTrustInfo;
   }

   public String getName()
   {
      return name;
   }

   public PolicyConfig getPolicyConfig()
   {
      return policyConfig;
   }

   public void setPolicyConfig(PolicyConfig policyConfig)
   {
      this.policyConfig = policyConfig;
   } 
}
