/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.List;

import javax.security.auth.AuthPermission; 
 
import org.jboss.security.authorization.config.AuthorizationModuleEntry;

//$Id: AuthorizationInfo.java 45942 2006-06-28 02:14:46Z asaldhana $

/**
 *  Holder for Authorization configuration
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jun 9, 2006 
 *  @version $Revision: 45942 $
 */
public class AuthorizationInfo
{
   public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
   public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");

   private String name;
   protected ArrayList moduleEntries = new ArrayList(); 
   
   public AuthorizationInfo(String name)
   {
      this.name = name;
   }
   
   public String getName()
   {
      return name;
   } 
   
   public void add(List moduleEntries)
   {
      this.moduleEntries.addAll(moduleEntries);
   }
   
   public void add(AuthorizationModuleEntry ame)
   {
      moduleEntries.add(ame);
   }
   
   public AuthorizationModuleEntry[] getAuthorizationModuleEntry()
   {
      SecurityManager sm = System.getSecurityManager();
      if( sm != null )
         sm.checkPermission(GET_CONFIG_ENTRY_PERM); 
      AuthorizationModuleEntry[] entries = new AuthorizationModuleEntry[moduleEntries.size()];
      moduleEntries.toArray(entries);
      return entries;
   }
}
