/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.List;

import javax.security.auth.AuthPermission;

import org.jboss.security.mapping.config.MappingModuleEntry;

/**
 *  Mapping Info
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @version $Revision$
 *  @since  Aug 28, 2006
 */
public class MappingInfo
{ 
   public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
   public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
   protected String name;
   protected ArrayList<MappingModuleEntry> moduleEntries = new ArrayList<MappingModuleEntry>();

   public MappingInfo()
   {
      super();
   }

   public String getName()
   {
      return name;
   }

   public void add(List<MappingModuleEntry> moduleEntries)
   {
      this.moduleEntries.addAll(moduleEntries);
   }

   public void add(MappingModuleEntry ame)
   {
      moduleEntries.add(ame);
   }

   public MappingModuleEntry[] getMappingModuleEntry()
   {
      SecurityManager sm = System.getSecurityManager();
      if( sm != null )
         sm.checkPermission(GET_CONFIG_ENTRY_PERM); 
      MappingModuleEntry[] entries = new MappingModuleEntry[moduleEntries.size()];
      moduleEntries.toArray(entries);
      return entries;
   }
   
   public void setName(String n)
   {
      this.name = n;
   } 
}