/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.auth.callback.ByteArrayCallback;
import org.jboss.security.auth.callback.MapCallback;
import org.jboss.security.auth.callback.ObjectCallback;

public class AppCallbackHandler
implements CallbackHandler {
    private String username;
    private char[] password;
    private byte[] data;
    private String text;
    private transient String prompt;
    private transient Object credential;
    private Map keyValuePair;
    private boolean consoleHandler = false;

    public AppCallbackHandler() {
    }

    public AppCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public AppCallbackHandler(String username, char[] password, byte[] data) {
        this.username = username;
        this.password = password;
        this.data = data;
    }

    public AppCallbackHandler(String username, char[] password, byte[] data, String text) {
        this.username = username;
        this.password = password;
        this.data = data;
        this.text = text;
    }

    public AppCallbackHandler(boolean isConsoleHandler) {
        this.consoleHandler = isConsoleHandler;
    }

    public AppCallbackHandler(String prompt) {
        this.prompt = prompt;
    }

    public AppCallbackHandler(Map mapOfValues) {
        this.keyValuePair = mapOfValues;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Object getCredential() {
        return this.credential;
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }

    public void clearCredential() {
        this.credential = null;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            String prompt;
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                prompt = nc.getPrompt();
                if (prompt == null) {
                    prompt = "Enter Username: ";
                }
                if (this.consoleHandler) {
                    nc.setName(this.getUserNameFromConsole(prompt));
                    continue;
                }
                nc.setName(this.username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                prompt = pc.getPrompt();
                if (prompt == null) {
                    prompt = "Enter Password: ";
                }
                if (this.consoleHandler) {
                    pc.setPassword(this.getPasswordFromConsole(prompt));
                    continue;
                }
                pc.setPassword(this.password);
                continue;
            }
            if (c instanceof TextInputCallback) {
                TextInputCallback tc = (TextInputCallback)c;
                tc.setText(this.text);
                continue;
            }
            if (c instanceof ByteArrayCallback) {
                ByteArrayCallback bac = (ByteArrayCallback)c;
                bac.setByteArray(this.data);
                continue;
            }
            if (c instanceof ObjectCallback) {
                ObjectCallback oc = (ObjectCallback)c;
                oc.setCredential(this.credential);
                continue;
            }
            if (c instanceof MapCallback) {
                MapCallback mc = (MapCallback)c;
                if (this.keyValuePair == null || this.keyValuePair.isEmpty()) continue;
                for (Object key : this.keyValuePair.keySet()) {
                    if (!(key instanceof String)) {
                        throw new SecurityException("key is not a String");
                    }
                    mc.setInfo((String)key, this.keyValuePair.get(key));
                }
                continue;
            }
            throw new UnsupportedCallbackException(c, "Unrecognized Callback");
        }
    }

    private String getUserNameFromConsole(String prompt) {
        String uName = "";
        System.out.print(prompt);
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        try {
            uName = br.readLine();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to obtain username, ioe=" + e.getMessage());
        }
        return uName;
    }

    private char[] getPasswordFromConsole(String prompt) {
        String pwd = "";
        System.out.print(prompt);
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        try {
            pwd = br.readLine();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to obtain password, ioe=" + e.getMessage());
        }
        return pwd.toCharArray();
    }
}

