/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.AuthPermission;
import org.jboss.security.audit.config.AuditProviderEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditInfo {
    protected List<AuditProviderEntry> moduleEntries = new ArrayList<AuditProviderEntry>();
    public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
    protected String name;

    public AuditInfo() {
    }

    public AuditInfo(String n) {
        this.name = n;
    }

    public void add(List<AuditProviderEntry> entries) {
        this.moduleEntries.addAll(entries);
    }

    public void add(AuditProviderEntry ape) {
        this.moduleEntries.add(ape);
    }

    public AuditProviderEntry[] getAuditProviderEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        AuditProviderEntry[] entries = new AuditProviderEntry[this.moduleEntries.size()];
        this.moduleEntries.toArray(entries);
        return entries;
    }
}

