/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identitytrust;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identitytrust.IdentityTrustContext;
import org.jboss.security.identitytrust.IdentityTrustException;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.identitytrust.IdentityTrustModule;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.plugins.authorization.SecurityActions;

public class JBossIdentityTrustContext
extends IdentityTrustContext {
    protected Logger log = Logger.getLogger(JBossIdentityTrustContext.class);
    private boolean encounteredRequiredDeny = false;
    private boolean encounteredRequiredNotApplicable = false;
    private boolean encounteredOptionalError = false;
    private IdentityTrustException moduleException = null;
    private IdentityTrustManager.TrustDecision overallDecision = IdentityTrustManager.TrustDecision.NotApplicable;
    private boolean encounteredRequiredPermit;

    public JBossIdentityTrustContext(SecurityContext sc) {
        this.securityContext = sc;
    }

    public IdentityTrustManager.TrustDecision isTrusted() throws IdentityTrustException {
        IdentityTrustManager.TrustDecision decision = this.NOTAPPLICABLE;
        try {
            this.initializeModules();
        }
        catch (Exception e) {
            throw new IdentityTrustException((Throwable)e);
        }
        try {
            decision = (IdentityTrustManager.TrustDecision)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IdentityTrustException {
                    IdentityTrustManager.TrustDecision result = JBossIdentityTrustContext.this.invokeTrusted();
                    if (result == JBossIdentityTrustContext.this.PERMIT) {
                        JBossIdentityTrustContext.this.invokeCommit();
                    }
                    if (result == JBossIdentityTrustContext.this.DENY || result == JBossIdentityTrustContext.this.NOTAPPLICABLE) {
                        JBossIdentityTrustContext.this.invokeAbort();
                    }
                    return result;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exc = e.getException();
            this.log.trace((Object)"Error in isAuthorize:", (Throwable)exc);
            this.invokeAbort();
            throw (IdentityTrustException)exc;
        }
        return decision;
    }

    private void initializeModules() throws Exception {
        IdentityTrustModuleEntry[] itmearr;
        String securityDomain = this.securityContext.getSecurityDomain();
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(securityDomain);
        if (aPolicy == null) {
            throw new IllegalStateException("ApplicationPolicy not found for " + securityDomain);
        }
        IdentityTrustInfo iti = aPolicy.getIdentityTrustInfo();
        for (IdentityTrustModuleEntry itme : itmearr = iti.getIdentityTrustModuleEntry()) {
            ControlFlag cf = itme.getControlFlag();
            if (cf == null) {
                cf = ControlFlag.REQUIRED;
            }
            this.controlFlags.add(cf);
            this.modules.add(this.instantiateModule(itme.getName(), itme.getOptions()));
        }
    }

    private IdentityTrustModule instantiateModule(String name, Map map) throws Exception {
        IdentityTrustModule im = null;
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        try {
            Class<?> clazz = tcl.loadClass(name);
            im = (IdentityTrustModule)clazz.newInstance();
        }
        catch (Exception e) {
            this.log.debug((Object)"Error instantiating IdentityTrustModule:", (Throwable)e);
        }
        if (im == null) {
            throw new IllegalStateException("IdentityTrustModule has not been instantiated");
        }
        im.initialize(this.securityContext, this.callbackHandler, this.sharedState, map);
        return im;
    }

    private IdentityTrustManager.TrustDecision invokeTrusted() throws IdentityTrustException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            IdentityTrustManager.TrustDecision decision;
            ControlFlag flag;
            IdentityTrustModule module;
            block14: {
                module = (IdentityTrustModule)this.modules.get(i);
                flag = (ControlFlag)this.controlFlags.get(i);
                decision = this.NOTAPPLICABLE;
                try {
                    decision = module.isTrusted();
                }
                catch (Exception ae) {
                    decision = this.NOTAPPLICABLE;
                    if (this.moduleException != null) break block14;
                    this.moduleException = new IdentityTrustException((Throwable)ae);
                }
            }
            if (decision == this.PERMIT) {
                this.overallDecision = this.PERMIT;
                if (flag == ControlFlag.REQUIRED) {
                    this.encounteredRequiredPermit = true;
                }
                if (flag != ControlFlag.SUFFICIENT || this.encounteredRequiredDeny) continue;
                return this.PERMIT;
            }
            if (decision == this.NOTAPPLICABLE && flag == ControlFlag.REQUIRED) {
                this.encounteredRequiredNotApplicable = true;
                continue;
            }
            if (flag == ControlFlag.REQUISITE) {
                this.log.trace((Object)("REQUISITE failed for " + module));
                if (this.moduleException == null) {
                    this.moduleException = new IdentityTrustException("Authorization failed");
                } else {
                    throw this.moduleException;
                }
            }
            if (flag == ControlFlag.REQUIRED) {
                this.log.trace((Object)("REQUIRED failed for " + module));
                this.encounteredRequiredDeny = true;
            }
            if (flag != ControlFlag.OPTIONAL) continue;
            this.encounteredOptionalError = true;
        }
        if (this.encounteredRequiredDeny) {
            return this.DENY;
        }
        if (this.overallDecision == this.DENY && this.encounteredOptionalError) {
            return this.DENY;
        }
        if (this.overallDecision == this.DENY) {
            return this.DENY;
        }
        if (this.encounteredRequiredNotApplicable && !this.encounteredRequiredPermit) {
            return this.NOTAPPLICABLE;
        }
        return this.PERMIT;
    }

    private void invokeCommit() throws IdentityTrustException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            IdentityTrustModule module = (IdentityTrustModule)this.modules.get(i);
            boolean bool = module.commit();
            if (bool) continue;
            throw new IdentityTrustException("commit on modules failed");
        }
    }

    private void invokeAbort() throws IdentityTrustException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            IdentityTrustModule module = (IdentityTrustModule)this.modules.get(i);
            boolean bool = module.abort();
            if (bool) continue;
            throw new IdentityTrustException("abort on modules failed");
        }
    }
}

