/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.audit;

import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.security.audit.AuditContext;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.audit.AuditProvider;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.audit.providers.LogAuditProvider;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.plugins.audit.JBossAuditContext;
import org.jboss.security.plugins.authorization.SecurityActions;

public class JBossAuditManager
implements AuditManager {
    private static Logger log = Logger.getLogger(JBossAuditManager.class);
    private static ConcurrentHashMap<String, AuditContext> contexts = new ConcurrentHashMap();
    private static AuditContext defaultContext = null;
    private String securityDomain;

    public JBossAuditManager(String secDomain) {
        this.securityDomain = secDomain;
    }

    public AuditContext getAuditContext() throws PrivilegedActionException {
        AuditContext ac = contexts.get(this.securityDomain);
        if (ac == null) {
            AuditInfo ai;
            ac = new JBossAuditContext(this.securityDomain);
            ApplicationPolicy ap = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
            if (ap != null && (ai = ap.getAuditInfo()) != null) {
                AuditProviderEntry[] apeArr = ai.getAuditProviderEntry();
                List<AuditProviderEntry> list = Arrays.asList(apeArr);
                for (AuditProviderEntry ape : list) {
                    String pname = ape.getName();
                    try {
                        ac.addProvider((AuditProvider)SecurityActions.loadClass(pname).newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (ac == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("No audit Context found for " + this.securityDomain + " ; defaulting to" + " audit context for other"));
            }
            ac = defaultContext;
        }
        return ac;
    }

    public static AuditContext getAuditContext(String securityDomain) {
        AuditContext ac = contexts.get(securityDomain);
        if (ac == null) {
            ac = defaultContext;
        }
        return ac;
    }

    public static void addAuditContext(String securityDomain, AuditContext ac) {
        contexts.put(securityDomain, ac);
    }

    public void audit(AuditEvent ae) {
        AuditContext ac = null;
        try {
            ac = this.getAuditContext();
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        ac.audit(ae);
    }

    static {
        defaultContext = new JBossAuditContext("Default_Context");
        defaultContext.addProvider((AuditProvider)new LogAuditProvider());
    }
}

