/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class AltClientLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private boolean useFirstPass;
    private String username;
    private char[] password = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String passwordStacking;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String mt = (String)options.get("multi-threaded");
        if (mt != null && Boolean.valueOf(mt).booleanValue()) {
            SecurityAssociation.setServer();
        }
        this.useFirstPass = (passwordStacking = (String)options.get("password-stacking")) != null;
    }

    public boolean login() throws LoginException {
        if (this.useFirstPass) {
            return true;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        NameCallback nc = new NameCallback("User name: ", "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                pc.clearPassword();
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        Principal p = null;
        Object credential = this.password;
        if (this.useFirstPass) {
            Object user = this.sharedState.get("javax.security.auth.login.name");
            if (!(user instanceof Principal)) {
                this.username = user != null ? user.toString() : "";
                p = new SimplePrincipal(this.username);
            } else {
                p = (Principal)user;
            }
            credential = this.sharedState.get("javax.security.auth.login.password");
        } else {
            p = new SimplePrincipal(this.username);
        }
        if (!principals.isEmpty()) {
            p = principals.iterator().next();
        }
        SecurityAssociation.setPrincipal(p);
        SecurityAssociation.setCredential(credential);
        SecurityAssociation.setSubject(this.subject);
        return true;
    }

    public boolean abort() throws LoginException {
        int length = this.password != null ? this.password.length : 0;
        int n = 0;
        while (n < length) {
            this.password[n] = '\u0000';
            ++n;
        }
        SecurityAssociation.clear();
        return true;
    }

    public boolean logout() throws LoginException {
        SecurityAssociation.clear();
        return true;
    }
}

