/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigUtil {
    public static AuthenticationInfo parseAuthentication(Element policy) throws Exception {
        NodeList authentication = policy.getElementsByTagName("authentication");
        if (authentication.getLength() == 0) {
            return null;
        }
        Element auth = (Element)authentication.item(0);
        NodeList modules = auth.getElementsByTagName("login-module");
        ArrayList tmp = new ArrayList();
        int n = 0;
        while (n < modules.getLength()) {
            Element module = (Element)modules.item(n);
            ConfigUtil.parseModule(module, tmp);
            ++n;
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[tmp.size()];
        tmp.toArray(entries);
        AuthenticationInfo info = new AuthenticationInfo();
        info.setAppConfigurationEntry(entries);
        return info;
    }

    static void parseModule(Element module, ArrayList entries) throws Exception {
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        String className = module.getAttribute("code");
        String flag = module.getAttribute("flag");
        if (flag != null) {
            flag = flag.toLowerCase();
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        NodeList opts = module.getElementsByTagName("module-option");
        HashMap<String, String> options = new HashMap<String, String>();
        int n = 0;
        while (n < opts.getLength()) {
            Element opt = (Element)opts.item(n);
            String name = opt.getAttribute("name");
            String value = ConfigUtil.getContent(opt, "");
            options.put(name, value);
            ++n;
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(className, controlFlag, options);
        entries.add(entry);
    }

    static String getContent(Element element, String defaultContent) {
        NodeList children = element.getChildNodes();
        String content = defaultContent;
        if (children.getLength() > 0) {
            content = "";
            int n = 0;
            while (n < children.getLength()) {
                content = children.item(n).getNodeType() == 3 || children.item(n).getNodeType() == 4 ? content + children.item(n).getNodeValue() : content + children.item(n).getFirstChild();
                ++n;
            }
            return content.trim();
        }
        return content;
    }
}

