/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.logging.Logger;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.ConfigUtil;
import org.jboss.security.auth.login.SunConfigParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLLoginConfigImpl
extends Configuration {
    private static final String DEFAULT_APP_CONFIG_NAME = "other";
    private static final AuthPermission REFRESH_PERM = new AuthPermission("refreshLoginConfiguration");
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$auth$login$XMLLoginConfigImpl == null ? (class$org$jboss$security$auth$login$XMLLoginConfigImpl = XMLLoginConfigImpl.class$("org.jboss.security.auth.login.XMLLoginConfigImpl")) : class$org$jboss$security$auth$login$XMLLoginConfigImpl));
    protected Map appConfigs = Collections.synchronizedMap(new HashMap());
    protected URL loginConfigURL;
    protected Configuration parentConfig;
    private boolean validateDTD = true;
    static /* synthetic */ Class class$org$jboss$security$auth$login$XMLLoginConfigImpl;

    public void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        this.appConfigs.clear();
        this.loadConfig();
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        if (this.loginConfigURL == null) {
            this.loadConfig();
        }
        AppConfigurationEntry[] entry = null;
        AuthenticationInfo authInfo = (AuthenticationInfo)this.appConfigs.get(appName);
        if (authInfo == null) {
            if (this.parentConfig != null) {
                entry = this.parentConfig.getAppConfigurationEntry(appName);
            }
            if (entry == null) {
                authInfo = (AuthenticationInfo)this.appConfigs.get(DEFAULT_APP_CONFIG_NAME);
            }
        }
        if (authInfo != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("getAppConfigurationEntry(" + appName + "), authInfo=" + authInfo));
            }
            final AuthenticationInfo theAuthInfo = authInfo;
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    return theAuthInfo.copyAppConfigurationEntry();
                }
            };
            entry = (AppConfigurationEntry[])AccessController.doPrivileged(action);
        }
        return entry;
    }

    public URL getConfigURL() {
        return this.loginConfigURL;
    }

    public void setConfigURL(URL loginConfigURL) {
        this.loginConfigURL = loginConfigURL;
    }

    public void setConfigResource(String resourceName) throws IOException {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        this.loginConfigURL = tcl.getResource(resourceName);
        if (this.loginConfigURL == null) {
            throw new IOException("Failed to find resource: " + resourceName);
        }
    }

    public void setParentConfig(Configuration parentConfig) {
        this.parentConfig = parentConfig;
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateDTD(boolean flag) {
        this.validateDTD = flag;
    }

    public void addAppConfig(String appName, AppConfigurationEntry[] entries) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setAppConfigurationEntry(entries);
        this.appConfigs.put(appName, authInfo);
    }

    public void removeAppConfig(String appName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        this.appConfigs.remove(appName);
    }

    public void clear() {
    }

    public void loadConfig() {
        String loginConfig = System.getProperty("java.security.auth.login.config");
        if (loginConfig == null) {
            loginConfig = "login-config.xml";
        }
        if (this.loginConfigURL == null) {
            try {
                this.loginConfigURL = new URL(loginConfig);
            }
            catch (MalformedURLException e) {
                try {
                    this.setConfigResource(loginConfig);
                }
                catch (IOException ignore) {
                    File configFile = new File(loginConfig);
                    try {
                        this.setConfigURL(configFile.toURL());
                    }
                    catch (MalformedURLException ignore2) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.loginConfigURL == null) {
            log.warn((Object)("Failed to find config: " + loginConfig));
            return;
        }
        try {
            this.loadConfig(this.loginConfigURL);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load config: " + this.loginConfigURL), (Throwable)e);
        }
    }

    protected String[] loadConfig(URL config) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REFRESH_PERM);
        }
        ArrayList configNames = new ArrayList();
        log.debug((Object)("Try loading config as XML, url=" + config));
        try {
            this.loadXMLConfig(config, configNames);
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to load config as XML", e);
            log.debug((Object)("Try loading config as Sun format, url=" + config));
            this.loadSunConfig(config, configNames);
        }
        String[] names = new String[configNames.size()];
        configNames.toArray(names);
        return names;
    }

    private void loadSunConfig(URL sunConfig, ArrayList configNames) throws Exception {
        InputStream is = sunConfig.openStream();
        if (is == null) {
            throw new IOException("InputStream is null for: " + sunConfig);
        }
        InputStreamReader configFile = new InputStreamReader(is);
        boolean trace = log.isTraceEnabled();
        SunConfigParser.doParse(configFile, this, trace);
    }

    private void loadXMLConfig(URL loginConfigURL, ArrayList configNames) throws IOException, ParserConfigurationException, SAXException {
        HashMap<String, AuthenticationInfo> tmpAppConfigs = new HashMap<String, AuthenticationInfo>();
        Document doc = this.loadURL(loginConfigURL);
        Element root = doc.getDocumentElement();
        NodeList apps = root.getElementsByTagName("application-policy");
        int n = 0;
        while (n < apps.getLength()) {
            Element appPolicy = (Element)apps.item(n);
            String appName = appPolicy.getAttribute("name");
            log.trace((Object)("Parsing application-policy=" + appName));
            try {
                AuthenticationInfo authInfo = ConfigUtil.parseAuthentication(appPolicy);
                if (authInfo != null) {
                    if (this.appConfigs.containsKey(appName)) {
                        throw new KeyException("Config name: " + appName + "already exists");
                    }
                    tmpAppConfigs.put(appName, authInfo);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse config for entry:" + appName), (Throwable)e);
            }
            ++n;
        }
        configNames.addAll(tmpAppConfigs.keySet());
        this.appConfigs.putAll(tmpAppConfigs);
    }

    private Document loadURL(URL configURL) throws IOException, ParserConfigurationException, SAXException {
        InputStream is = configURL.openStream();
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() throws FactoryConfigurationError {
                return DocumentBuilderFactory.newInstance();
            }
        };
        DocumentBuilderFactory docBuilderFactory = null;
        docBuilderFactory = (DocumentBuilderFactory)AccessController.doPrivileged(action);
        docBuilderFactory.setValidating(this.validateDTD);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        LocalResolver resolver = new LocalResolver(log);
        docBuilder.setEntityResolver(resolver);
        Document doc = docBuilder.parse(is);
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalResolver
    implements EntityResolver {
        private static final String LOGIN_CIONFIG_PUBLIC_ID = "-//JBoss//DTD JBOSS Security Config 3.0//EN";
        private static final String LOGIN_CIONFIG_DTD_NAME = "/org/jboss/metadata/security_config.dtd";
        private Logger log;

        LocalResolver(Logger log) {
            this.log = log;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource is;
            block2: {
                is = null;
                if (!publicId.equals(LOGIN_CIONFIG_PUBLIC_ID)) break block2;
                try {
                    InputStream dtdStream = this.getClass().getResourceAsStream(LOGIN_CIONFIG_DTD_NAME);
                    is = new InputSource(dtdStream);
                }
                catch (Exception ex) {
                    this.log.warn((Object)("Failed to resolve DTD publicId: " + publicId));
                }
            }
            return is;
        }
    }
}

