/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Listener;
import com.arjuna.ats.internal.arjuna.recovery.WorkerService;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PeriodicRecovery
extends Thread {
    private static Vector _recoveryModules;
    private static int _backoffPeriod;
    private static int _recoveryPeriod;
    private static final int _defaultBackoffPeriod = 10;
    private static final int _defaultRecoveryPeriod = 120;
    private static int _currentState;
    private static Object _stateLock;
    private static SimpleDateFormat _theTimestamper;
    private static ServerSocket _socket;
    private static Listener _listener;
    private static WorkerService _workerService;
    private Object _suspendLock;
    private Object _signal;

    public PeriodicRecovery(boolean threaded) {
        block3: {
            this._suspendLock = new Object();
            this._signal = new Object();
            this.initialise();
            PeriodicRecovery.loadModules();
            try {
                _workerService = new WorkerService(this);
                _listener = new Listener(PeriodicRecovery.getServerSocket(), (Service)_workerService);
                _listener.setDaemon(true);
            }
            catch (Exception ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_9", new Object[]{ex});
            }
        }
        if (threaded) {
            this.start();
        }
        _listener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        Object object = _stateLock;
        synchronized (object) {
            return _currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int s) {
        Object object = _stateLock;
        synchronized (object) {
            _currentState = s;
        }
    }

    public void shutdown() {
        this.setStatus(2);
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendScan(boolean async) {
        Object object = this._signal;
        synchronized (object) {
            this.setStatus(3);
            this.interrupt();
            if (!async) {
                try {
                    this._signal.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeScan() {
        if (this.getStatus() == 3) {
            this.setStatus(1);
            Object object = this._suspendLock;
            synchronized (object) {
                this._suspendLock.notify();
            }
        }
    }

    public static final ServerSocket getServerSocket() throws IOException {
        if (_socket == null) {
            int port;
            block4: {
                String tsmPortStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.recovery.recoveryPort");
                port = 0;
                if (tsmPortStr != null) {
                    try {
                        port = Integer.parseInt(tsmPortStr);
                    }
                    catch (Exception ex) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block4;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_8", new Object[]{ex});
                    }
                }
            }
            _socket = new ServerSocket(port);
        }
        return _socket;
    }

    public void run() {
        boolean finished = false;
        do {
            this.checkSuspended();
        } while (!(finished = this.doWork(true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean doWork(boolean periodic) {
        RecoveryModule m;
        boolean interrupted = false;
        Object object = _stateLock;
        synchronized (object) {
            if (this.getStatus() != 1) {
                if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                    tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_10", new Object[]{new Integer(this.getStatus())});
                }
                return false;
            }
            this.setStatus(4);
        }
        tsLogger.arjLogger.info("Periodic recovery - first pass <" + _theTimestamper.format(new Date()) + ">");
        Enumeration modules = _recoveryModules.elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            m.periodicWorkFirstPass();
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
        if (interrupted) {
            interrupted = false;
            _workerService.signalDone();
        }
        try {
            Thread.sleep(_backoffPeriod * 1000);
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        if (this.getStatus() == 2) {
            return true;
        }
        this.checkSuspended();
        this.setStatus(4);
        tsLogger.arjLogger.info("Periodic recovery - second pass <" + _theTimestamper.format(new Date()) + ">");
        modules = _recoveryModules.elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            m.periodicWorkSecondPass();
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
        try {
            if (!interrupted && periodic) {
                Thread.sleep(_recoveryPeriod * 1000);
            }
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        if (this.getStatus() == 2) {
            return true;
        }
        this.checkSuspended();
        this.setStatus(1);
        return false;
    }

    public final void addModule(RecoveryModule module) {
        _recoveryModules.add(module);
    }

    public final Vector getModules() {
        return _recoveryModules;
    }

    private static final void loadModules() {
        Properties properties = arjPropertyManager.propertyManager.getProperties();
        if (properties != null) {
            String attrName;
            Vector<String> moduleNames = new Vector<String>();
            Enumeration<Object> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                int position;
                attrName = (String)names.nextElement();
                if (!attrName.startsWith("com.arjuna.ats.arjuna.recovery.recoveryExtension")) continue;
                for (position = 0; position < moduleNames.size() && attrName.compareTo((String)moduleNames.elementAt(position)) > 0; ++position) {
                }
                moduleNames.add(position, attrName);
            }
            names = moduleNames.elements();
            while (names.hasMoreElements()) {
                attrName = (String)names.nextElement();
                PeriodicRecovery.loadModule(properties.getProperty(attrName));
            }
        }
    }

    private static final void loadModule(String className) {
        block12: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 1L, 2048L, "Loading recovery module " + className);
            }
            if (className == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_1");
                }
                return;
            }
            try {
                Class<?> c;
                block11: {
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    try {
                        RecoveryModule m = (RecoveryModule)c.newInstance();
                        _recoveryModules.add(m);
                    }
                    catch (ClassCastException e) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_2", new Object[]{className});
                        }
                    }
                    catch (IllegalAccessException iae) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_3", new Object[]{iae});
                        }
                    }
                    catch (InstantiationException ie) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block11;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_4", new Object[]{ie});
                    }
                }
                c = null;
            }
            catch (ClassNotFoundException cnfe) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block12;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_5", new Object[]{className});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSuspended() {
        Object object = this._signal;
        synchronized (object) {
            this._signal.notify();
        }
        if (this.getStatus() == 3) {
            while (this.getStatus() == 3) {
                try {
                    object = this._suspendLock;
                    synchronized (object) {
                        this._suspendLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            this.setStatus(1);
        }
    }

    private final void initialise() {
        _recoveryModules = new Vector();
        this.setStatus(1);
    }

    static {
        block9: {
            block8: {
                _recoveryModules = null;
                _backoffPeriod = 0;
                _recoveryPeriod = 0;
                _currentState = 0;
                _stateLock = new Object();
                _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
                _socket = null;
                _listener = null;
                _workerService = null;
                _recoveryPeriod = 120;
                String recoveryPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod");
                if (recoveryPeriodString != null) {
                    try {
                        Integer recoveryPeriodInteger = new Integer(recoveryPeriodString);
                        _recoveryPeriod = recoveryPeriodInteger;
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 1L, 2048L, "com.arjuna.ats.arjuna.recovery.PeriodicRecovery: Recovery period set to " + _recoveryPeriod + " seconds");
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block8;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_6", new Object[]{"com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod", recoveryPeriodString});
                    }
                }
            }
            _backoffPeriod = 10;
            String backoffPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod");
            if (backoffPeriodString != null) {
                try {
                    Integer backoffPeriodInteger = new Integer(backoffPeriodString);
                    _backoffPeriod = backoffPeriodInteger;
                    if (tsLogger.arjLogger.isDebugEnabled()) {
                        tsLogger.arjLogger.debug(16L, 1L, 2048L, "PeriodicRecovery: Backoff period set to " + _backoffPeriod + " seconds");
                    }
                }
                catch (NumberFormatException e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block9;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_7", new Object[]{"com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod", backoffPeriodString});
                }
            }
        }
    }

    public class State {
        public static final int created = 0;
        public static final int active = 1;
        public static final int terminated = 2;
        public static final int suspended = 3;
        public static final int scanning = 4;

        private State() {
        }
    }
}

