/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.coordinator;

import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class ReaperElement
implements Comparable<ReaperElement> {
    public Reapable _control;
    private long _absoluteTimeoutMills;
    private int _bias;
    private static int MAX_BIAS = 1000000;
    private static AtomicInteger biasCounter = new AtomicInteger();
    public int _timeout;
    public int _status;
    public Thread _worker;
    public static final int RUN = 0;
    public static final int SCHEDULE_CANCEL = 1;
    public static final int CANCEL = 2;
    public static final int CANCEL_INTERRUPTED = 3;
    public static final int FAIL = 4;
    public static final int COMPLETE = 5;
    public static final int ZOMBIE = 6;

    public ReaperElement(Reapable control, int timeout) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(1L, 4L, 1L, "ReaperElement::ReaperElement ( " + control + ", " + timeout + " )");
        }
        this._control = control;
        this._timeout = timeout;
        this._status = 0;
        this._worker = null;
        this._absoluteTimeoutMills = (long)(timeout * 1000) + System.currentTimeMillis();
        this._bias = ReaperElement.getBiasCounter();
    }

    public String toString() {
        return "ReaperElement < " + this._control + ", " + this._timeout + ", " + this.statusName() + ", " + this._worker + " >";
    }

    @Override
    public int compareTo(ReaperElement other) {
        if (this == other) {
            return 0;
        }
        if (this._absoluteTimeoutMills == other._absoluteTimeoutMills) {
            if (this._bias == other._bias) {
                if (this._control.get_uid().equals(other._control.get_uid())) {
                    return 0;
                }
                if (this._control.get_uid().greaterThan(other._control.get_uid())) {
                    return 1;
                }
                return -1;
            }
            return this._bias > other._bias ? 1 : -1;
        }
        return this._absoluteTimeoutMills > other._absoluteTimeoutMills ? 1 : -1;
    }

    private static int getBiasCounter() {
        int value = 0;
        do {
            if ((value = biasCounter.getAndIncrement()) != MAX_BIAS) continue;
            biasCounter.set(0);
        } while (value >= MAX_BIAS);
        return value;
    }

    public final String statusName() {
        switch (this._status) {
            case 0: {
                return "RUN";
            }
            case 1: {
                return "SCHEDULE_CANCEL";
            }
            case 2: {
                return "CANCEL";
            }
            case 3: {
                return "CANCEL_INTERRUPTED";
            }
            case 4: {
                return "FAIL";
            }
            case 5: {
                return "COMPLETE";
            }
            case 6: {
                return "ZOMBIE";
            }
        }
        return "UNKNOWN";
    }

    public long getAbsoluteTimeout() {
        return this._absoluteTimeoutMills;
    }

    public void setAbsoluteTimeout(long absoluteTimeout) {
        this._absoluteTimeoutMills = absoluteTimeout;
    }
}

