/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.propertyservice;

import com.arjuna.common.util.ConfigurationInfo;
import com.arjuna.common.util.FileLocator;
import com.arjuna.common.util.propertyservice.StringPropertyReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesFactory {
    private static volatile Properties defaultProperties = null;

    public static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            PropertiesFactory.initDefaultProperties("com.arjuna.ats.arjuna.common.propertiesFile");
        }
        return defaultProperties;
    }

    public static Properties getPropertiesFromFile(String propertyFileName) {
        String filepath = null;
        try {
            filepath = FileLocator.locateFile(propertyFileName);
            File propertyFile = new File(filepath);
            if (!propertyFile.exists() || !propertyFile.isFile()) {
                throw new RuntimeException("invalid property file " + filepath);
            }
            filepath = propertyFile.getCanonicalPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            URL url = PropertiesFactory.class.getResource("/default-" + propertyFileName);
            if (url == null) {
                throw new RuntimeException("missing property file " + propertyFileName);
            }
            filepath = url.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("invalid property file " + filepath, e);
        }
        Properties properties = null;
        try {
            properties = PropertiesFactory.loadFromFile(filepath);
            properties = PropertiesFactory.applySystemProperties(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to load properties from file " + filepath, e);
        }
        return properties;
    }

    private static Properties applySystemProperties(Properties inputProperties) {
        Properties outputProperties = new Properties(inputProperties);
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            outputProperties.setProperty(key, System.getProperty(key));
        }
        return outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadFromFile(String uri) throws IOException {
        InputStream inputStream = null;
        Properties inputProperties = new Properties();
        Properties outputProperties = new Properties();
        inputStream = new File(uri).exists() ? new FileInputStream(uri) : new URL(uri).openStream();
        try {
            inputProperties.loadFromXML(inputStream);
        }
        finally {
            inputStream.close();
        }
        Enumeration<?> namesEnumeration = inputProperties.propertyNames();
        while (namesEnumeration.hasMoreElements()) {
            String propertyName = (String)namesEnumeration.nextElement();
            String propertyValue = inputProperties.getProperty(propertyName);
            propertyValue = propertyValue.trim();
            propertyValue = StringPropertyReplacer.replaceProperties(propertyValue);
            outputProperties.setProperty(propertyName, propertyValue);
        }
        return outputProperties;
    }

    private static synchronized void initDefaultProperties(String fileNamePropertyKey) {
        if (defaultProperties != null) {
            return;
        }
        String propertyFileName = System.getProperty(fileNamePropertyKey);
        if (propertyFileName == null) {
            propertyFileName = ConfigurationInfo.getPropertiesFile();
        }
        if (propertyFileName == null) {
            throw new RuntimeException("Unable to resolve property file name");
        }
        defaultProperties = PropertiesFactory.getPropertiesFromFile(propertyFileName);
    }
}

